/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.simulateRefund;

import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.rzd.model.RefundTransactionInfo;
import com.gridnine.xtrip.server.ibecorp.rzd.model.RzdReturnStatus;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class UfsRefundAmountResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Element responseEl = (Element)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_RESPONSE_DATA);
        ArrayList<RefundTransactionInfo> result = (ArrayList<RefundTransactionInfo>)ctx.getObject((Enum)IBusRailwayContextKeys.RAILWAY_TRANS_INFO_LIST);
        if (result == null) {
            result = new ArrayList<RefundTransactionInfo>();
            ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TRANS_INFO_LIST, result);
        }
        RefundTransactionInfo transInfo = this.buildRefundTransactionInfo(responseEl);
        result.add(transInfo);
    }

    private RefundTransactionInfo buildRefundTransactionInfo(Element responseEl) {
        RefundTransactionInfo result = new RefundTransactionInfo();
        result.setStatus(RzdReturnStatus.SUCCESS);
        result.setAmount(XHelper.readBigDecimal((Element)responseEl, (String)"Amount"));
        for (Element el : XmlUtil.getElements((Element)responseEl, (String)"Blank")) {
            RefundTransactionInfo.BlankPrice bp = new RefundTransactionInfo.BlankPrice();
            bp.setBlankId(XHelper.readString((Element)el, (String)"@ID"));
            bp.setPrice(XHelper.readBigDecimal((Element)el, (String)"Amount"));
            result.getBlankPrices().add(bp);
        }
        return result;
    }
}

