/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.IBusRailwayContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.common.ticketReservation.RzdReservationTicketingParamsProvider;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.ufs.IBusUfsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.BlankTicketNumberProvider;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.w3c.dom.Element;

public class UfsConfirmTicketResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Element responseEl = (Element)ctx.getMandatoryObject((Enum)IBusUfsContextKeys.UFS_RESPONSE_DATA);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        ctx.putObject((Enum)IBusRailwayContextKeys.RAILWAY_TICKET_RESERVATION_PARAMETERS, (Object)this.buildCreateReservationParams(salesContext, responseEl));
    }

    private RzdReservationTicketingParamsProvider buildCreateReservationParams(final SalesContext salesContext, final Element response) {
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZZ");
        String refExpireDateStr = XHelper.readString((Element)response, (String)"ExpierSetEr");
        final Date refExpireDate = TextUtil.isBlank((String)refExpireDateStr) ? null : dtf.parseDateTime(refExpireDateStr).toDate();
        final boolean withEreg = "1".equals(XHelper.readString((Element)response, (String)"RemoteCheckIn"));
        RzdReservationTicketingParamsProvider result = new RzdReservationTicketingParamsProvider(){

            @Override
            public String getOrderNumber() {
                return XHelper.readString((Element)response, (String)"OrderNum");
            }

            @Override
            public List<? extends BlankTicketNumberProvider> getTicketNumbers() {
                ArrayList<1> tickectNumbers = new ArrayList<1>();
                for (final Element ticketsEl : XmlUtil.getElements((Element)response, (String)"Blank")) {
                    tickectNumbers.add(new BlankTicketNumberProvider(){

                        @Override
                        public String getBlankId() {
                            return XHelper.readString((Element)ticketsEl, (String)"@ID");
                        }

                        @Override
                        public String getTicketNumber() {
                            return XHelper.readString((Element)ticketsEl, (String)"TicketNum");
                        }

                        @Override
                        public boolean isHasEReg() {
                            return withEreg;
                        }
                    });
                }
                return tickectNumbers;
            }

            @Override
            public EntityReference<Person> getAgent() {
                return salesContext.getAgent();
            }

            @Override
            public Date getRefundExpireDate() {
                return refExpireDate;
            }

            @Override
            public Date getERegChangeExpireDate() {
                return null;
            }
        };
        return result;
    }
}

