/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.rules;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.rules.passport.PassportActionSet;
import com.gridnine.xtrip.common.model.rules.passport.PassportPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.passport.Targets;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPassportPropertySet;
import java.util.Collections;
import java.util.Date;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassportRuleHelper {
    private static final Logger log = LoggerFactory.getLogger(PassportRuleHelper.class);

    public static PassportActionSet getPassportRules(Flight flight, SalesContext salesContext) {
        return PassportRuleHelper.getPassportRules(flight, (DictionaryReference<PassengerType>)DictHelper.getAdultPassengerType(), null, salesContext);
    }

    public static PassportActionSet getPassportRules(Flight flight, DictionaryReference<PassengerType> passengerType, Passport passport, SalesContext salesContext) {
        RuleProxy<PassportPropertiesProvider, PassportActionSet> proxy = PassportRuleHelper.createProxy(flight, passengerType, passport, salesContext);
        return PassportRuleHelper.applyRules(proxy, salesContext);
    }

    private static RuleProxy<PassportPropertiesProvider, PassportActionSet> createProxy(Flight flight, DictionaryReference<PassengerType> passengerType, Passport passport, SalesContext salesContext) {
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyDate(new Date());
        proxy.setProxyType(Targets.PASSPORT_AVIA.getId());
        PassportActionSet actionSet = new PassportActionSet();
        proxy.setPropertySet((Object)new FlightPassportPropertySet(flight, passengerType, passport, proxy, salesContext));
        proxy.setActionSet((Object)actionSet);
        return proxy;
    }

    private static PassportActionSet applyRules(RuleProxy<PassportPropertiesProvider, PassportActionSet> proxy, SalesContext salesContext) {
        try {
            RuleSet ruleSet = SalesContextHandler.get().getRules(salesContext);
            RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ruleSet);
            if (log.isDebugEnabled()) {
                for (int i = 0; i < ruleSet.getRules().size(); ++i) {
                    RuleSettings ruleSettings = (RuleSettings)ruleSet.getRules().get(i);
                    if (ruleSettings == null || !proxy.getAppliedRules().contains(ruleSettings.getUid())) continue;
                    String textLogCondition = ruleSettings.getRestrictions().stream().map(e -> "\tcondition: " + e.getProperty().getDisplayName() + " -> " + e.getCondition().getDisplayName() + " -> " + e.getValue()).collect(Collectors.joining("\n"));
                    String textLogAction = ruleSettings.getResults().stream().map(e -> "\taction: " + e.getAction().getDisplayName() + " -> " + e.getValue()).collect(Collectors.joining("\n"));
                    log.debug("Number rule: " + (i + 1) + ": Name rule: " + ruleSettings.getName() + "\n" + textLogCondition + "\n" + textLogAction);
                }
            }
        }
        catch (Exception e2) {
            log.error("failed applying site rules", (Throwable)e2);
        }
        return (PassportActionSet)proxy.getActionSet();
    }
}

