/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.rules;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.ibecorp.rules.PriceDetailActionsSet;
import com.gridnine.xtrip.common.ibecorp.rules.PriceDetailProperty;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import java.util.Collections;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceDetailRuleHelper {
    private static final Logger log = LoggerFactory.getLogger(PriceDetailRuleHelper.class);

    public static PriceDetailActionsSet getPriceDetailDisplay(Reservation reservation, PriceComponentsParameters componentsParameters) {
        RuleProxy<PriceDetailProperty, PriceDetailActionsSet> proxy = PriceDetailRuleHelper.createProxy(new PriceDetailProperty(reservation, componentsParameters.getPriceDetailDisplayArea()));
        return PriceDetailRuleHelper.applyRules(proxy, componentsParameters.getSalesContext());
    }

    public static PriceDetailActionsSet getPriceDetailDisplay(Flight flight, SalesContext salesContext) {
        RuleProxy<PriceDetailProperty, PriceDetailActionsSet> proxy = PriceDetailRuleHelper.createProxy(new PriceDetailProperty(flight, salesContext));
        return PriceDetailRuleHelper.applyRules(proxy, salesContext);
    }

    public static PriceDetailActionsSet getPriceDetailDisplay(HotelOffer offer, SalesContext salesContext) {
        RuleProxy<PriceDetailProperty, PriceDetailActionsSet> proxy = PriceDetailRuleHelper.createProxy(new PriceDetailProperty(offer, salesContext));
        return PriceDetailRuleHelper.applyRules(proxy, salesContext);
    }

    public static PriceDetailActionsSet getPriceDetailDisplay(SearchGdsResponse transferOffer, SalesContext salesContext) {
        RuleProxy<PriceDetailProperty, PriceDetailActionsSet> proxy = PriceDetailRuleHelper.createProxy(new PriceDetailProperty(transferOffer, salesContext));
        return PriceDetailRuleHelper.applyRules(proxy, salesContext);
    }

    private static RuleProxy<PriceDetailProperty, PriceDetailActionsSet> createProxy(PriceDetailProperty property) {
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyDate(new Date());
        proxy.setProxyType(Targets.PRICE_DETAIL_DISPLAY.getId());
        PriceDetailActionsSet actionSet = new PriceDetailActionsSet();
        proxy.setPropertySet((Object)property);
        proxy.setActionSet((Object)actionSet);
        return proxy;
    }

    private static PriceDetailActionsSet applyRules(RuleProxy<PriceDetailProperty, PriceDetailActionsSet> proxy, SalesContext salesContext) {
        try {
            RuleSet ruleSet = SalesContextHandler.get().getRules(salesContext);
            RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ruleSet);
        }
        catch (Exception e) {
            log.error("failed applying site rules", (Throwable)e);
        }
        return (PriceDetailActionsSet)proxy.getActionSet();
    }
}

