/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sap.LogContent;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapIntegrationSettings;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocument;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocumentType;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapSyncStatus;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class SapIntegrationHelper {
    public static final String DB_PROPS_SAP_LAST_DATE_UPDATED = "sap.last_date_update";
    public static final String ERROR_TEXT = "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430";
    public static final String SAP_NOTIFICATION = "SAP notification";
    public static final String SAP_REQUEST = "SAP request";
    public static final String SAP_RESPONSE = "SAP response";
    public static final String CALLBACK_CORTEOS = "Corteos callback";
    public static final String CORTEOS_GET_RESERVE_DETAILS = "Corteos get reservation details";
    public static final String CORTEOS_MANAGE_RESERVATION = "Corteos manage reservation";
    private static final ThreadLocal<SimpleDateFormat> BIRTHDAY_DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));

    public static SimpleDateFormat getBirthdayDateFormat() {
        return BIRTHDAY_DATE_FORMAT.get();
    }

    public static boolean hasEnabledSapIntegrationSettings() {
        return SapIntegrationHelper.getAllSapSettings().stream().anyMatch(SapIntegrationSettings::isEnabled);
    }

    public static PersonCostCode createPersonCostCode(EntityReference<Organization> organizationRef, CostCodeProperties costCodeProperties, String sapUdidValue) {
        PersonCostCode code = new PersonCostCode();
        if (TextUtil.nonBlank((String)sapUdidValue)) {
            code.setValue(sapUdidValue);
            code.setLocalValue(sapUdidValue);
            code.setEnglishValue(sapUdidValue);
        }
        code.setOrganization(organizationRef);
        code.setCostCodeProperties(costCodeProperties);
        return code;
    }

    public static Set<SapIntegrationSettings> getAllSapSettings() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityType", (Object)SapIntegrationSettings.class.getName()));
        return EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData().stream().map(it -> (SapIntegrationSettings)EntityStorage.get().resolve(it.getSource()).getEntity()).collect(Collectors.toSet());
    }

    public static byte[] readRequest(InputStream inputStream) throws IOException, UnsupportedCharsetException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IoUtil.copyStream((InputStream)inputStream, (OutputStream)outputStream, (int)256);
        return outputStream.toByteArray();
    }

    public static SapLogDocument getSapLogDocument(SapLogDocumentType documentType, Integer complexReserveId, Integer reserveId) {
        SapLogDocument sapLogDocument = new SapLogDocument();
        sapLogDocument.setType(documentType);
        sapLogDocument.setIdReserve(reserveId);
        sapLogDocument.setIdComplexReserve(complexReserveId);
        return sapLogDocument;
    }

    public static Gender getGender(String genderCode) {
        if (!TextUtil.isBlank((String)genderCode)) {
            if (genderCode.equalsIgnoreCase("\u0433-\u043d")) {
                return Gender.MALE;
            }
            if (genderCode.equalsIgnoreCase("\u0433-\u0436\u0430")) {
                return Gender.FEMALE;
            }
        }
        return null;
    }

    public static void computeIfAbsentEmployeeCategoryToOrganization(EmployeeCategory category, EntityReference<Organization> organizationRef) {
        EntityContainer org = EntityStorage.get().resolve(organizationRef);
        if (org != null && ((Organization)org.getEntity()).getEmployeeCategories().stream().noneMatch(c -> GeneralProductHelper.isEmployeeCategoriesEquals((EmployeeCategory)c, (EmployeeCategory)category))) {
            ((Organization)org.getEntity()).getEmployeeCategories().add(category);
            org.getVersionInfo().setDataSource("sap-sync");
            org.getVersionInfo().setVersionNotes(SapSyncStatus.MODIFY.name());
            EntityStorage.get().save(org, true);
        }
    }

    public static LogContent getLogContent(byte[] content, String contentType) {
        LogContent logContent = new LogContent();
        logContent.setDate(new Date());
        logContent.setType(contentType);
        logContent.setContent(content);
        return logContent;
    }

    public static byte[] marshall(JAXBContext context, Object object) throws JAXBException {
        Objects.requireNonNull(context);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        context.createMarshaller().marshal(object, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static void authorizeInStorage() throws Exception {
        LogicalStorage.get().authorizeAsSystem();
    }
}

