/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap;

import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapIntegrationSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.ContentEncoding;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import com.gridnine.xtrip.server.jibxws.WsRequest;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.jibx.ws.http.client.Basic;
import org.jibx.ws.http.client.Credentials;

public class SapWsRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Object payload = ctx.getObject((Enum)IBusSapIntegrationContextKeys.SAP_WS_REQUEST_PAYLOAD);
        Basic authorization = (Basic)ctx.getObject((Enum)IBusSapIntegrationContextKeys.SAP_WS_AUTHORIZATION);
        String serverAddress = (String)ctx.getObject((Enum)IBusSapIntegrationContextKeys.ENDPOINT);
        SapIntegrationSettings setting = (SapIntegrationSettings)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.INTEGRATION_SETTING);
        WsRequest request = new WsRequest();
        request.setPayload(payload);
        request.setAcceptEncoding(EnumSet.allOf(ContentEncoding.class));
        request.setEndpointAddress(serverAddress);
        request.setCredentials((Credentials)authorization);
        request.addHttpHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])(TextUtil.nonBlankStr((String)setting.getLogin()) + ":" + TextUtil.nonBlankStr((String)setting.getPassword())).getBytes()));
        String uuid = UUIDUtil.toString((UUID)UUID.randomUUID());
        request.setHttpHeader("X-Midoffice-Id", uuid);
        request.setEndpointAddress(String.format("%s&midoffice_id=%s", request.getEndpointAddress(), uuid));
        request.setReadTimeout(Integer.valueOf(300000));
        ctx.putObject((Enum)IBusJibxWsContextKeys.WS_REQUEST, (Object)request);
        ctx.removeObject((Enum)IBusSapIntegrationContextKeys.SAP_WS_REQUEST_PAYLOAD);
        ctx.removeObject((Enum)IBusSapIntegrationContextKeys.SAP_WS_AUTHORIZATION);
        ctx.removeObject((Enum)IBusSapIntegrationContextKeys.ENDPOINT);
    }
}

