/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.getReserv;

import com.gridnine.xtrip.common.gds.ibus.corteos.IbusCorteosContextKeys;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocument;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocumentStatus;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocumentType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sap.SapIntegrationHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.severstal.pi.hcm.travel.getReserv.ArrayOfCustomerCode;
import com.severstal.pi.hcm.travel.getReserv.ArrayOfFileContainer;
import com.severstal.pi.hcm.travel.getReserv.ArrayOfReservationModel;
import com.severstal.pi.hcm.travel.getReserv.ArrayOfString;
import com.severstal.pi.hcm.travel.getReserv.ArrayOfTransportSegment;
import com.severstal.pi.hcm.travel.getReserv.ArrayOfViolation;
import com.severstal.pi.hcm.travel.getReserv.CustomerCode;
import com.severstal.pi.hcm.travel.getReserv.FileContainer;
import com.severstal.pi.hcm.travel.getReserv.GenericServiceResponseOfReservationContainerModel;
import com.severstal.pi.hcm.travel.getReserv.GetReservationDetails;
import com.severstal.pi.hcm.travel.getReserv.GetReservationDetailsResponse;
import com.severstal.pi.hcm.travel.getReserv.HotelOrder;
import com.severstal.pi.hcm.travel.getReserv.Passenger;
import com.severstal.pi.hcm.travel.getReserv.ReservationContainerModel;
import com.severstal.pi.hcm.travel.getReserv.ReservationModel;
import com.severstal.pi.hcm.travel.getReserv.TransportOrder;
import com.severstal.pi.hcm.travel.getReserv.TransportSegment;
import com.severstal.pi.hcm.travel.getReserv.Violation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.corteos.www.ArrayOfPassenger;
import ru.corteos.www.ArrayOfReservationModelV2;
import ru.corteos.www.ArrayOfTransportSegmentV2;
import ru.corteos.www.GenericApiResponseOfReservationContainerModelV2;
import ru.corteos.www.GetReservationDetailsV2Response;
import ru.corteos.www.HotelInfo;
import ru.corteos.www.ReservationContainerModelBaseOfReservationModelV2TransportOrderV2TransportSegmentV2;
import ru.corteos.www.ReservationModelBaseOfTransportOrderV2TransportSegmentV2;
import ru.corteos.www.TransportOrderBaseOfTransportSegmentV2;
import ru.corteos.www.TravelPolicyViolationContainer;

public class SapCorteosGetReservServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SapCorteosGetReservServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        DebugUtil.setThreadName((String)"SapCorteosGetReservServlet");
        SapLogDocument sapLogDocument = new SapLogDocument();
        sapLogDocument.setType(SapLogDocumentType.SAP_GET_RESERVE);
        JAXBContext context = null;
        try {
            context = JAXBContext.newInstance((String)GetReservationDetails.class.getPackage().getName());
            byte[] requestData = SapIntegrationHelper.readRequest((InputStream)req.getInputStream());
            sapLogDocument.getLogContents().add(SapIntegrationHelper.getLogContent(requestData, "SAP request"));
            GetReservationDetails getReservationDetails = (GetReservationDetails)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(requestData));
            sapLogDocument.setIdComplexReserve(Integer.valueOf(getReservationDetails.getIdComplexReserve()));
            sapLogDocument.setIdReserve(Integer.valueOf(getReservationDetails.getIdReserve()));
            Map<String, Object> data = SapCorteosGetReservServlet.buildIbusMessageContext(getReservationDetails);
            try {
                IntegrationBusFacade.get().processRouteSync("corteos:order:get-reservation-details", data);
            }
            finally {
                Object logDocument = data.get(IbusCorteosContextKeys.LOG_DOCUMENT.name());
                if (logDocument instanceof Document) {
                    sapLogDocument.getLogContents().add(SapIntegrationHelper.getLogContent(((Document)logDocument).getContent(), "Corteos get reservation details"));
                }
            }
            GetReservationDetailsV2Response responseCorteos = (GetReservationDetailsV2Response)data.get(IbusCorteosContextKeys.GET_RESERVATION_DETAILS_RESPONSE.name());
            GetReservationDetailsResponse response = SapCorteosGetReservServlet.buildResponse(responseCorteos);
            byte[] responseData = SapIntegrationHelper.marshall(context, response);
            sapLogDocument.getLogContents().add(SapIntegrationHelper.getLogContent(responseData, "SAP response"));
            sapLogDocument.getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"sent to SAP successfully", (Object[])new Object[0]));
            sapLogDocument.setStatus(SapLogDocumentStatus.OK);
            resp.getOutputStream().write(responseData);
            return;
        }
        catch (Throwable t) {
            try {
                UUID errorId = UUID.randomUUID();
                IncidentsHelper.addStackTraceElement((Throwable)t, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"errorId", (String)errorId.toString())});
                log.error("SapCorteosGetReservServlet failed: ", t);
                IncidentsLog.reportException((String)"SapCorteosGetReservServlet failed: ", (Throwable)t);
                sapLogDocument.getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)t, (Object[])new Object[0]));
                sapLogDocument.setStatus(SapLogDocumentStatus.ERROR);
                GetReservationDetailsResponse response = SapCorteosGetReservServlet.buildErrorResponse(t, errorId);
                byte[] responseData = SapIntegrationHelper.marshall(context, response);
                resp.getOutputStream().write(responseData);
                sapLogDocument.getLogContents().add(SapIntegrationHelper.getLogContent(responseData, "SAP response"));
                return;
            }
            catch (Exception e) {
                log.error("SapCorteosGetReservServlet failed: ", (Throwable)e);
                IncidentsLog.reportException((String)"SapCorteosGetReservServlet failed: ", (Throwable)e);
                sapLogDocument.getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)e, (Object[])new Object[0]));
                return;
            }
        }
        finally {
            try {
                SapIntegrationHelper.authorizeInStorage();
                EntityContainer sapLogDocumentCtr = EntityContainer.create((BaseEntity)sapLogDocument);
                sapLogDocumentCtr.getVersionInfo().setDataSource("SapCorteosGetReservServlet");
                EntityStorage.get().save(sapLogDocumentCtr, true);
            }
            catch (Throwable t) {
                log.error("unable to save sap log document", t);
                IncidentsLog.reportException((String)"unable to save sap log document", (Throwable)t);
            }
            finally {
                DebugUtil.restoreThreadName();
            }
        }
    }

    private static Map<String, Object> buildIbusMessageContext(GetReservationDetails getReservationDetails) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(IbusCorteosContextKeys.SIMPLE_RESERVE_ID.name(), getReservationDetails.getIdReserve());
        result.put(IbusCorteosContextKeys.COMPLEX_RESERVE_ID.name(), getReservationDetails.getIdComplexReserve());
        return result;
    }

    private static GetReservationDetailsResponse buildResponse(GetReservationDetailsV2Response responseCorteos) {
        GetReservationDetailsResponse response = new GetReservationDetailsResponse();
        GenericApiResponseOfReservationContainerModelV2 getReservationDetailsResultCorteos = responseCorteos.getGetReservationDetailsV2Result();
        if (getReservationDetailsResultCorteos != null) {
            GenericServiceResponseOfReservationContainerModel getReservationDetailsResult = new GenericServiceResponseOfReservationContainerModel();
            ReservationContainerModelBaseOfReservationModelV2TransportOrderV2TransportSegmentV2 resultCorteos = getReservationDetailsResultCorteos.getResult();
            if (resultCorteos != null) {
                ReservationContainerModel result = new ReservationContainerModel();
                ArrayOfReservationModel reserves = new ArrayOfReservationModel();
                ArrayOfReservationModelV2 reservesCorteos = resultCorteos.getReserves();
                if (reservesCorteos != null) {
                    for (ReservationModelBaseOfTransportOrderV2TransportSegmentV2 modelCorteos : reservesCorteos.getReservationModelV2List()) {
                        ReservationModel reservationModel = new ReservationModel();
                        reservationModel.setIdComplexReserve(modelCorteos.getIdComplexReserve());
                        reservationModel.setIdReserve(modelCorteos.getIdReserve());
                        reservationModel.setIdReserveState(modelCorteos.getIdReserveState());
                        reservationModel.setIdReserveType(modelCorteos.getIdReserveType());
                        reservationModel.setCodes(SapCorteosGetReservServlet.mapCodes(modelCorteos.getCodes()));
                        reservationModel.setComment(modelCorteos.getComment());
                        reservationModel.setCreationDate(modelCorteos.getCreationDate());
                        reservationModel.setCreationTime(modelCorteos.getCreationTime());
                        reservationModel.setCurrency(modelCorteos.getCurrency());
                        reservationModel.setDateEnd(modelCorteos.getDateEnd());
                        reservationModel.setDateStart(modelCorteos.getDateStart());
                        reservationModel.setHotel(modelCorteos.getHotel() != null ? SapCorteosGetReservServlet.mapHotel(modelCorteos.getHotel()) : null);
                        reservationModel.setFiles(SapCorteosGetReservServlet.mapFiles(modelCorteos.getFiles()));
                        reservationModel.setOptimalPrice(modelCorteos.getOptimalPrice() != null ? modelCorteos.getOptimalPrice() : 0.0);
                        reservationModel.setOptimalPriceCurrency(modelCorteos.getOptimalPriceCurrency());
                        reservationModel.setPassengers(SapCorteosGetReservServlet.mapPassengers(modelCorteos.getPassengers()));
                        reservationModel.setPrice(modelCorteos.getPrice() != null ? modelCorteos.getPrice() : 0.0);
                        reservationModel.setProviderLocator(modelCorteos.getProviderLocator());
                        reservationModel.setTimelimit(modelCorteos.getTimelimit());
                        reservationModel.setTimelimitTime(modelCorteos.getTimelimitTime());
                        reservationModel.setTransport(modelCorteos.getTransport() != null ? SapCorteosGetReservServlet.mapTransport(modelCorteos.getTransport()) : null);
                        reservationModel.setTravelPolicy(modelCorteos.getTravelPolicy() != null ? SapCorteosGetReservServlet.mapTravelPolicy(modelCorteos.getTravelPolicy()) : null);
                        reserves.getReservationModel().add(reservationModel);
                    }
                }
                result.setReserves(reserves);
                result.setName(resultCorteos.getName());
                getReservationDetailsResult.setResult(result);
            }
            ArrayOfString arrayOfString = new ArrayOfString();
            if (getReservationDetailsResultCorteos.getErrors() != null && getReservationDetailsResultCorteos.getErrors().getStringList() != null) {
                arrayOfString.getString().addAll(getReservationDetailsResultCorteos.getErrors().getStringList());
            }
            getReservationDetailsResult.setErrors(arrayOfString);
            getReservationDetailsResult.setWarnings(null);
            getReservationDetailsResult.setResponseComment(responseCorteos.getGetReservationDetailsV2Result() != null ? responseCorteos.getGetReservationDetailsV2Result().getAugmentationData() : null);
            response.setGetReservationDetailsResult(getReservationDetailsResult);
        }
        return response;
    }

    private static com.severstal.pi.hcm.travel.getReserv.TravelPolicyViolationContainer mapTravelPolicy(TravelPolicyViolationContainer travelPolicy) {
        com.severstal.pi.hcm.travel.getReserv.TravelPolicyViolationContainer container = new com.severstal.pi.hcm.travel.getReserv.TravelPolicyViolationContainer();
        container.setHasViolations(travelPolicy.isHasViolations());
        container.setViolations(SapCorteosGetReservServlet.mapViolations(travelPolicy.getViolations()));
        return container;
    }

    private static ArrayOfViolation mapViolations(ru.corteos.www.ArrayOfViolation violations) {
        ArrayOfViolation arrayOfViolation = new ArrayOfViolation();
        if (violations != null && violations.getViolationList() != null) {
            arrayOfViolation.getViolation().addAll(violations.getViolationList().stream().map(violation -> {
                Violation violationSap = new Violation();
                violationSap.setPolicy(violation.getPolicy());
                violationSap.setViolationText(violation.getViolationText());
                return violationSap;
            }).collect(Collectors.toList()));
        }
        return arrayOfViolation;
    }

    private static TransportOrder mapTransport(TransportOrderBaseOfTransportSegmentV2 transport) {
        TransportOrder transportOrder = new TransportOrder();
        transportOrder.setSelectedTransport(SapCorteosGetReservServlet.mapTransportSegment(transport.getSelectedTransport()));
        transportOrder.setOptimalTransport(SapCorteosGetReservServlet.mapTransportSegment(transport.getOptimalTransport()));
        return transportOrder;
    }

    private static ArrayOfTransportSegment mapTransportSegment(ArrayOfTransportSegmentV2 corteosTransport) {
        ArrayOfTransportSegment arrayOfTransportSegment = new ArrayOfTransportSegment();
        if (corteosTransport != null && corteosTransport.getTransportSegmentV2List() != null) {
            arrayOfTransportSegment.getTransportSegment().addAll(corteosTransport.getTransportSegmentV2List().stream().map(transportSegment -> {
                TransportSegment segment = new TransportSegment();
                segment.setVendorCode(transportSegment.getVendorCode());
                segment.setNumber(transportSegment.getNumber());
                segment.setOriginCode(transportSegment.getOriginCode());
                segment.setOriginName(transportSegment.getOriginName());
                segment.setDestinationCode(transportSegment.getDestinationCode());
                segment.setDestinationName(transportSegment.getDestinationName());
                segment.setDepartureDate(transportSegment.getDepartureDate());
                segment.setDepartureTime(transportSegment.getDepartureTime());
                segment.setArrivalDate(transportSegment.getArrivalDate());
                segment.setArrivalTime(transportSegment.getArrivalTime());
                segment.setRBD(transportSegment.getRBD());
                segment.setFareBasis(transportSegment.getFareBasis());
                segment.setTransportCategoryName(transportSegment.getTransportCategoryName());
                return segment;
            }).collect(Collectors.toList()));
        }
        return arrayOfTransportSegment;
    }

    private static com.severstal.pi.hcm.travel.getReserv.ArrayOfPassenger mapPassengers(ArrayOfPassenger corteosPassengers) {
        com.severstal.pi.hcm.travel.getReserv.ArrayOfPassenger passengers = new com.severstal.pi.hcm.travel.getReserv.ArrayOfPassenger();
        if (corteosPassengers != null && corteosPassengers.getPassengerList() != null) {
            passengers.getPassenger().addAll(corteosPassengers.getPassengerList().stream().map(corteosPassenger -> {
                Passenger passenger = new Passenger();
                passenger.setIdPerson(corteosPassenger.getIdPerson());
                passenger.setIdPassenger(corteosPassenger.getIdPassenger());
                passenger.setLastName(corteosPassenger.getLastName());
                passenger.setFirstName(corteosPassenger.getFirstName());
                passenger.setDocument(corteosPassenger.getDocument());
                passenger.setCodes(SapCorteosGetReservServlet.mapCodes(corteosPassenger.getCodes()));
                return passenger;
            }).collect(Collectors.toList()));
        }
        return passengers;
    }

    private static HotelOrder mapHotel(ru.corteos.www.HotelOrder hotel) {
        HotelOrder hotelOrder = new HotelOrder();
        hotelOrder.setSelectedHotel(SapCorteosGetReservServlet.mapHotelInfo(hotel.getSelectedHotel()));
        hotelOrder.setOptimalHotel(SapCorteosGetReservServlet.mapHotelInfo(hotel.getOptimalHotel()));
        return hotelOrder;
    }

    private static com.severstal.pi.hcm.travel.getReserv.HotelInfo mapHotelInfo(HotelInfo corteosHotelInfo) {
        com.severstal.pi.hcm.travel.getReserv.HotelInfo hotelInfo = new com.severstal.pi.hcm.travel.getReserv.HotelInfo();
        if (corteosHotelInfo != null) {
            hotelInfo.setHotelCity(corteosHotelInfo.getHotelCity());
            hotelInfo.setHotelName(corteosHotelInfo.getHotelName());
            hotelInfo.setRoomName(corteosHotelInfo.getRoomName());
            hotelInfo.setStars(corteosHotelInfo.getStars());
            if (corteosHotelInfo.getIs3D() != null) {
                hotelInfo.setIs3D(Boolean.valueOf(Boolean.parseBoolean(corteosHotelInfo.getIs3D())));
            }
            hotelInfo.setCancelationInfo(corteosHotelInfo.getCancelationInfo());
        }
        return hotelInfo;
    }

    private static ArrayOfFileContainer mapFiles(ru.corteos.www.ArrayOfFileContainer corteosFiles) {
        ArrayOfFileContainer container = new ArrayOfFileContainer();
        if (corteosFiles.getFileContainerList() != null) {
            container.getFileContainer().addAll(corteosFiles.getFileContainerList().stream().map(fileContainerCorteos -> {
                FileContainer fileContainer = new FileContainer();
                fileContainer.setCaption(fileContainerCorteos.getCaption());
                fileContainer.setFileBase64(fileContainerCorteos.getFileBase64());
                fileContainer.setFileExtension(fileContainerCorteos.getFileExtension());
                fileContainer.setIdFile(fileContainerCorteos.getIdFile());
                fileContainer.setIsTravellerDocument(fileContainerCorteos.isIsTravellerDocument());
                fileContainer.setReserveType(fileContainerCorteos.getReserveType());
                fileContainer.setSupplierDocumentId(fileContainerCorteos.getSupplierDocumentId());
                fileContainer.setToken(fileContainerCorteos.getToken());
                return fileContainer;
            }).collect(Collectors.toList()));
        }
        return container;
    }

    private static ArrayOfCustomerCode mapCodes(ru.corteos.www.ArrayOfCustomerCode codesCorteos) {
        ArrayOfCustomerCode codes = new ArrayOfCustomerCode();
        if (codesCorteos != null && codesCorteos.getCustomerCodeList() != null) {
            codes.getCustomerCode().addAll(codesCorteos.getCustomerCodeList().stream().map(codeCorteos -> {
                CustomerCode code = new CustomerCode();
                code.setDictionaryName(codeCorteos.getDictionaryName());
                code.setCode(codeCorteos.getCode());
                code.setIdPerson((Integer)Optional.of(codeCorteos.getIdPerson()).filter(TextUtil::nonBlank).map(Integer::valueOf).orElse(null));
                return code;
            }).collect(Collectors.toList()));
        }
        return codes;
    }

    private static GetReservationDetailsResponse buildErrorResponse(Throwable t, UUID errorId) {
        GetReservationDetailsResponse response = new GetReservationDetailsResponse();
        GenericServiceResponseOfReservationContainerModel getReservationDetailsResult = new GenericServiceResponseOfReservationContainerModel();
        ArrayOfString errors = new ArrayOfString();
        errors.getString().add(t.getMessage());
        errors.getString().add("errorId=".concat(errorId.toString()));
        getReservationDetailsResult.setErrors(errors);
        response.setGetReservationDetailsResult(getReservationDetailsResult);
        return response;
    }
}

