/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.order;

import com.gridnine.xtrip.common.gds.ibus.corteos.IbusCorteosContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapCostCodeCategoryType;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.corteos.ibus.order.CorteosOrderHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.severstal.pi.hcm.travel.DtOrderData;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ru.corteos.ArrayOfStablePassenger;
import ru.corteos.ArrayOfStableSimpleReserve;
import ru.corteos.StableCode;
import ru.corteos.StableComplexReserve;
import ru.corteos.StablePassenger;
import ru.corteos.StableSimpleReserve;

public class SapGetOrderFromCorteosProcessor
extends BaseProcessor {
    /*
     * Enabled aggressive block sorting
     */
    public void process(MessageContext ctx) throws Exception {
        Optional stablePassenger;
        String callBack = (String)ctx.getMandatoryObject((Enum)IbusCorteosContextKeys.CALLBACK_DATA);
        String callBackOperationType = (String)ctx.getMandatoryObject((Enum)IbusCorteosContextKeys.EVENT_TYPE);
        String callBackDescription = (String)ctx.getMandatoryObject((Enum)IbusCorteosContextKeys.EVENT_DESCRIPTION);
        StableComplexReserve complexReserve = (StableComplexReserve)ctx.getObject((Enum)IbusCorteosContextKeys.COMPLEX_RESERVE_CORTEOS);
        Integer simpleReserveId = (Integer)ctx.getObject((Enum)IbusCorteosContextKeys.SIMPLE_RESERVE_ID);
        ArrayList reserveList = new ArrayList();
        ArrayList passengerList = new ArrayList();
        if (complexReserve == null) {
            String message = "ComplexReserve value is 'null'";
            this.log.error(message);
            throw new Exception(message);
        }
        ArrayOfStableSimpleReserve actualOrders = complexReserve.getActualOrders();
        ArrayOfStableSimpleReserve canceledOrders = complexReserve.getCanceledOrders();
        if (actualOrders != null) {
            ArrayList actualOrdersStableSimpleReserves = actualOrders.getStableSimpleReserveList();
            if (actualOrdersStableSimpleReserves == null) {
                actualOrdersStableSimpleReserves = new ArrayList();
            }
            reserveList.addAll(actualOrdersStableSimpleReserves);
        }
        if (canceledOrders != null) {
            ArrayList canceledOrdersStableSimpleReserves = canceledOrders.getStableSimpleReserveList();
            if (canceledOrdersStableSimpleReserves == null) {
                canceledOrdersStableSimpleReserves = new ArrayList();
            }
            reserveList.addAll(canceledOrdersStableSimpleReserves);
        }
        if (simpleReserveId == null) {
            String message = "no found simpleReserveId";
            this.log.error(message);
            throw new Exception(message);
        }
        Optional<StableSimpleReserve> stableSimpleReserve = reserveList.stream().filter(reserve -> simpleReserveId.equals(reserve.getIdReserve())).findFirst();
        if (!stableSimpleReserve.isPresent()) {
            String message = String.format("complexID ='%d' does not contain reserveID = '%d'", complexReserve.getIdComplexReserve(), simpleReserveId);
            this.log.error(message);
            throw new Exception(message);
        }
        StableSimpleReserve simpleReserve = stableSimpleReserve.get();
        ArrayOfStablePassenger passengers = simpleReserve.getPassengers();
        if (passengers != null) {
            passengerList.addAll(passengers.getStablePassengerList());
        }
        if (!(stablePassenger = passengerList.stream().findFirst()).isPresent()) {
            String message = String.format("complexID ='%d', reserveID = '%d' does not contain passengers", simpleReserve.getIdComplexReserve(), simpleReserve.getIdReserve());
            this.log.error(message);
            throw new Exception(message);
        }
        List<StableCode> codes = this.getCodes(simpleReserve, (StablePassenger)stablePassenger.get());
        EntityReference orgRef = CorteosOrderHelper.findClient((StableSimpleReserve)simpleReserve);
        if (orgRef == null) {
            String message = String.format("no organizations were found in mom for CorteosId = %s", simpleReserve.getIdPayerOrganization());
            this.log.error(message);
            throw new Exception(message);
        }
        Organization organization = (Organization)EntityStorage.get().resolve(orgRef).getEntity();
        Optional<CostCodeProperties> pernrCostCodeOpt = organization.getCostCodeProperties().stream().filter(c -> this.getSapCostCodeCategoryType((CostCodeProperties)c) == SapCostCodeCategoryType.EMPLOYEE_ID).findAny();
        Optional<CostCodeProperties> reinrCostCodeOpt = organization.getCostCodeProperties().stream().filter(c -> this.getSapCostCodeCategoryType((CostCodeProperties)c) == SapCostCodeCategoryType.RESERVATION_NUMBER).findAny();
        if (pernrCostCodeOpt.isPresent() && reinrCostCodeOpt.isPresent()) {
            Optional<StableCode> pernrStableCode = codes.stream().filter(stableCode -> TextUtil.isSame((String)stableCode.getDictionaryName(), (String)((CostCodeProperties)pernrCostCodeOpt.get()).getName(), (boolean)true)).findFirst();
            Optional<StableCode> reinrStableCode = codes.stream().filter(stableCode -> TextUtil.isSame((String)stableCode.getDictionaryName(), (String)((CostCodeProperties)reinrCostCodeOpt.get()).getName(), (boolean)true)).findFirst();
            if (pernrStableCode.isPresent() && reinrStableCode.isPresent()) {
                DtOrderData dtOrderData = new DtOrderData();
                dtOrderData.setPERNR(BigInteger.valueOf(this.parseInt(pernrStableCode.get().getCodeValue())));
                dtOrderData.setREINR(new BigDecimal(reinrStableCode.get().getCodeValue()));
                dtOrderData.setComplexID(BigInteger.valueOf(simpleReserve.getIdComplexReserve()));
                dtOrderData.setReserveID(BigInteger.valueOf(simpleReserve.getIdReserve()));
                dtOrderData.setOperationType(callBackOperationType);
                dtOrderData.setDescription(callBackDescription);
                this.log.info(String.format("DtOrderData by complexID ='%d', reserveID = '%d' create created successfully", simpleReserve.getIdComplexReserve(), simpleReserve.getIdReserve()));
                ctx.putObject((Enum)IBusSapIntegrationContextKeys.CONTENT, (Object)callBack);
                ctx.putObject((Enum)IBusSapIntegrationContextKeys.SAP_SIMPLE_INFO_ORDER, (Object)dtOrderData);
                return;
            }
            String message = String.format("complexID ='%d', reserveID = '%d', stableCodes(PERNR and REINR) value isn`t present", simpleReserve.getIdComplexReserve(), simpleReserve.getIdReserve());
            this.log.error(message);
            throw new Exception(message);
        }
        String message = String.format("organization %s does not have UDIDs with the sapType %s and/or %s", organization.getShortName(), SapCostCodeCategoryType.EMPLOYEE_ID.name(), SapCostCodeCategoryType.RESERVATION_NUMBER.name());
        this.log.error(message);
        throw new Exception(message);
    }

    private SapCostCodeCategoryType getSapCostCodeCategoryType(CostCodeProperties codeProperties) {
        CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(codeProperties.getCategory());
        return costCodeCategory != null ? costCodeCategory.getSapType() : null;
    }

    private List<StableCode> getCodes(StableSimpleReserve simpleReserve, StablePassenger stablePassenger) {
        ArrayList<StableCode> codes = new ArrayList<StableCode>();
        if (stablePassenger.getCodes() != null && stablePassenger.getCodes().getStableCodeList() != null) {
            codes.addAll(stablePassenger.getCodes().getStableCodeList());
        }
        if (simpleReserve.getCodes() != null && simpleReserve.getCodes().getStableCodeList() != null) {
            for (StableCode stableCode : simpleReserve.getCodes().getStableCodeList()) {
                if (TextUtil.nonBlank((String)stableCode.getIdPerson()) || codes.stream().anyMatch(code -> TextUtil.isSame((String)code.getDictionaryName(), (String)stableCode.getDictionaryName()))) continue;
                codes.add(stableCode);
            }
        }
        if (simpleReserve.getComplexReserveReference() != null && simpleReserve.getComplexReserveReference().getCodes() != null && simpleReserve.getComplexReserveReference().getCodes().getStableCodeList() != null) {
            for (StableCode stableCode : simpleReserve.getComplexReserveReference().getCodes().getStableCodeList()) {
                if (TextUtil.nonBlank((String)stableCode.getIdPerson()) && !stableCode.getIdPerson().equals(Integer.toString(stablePassenger.getIdPerson())) || codes.stream().anyMatch(code -> TextUtil.isSame((String)code.getDictionaryName(), (String)stableCode.getDictionaryName()))) continue;
                codes.add(stableCode);
            }
        }
        return codes;
    }
}

