/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.order;

import com.gridnine.xtrip.common.gds.ibus.corteos.IbusCorteosContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocument;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocumentStatus;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocumentType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.ibecorp.ibus.sap.SapIntegrationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.nio.charset.StandardCharsets;

public class SapOrderAdvice
extends BaseAdvice {
    public boolean handleException(Throwable error, MessageContext ctx) throws Exception {
        try {
            SapLogDocument logDocument;
            this.log.error("SAP order error", error);
            String callBack = (String)ctx.getObject((Enum)IbusCorteosContextKeys.CALLBACK_DATA);
            Integer simpleReserveId = (Integer)ctx.getObject((Enum)IbusCorteosContextKeys.SIMPLE_RESERVE_ID);
            Integer complexReserveId = (Integer)ctx.getObject((Enum)IbusCorteosContextKeys.COMPLEX_RESERVE_ID);
            Document corteosLogDocument = (Document)ctx.getObject((Enum)IbusCorteosContextKeys.LOG_DOCUMENT);
            EntityContainer sapLogDocumentCtr = (EntityContainer)ctx.getObject((Enum)IBusSapIntegrationContextKeys.SAP_LOG_DOCUMENT_CONTAINER);
            if (sapLogDocumentCtr == null || sapLogDocumentCtr.getEntity() == null) {
                logDocument = SapIntegrationHelper.getSapLogDocument(SapLogDocumentType.CORTEOS_CALLBACK, complexReserveId, simpleReserveId);
                if (callBack != null) {
                    logDocument.getLogContents().add(SapIntegrationHelper.getLogContent(callBack.getBytes(StandardCharsets.UTF_8), "Corteos callback"));
                }
                if (corteosLogDocument != null) {
                    logDocument.getLogContents().add(SapIntegrationHelper.getLogContent(corteosLogDocument.getContent(), "Corteos get reservation details"));
                }
                sapLogDocumentCtr = EntityContainer.create((BaseEntity)logDocument);
            } else {
                logDocument = (SapLogDocument)sapLogDocumentCtr.getEntity();
            }
            logDocument.setStatus(SapLogDocumentStatus.ERROR);
            logDocument.getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)error, (Object[])new Object[0]));
            EntityStorage.get().save(sapLogDocumentCtr, true);
        }
        catch (Throwable ex) {
            this.log.error("SAP order error", ex);
        }
        return true;
    }
}

