/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.orderStatus;

import com.gridnine.xtrip.common.gds.ibus.corteos.IbusCorteosContextKeys;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocument;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocumentStatus;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapLogDocumentType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sap.SapIntegrationHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.severstal.pi.hcm.travel.manageReservation.ManageReservation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapCorteosOrderStatusServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SapCorteosOrderStatusServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        DebugUtil.setThreadName((String)"SapCorteosOrderStatusServlet");
        SapLogDocument sapLogDocument = new SapLogDocument();
        sapLogDocument.setType(SapLogDocumentType.SAP_ORDER_STATUS);
        try {
            JAXBContext context = JAXBContext.newInstance((String)ManageReservation.class.getPackage().getName());
            byte[] requestData = SapIntegrationHelper.readRequest((InputStream)req.getInputStream());
            sapLogDocument.getLogContents().add(SapIntegrationHelper.getLogContent(requestData, "SAP request"));
            ManageReservation manageReservation = (ManageReservation)context.createUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(requestData));
            sapLogDocument.setIdReserve(Integer.valueOf(manageReservation.getIdReserve()));
            Map<String, Object> data = SapCorteosOrderStatusServlet.buildIbusMessageContext(manageReservation);
            try {
                IntegrationBusFacade.get().processRouteSync("corteos:order:manage-reservation", data);
            }
            finally {
                Object logDocument;
                Object complexReserveId = data.get(IbusCorteosContextKeys.COMPLEX_RESERVE_ID.name());
                if (complexReserveId instanceof Integer) {
                    sapLogDocument.setIdComplexReserve((Integer)complexReserveId);
                }
                if ((logDocument = data.get(IbusCorteosContextKeys.LOG_DOCUMENT.name())) instanceof Document) {
                    sapLogDocument.getLogContents().add(SapIntegrationHelper.getLogContent(((Document)logDocument).getContent(), "Corteos manage reservation"));
                }
            }
            sapLogDocument.getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"sent to Corteos successfully", (Object[])new Object[0]));
            sapLogDocument.setStatus(SapLogDocumentStatus.OK);
            return;
        }
        catch (Throwable t) {
            UUID errorId = UUID.randomUUID();
            IncidentsHelper.addStackTraceElement((Throwable)t, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"errorId", (String)errorId.toString())});
            log.error("SapCorteosOrderStatusServlet failed: ", t);
            IncidentsLog.reportException((String)"SapCorteosOrderStatusServlet failed: ", (Throwable)t);
            sapLogDocument.getMessages().add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430", (Throwable)t, (Object[])new Object[0]));
            sapLogDocument.setStatus(SapLogDocumentStatus.ERROR);
            return;
        }
        finally {
            try {
                SapIntegrationHelper.authorizeInStorage();
                EntityContainer sapLogDocumentCtr = EntityContainer.create((BaseEntity)sapLogDocument);
                sapLogDocumentCtr.getVersionInfo().setDataSource("SapCorteosOrderStatusServlet");
                EntityStorage.get().save(sapLogDocumentCtr, true);
            }
            catch (Throwable t) {
                log.error("unable to save sap log document", t);
                IncidentsLog.reportException((String)"unable to save sap log document", (Throwable)t);
            }
            finally {
                DebugUtil.restoreThreadName();
            }
        }
    }

    private static Map<String, Object> buildIbusMessageContext(ManageReservation manageReservation) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(IbusCorteosContextKeys.SIMPLE_RESERVE_ID.name(), manageReservation.getIdReserve());
        result.put(IbusCorteosContextKeys.MANAGE_RESERVATION_ACTION.name(), manageReservation.getAction());
        return result;
    }
}

