/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.person;

import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapBatchOrganizations;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class SapBatchOrganizationsTargetsProvider
extends BaseTargetsProvider<SapBatchOrganizations> {
    public Collection<SapBatchOrganizations> getTargets(MessageContext ctx) throws Exception {
        Boolean orgEnabledSyncExist = (Boolean)ctx.getObject((Enum)IBusSapIntegrationContextKeys.ORGANIZATIONS_WITH_ENABLED_SYNC_EXIST);
        HashSet<SapBatchOrganizations> batches = new HashSet<SapBatchOrganizations>();
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(OrganizationIndex.Property.registrationId.name());
        query.getPreferredProperties().add(OrganizationIndex.Property.kpp.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.sapSyncEnabled.name(), (Object)Boolean.TRUE));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)OrganizationIndex.Property.sapId.name(), null));
        List indexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.ORGANIZATIONS_WITH_ENABLED_SYNC_EXIST, (Object)(!indexes.isEmpty() || Boolean.TRUE.equals(orgEnabledSyncExist) ? 1 : 0));
        for (OrganizationIndex idx : indexes) {
            SapBatchOrganizations batch = batches.stream().filter(b -> TextUtil.equals((String)b.getKpp(), (String)idx.getKpp(), (boolean)true) && TextUtil.equals((String)b.getRegistrationId(), (String)idx.getRegistrationId(), (boolean)true)).findFirst().orElse(null);
            if (batch == null) {
                batch = this.getSapBatchOrganizations(idx);
                batches.add(batch);
            }
            batch.getOrganizations().add(idx.getSource());
        }
        return batches;
    }

    private SapBatchOrganizations getSapBatchOrganizations(OrganizationIndex idx) {
        SapBatchOrganizations batch = new SapBatchOrganizations();
        batch.setKpp(idx.getKpp());
        batch.setRegistrationId(idx.getRegistrationId());
        return batch;
    }
}

