/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.person;

import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class SapChangedPersonsTargetsProvider
extends BaseTargetsProvider<EntityReference<Person>> {
    public Collection<EntityReference<Person>> getTargets(MessageContext ctx) throws Exception {
        List modifiedPersons = (List)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.MODIFIED_PERSONS);
        return modifiedPersons.stream().filter(it -> {
            EntityContainer person = EntityStorageHelper.resolve((EntityReference)it);
            if (person != null) {
                Date corteosSyncDate = ((Person)person.getEntity()).getCorteosSettings().getLastSyncAttemptDate();
                LocalDateTime sapSynDate = ((Person)person.getEntity()).getSapIntegrationSyncData().getSyncDate();
                return MiscUtil.compare((Comparable)DateUtils.toLocalDateTime((Date)corteosSyncDate), (Comparable)sapSynDate) < 0;
            }
            return false;
        }).collect(Collectors.toList());
    }
}

