/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.person;

import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapIntegrationSyncData;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapSyncStatus;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sap.SapIntegrationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.severstal.pi.hcm.travel.DtEmpResponseById;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public class SapCreatePersonProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DtEmpResponseById.Person sapPerson = (DtEmpResponseById.Person)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.SAP_PERSON);
        EntityReference organization = (EntityReference)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.ORGANIZATION);
        Set costCodes = (Set)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.COST_CODES);
        Person person = this.createPerson(sapPerson, (EntityReference<Organization>)organization);
        person.setGender(SapIntegrationHelper.getGender(sapPerson.getANREX()));
        this.setRussianValue(person.getFirstName(), sapPerson.getVORNA());
        this.setRussianValue(person.getLastName(), sapPerson.getNACHN());
        this.setRussianValue(person.getMiddleName(), sapPerson.getMIDNM());
        this.setLatinValue(person.getFirstName(), sapPerson.getVORNAENG());
        this.setLatinValue(person.getLastName(), sapPerson.getNACHNENG());
        this.setLatinValue(person.getMiddleName(), sapPerson.getMIDNMENG());
        person.setBirthday(TextUtil.isBlank((String)sapPerson.getGBDAT()) ? null : SapIntegrationHelper.getBirthdayDateFormat().parse(sapPerson.getGBDAT()));
        String email = sapPerson.getUSRIDLONG();
        if (TextUtil.nonBlank((String)email)) {
            PersonCommunication communication = new PersonCommunication();
            communication.setType(CommunicationType.EMAIL);
            communication.setOrganization(organization);
            communication.setSense(email);
            person.getCommunications().add(communication);
        }
        for (CostCodeProperties costCodeProperties : costCodes) {
            String sapUdidValue;
            CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCodeProperties.getCategory());
            if (costCodeCategory == null) continue;
            switch (costCodeCategory.getSapType()) {
                case EMPLOYEE_ID: {
                    sapUdidValue = MiscUtil.toString((Object)sapPerson.getPERNR());
                    break;
                }
                case EMPLOYER_ID: {
                    sapUdidValue = MiscUtil.toString((Object)sapPerson.getWERKS());
                    break;
                }
                case ASSISTANT_ID: {
                    sapUdidValue = sapPerson.getASSISTList().stream().map(a -> MiscUtil.toString((Object)a.getASSISTPERNR())).findFirst().orElse("");
                    break;
                }
                default: {
                    sapUdidValue = null;
                }
            }
            person.getCostCodes().add(SapIntegrationHelper.createPersonCostCode((EntityReference<Organization>)organization, costCodeProperties, sapUdidValue));
        }
        person.setSapAssistant(BooleanUtil.nullAsFalse((Boolean)sapPerson.getASSISTF()));
        SapIntegrationSyncData syncData = new SapIntegrationSyncData();
        syncData.setStatusSync(SapSyncStatus.CREATE);
        person.setSapIntegrationSyncData(syncData);
        EntityContainer container = EntityContainer.create((BaseEntity)person);
        container.getVersionInfo().setVersionNotes(SapSyncStatus.CREATE.name());
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.PERSON, (Object)container);
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.SKIP_PERSON, (Object)Boolean.FALSE);
    }

    private Person createPerson(DtEmpResponseById.Person sapPerson, EntityReference<Organization> organizationRef) {
        Person person = new Person();
        person.getTypes().clear();
        person.getTypes().add(PersonType.PASSENGER);
        person.setSapId(sapPerson.getUSRID());
        PersonEmployment employment = new PersonEmployment();
        employment.setOrganization(organizationRef);
        EmployeeCategory category = new EmployeeCategory();
        category.getName().getValues().put(LocaleHelper.RU_LOCALE, sapPerson.getKTGRY());
        employment.setEmployeeCategory(category);
        SapIntegrationHelper.computeIfAbsentEmployeeCategoryToOrganization(category, organizationRef);
        if (sapPerson.getSTAT2().equals("0")) {
            employment.setClosed(new Date());
        } else if (sapPerson.getSTAT2().equals("3")) {
            employment.setClosed(null);
            employment.setMainEmployment(true);
        }
        person.getEmployments().clear();
        person.getEmployments().add(employment);
        return person;
    }

    private void setRussianValue(L10nString l10nString, String value) {
        if (TextUtil.isBlank((String)value)) {
            return;
        }
        l10nString.getValues().keySet().removeIf(locale -> LocaleHelper.RU_LOCALE.equals(LocaleUtil.createNormalizedLocale((Locale)locale)));
        l10nString.getValues().put(LocaleHelper.RU_LOCALE, value.trim());
    }

    private void setLatinValue(L10nString l10nString, String value) {
        if (TextUtil.isBlank((String)value)) {
            return;
        }
        l10nString.getValues().keySet().removeIf(locale -> Locale.ENGLISH.equals(LocaleUtil.createNormalizedLocale((Locale)locale)));
        l10nString.getValues().put(Locale.ENGLISH, value.trim());
    }
}

