/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.person;

import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SapGdsTracingDocumentAdvice
extends BaseAdvice {
    private String docName;

    public void configure(Map<String, String> params) throws Exception {
        this.docName = params.get("doc-name");
    }

    public void before(MessageContext ctx) {
        ArrayList batchPersons = new ArrayList();
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.MODIFIED_BATCH_PERSONS, batchPersons);
        ctx.putObject((Enum)IBusJibxWsContextKeys.ENABLE_LOG_DOCUMENT, (Object)Boolean.TRUE);
    }

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        IncidentsLog.reportException((String)"failed to sync SAP persons", (Throwable)e);
        return false;
    }

    public void after(MessageContext ctx) {
        this.bindDocument(ctx);
        ArrayList batchPersons = new ArrayList();
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.MODIFIED_BATCH_PERSONS, batchPersons);
    }

    private void bindDocument(MessageContext ctx) {
        Document document = (Document)ctx.getObject((Enum)IBusJibxWsContextKeys.WS_LOG_DOCUMENT);
        if (document == null) {
            return;
        }
        List modifiedPersons = (List)ctx.getObject((Enum)IBusSapIntegrationContextKeys.MODIFIED_BATCH_PERSONS);
        if (modifiedPersons != null && !modifiedPersons.isEmpty()) {
            document.setName(this.docName + ".xml");
            document.setTitle(this.docName + " transactions");
            if (modifiedPersons.size() == 1) {
                document.setOwner((EntityReference)modifiedPersons.get(0));
            } else {
                document.setMultiOwner(true);
                modifiedPersons.forEach(document.getOwners()::add);
            }
            EntityStorage.get().save(EntityContainer.create((BaseEntity)document), false);
        }
    }
}

