/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.person;

import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapCostCodeCategoryType;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Set;
import java.util.stream.Collectors;

public class SapGetCostCodePropertiesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference orgRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.ORGANIZATION);
        Organization organization = (Organization)EntityStorage.get().resolve(orgRef).getEntity();
        Set costCodes = organization.getCostCodeProperties().stream().filter(c -> {
            SapCostCodeCategoryType categoryType = this.getSapCostCodeCategoryType((CostCodeProperties)c);
            return categoryType == SapCostCodeCategoryType.EMPLOYEE_ID || categoryType == SapCostCodeCategoryType.EMPLOYER_ID || categoryType == SapCostCodeCategoryType.ASSISTANT_ID;
        }).collect(Collectors.toSet());
        CostCodeProperties searchCostCode = organization.getCostCodeProperties().stream().filter(c -> this.getSapCostCodeCategoryType((CostCodeProperties)c) == SapCostCodeCategoryType.EMPLOYEE_ID).findAny().orElse(null);
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.COST_CODES, costCodes);
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.SEARCH_COST_CODE, (Object)searchCostCode);
    }

    private SapCostCodeCategoryType getSapCostCodeCategoryType(CostCodeProperties codeProperties) {
        CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(codeProperties.getCategory());
        return costCodeCategory != null ? costCodeCategory.getSapType() : null;
    }
}

