/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.person;

import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.severstal.pi.hcm.travel.DtEmpResponseById;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;

public class SapGetPersonsByIdResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DtEmpResponseById response = (DtEmpResponseById)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.SAP_WS_RESPONSE_PAYLOAD);
        String status = response.getSTATUS();
        if ("ERROR".equalsIgnoreCase(status)) {
            String message = response.getMESSAGE();
            if (TextUtil.nonBlank((String)message)) {
                throw Xeption.forEndUser((String)message, (Object[])new Object[0]);
            }
            throw Xeption.forEndUser((String)"DtEmpResponseById error", (Object[])new Object[0]);
        }
        if ("IN PROCESS".equalsIgnoreCase(status)) {
            ctx.putObject((Enum)IBusSapIntegrationContextKeys.TRY_AGAIN, (Object)Boolean.TRUE);
            return;
        }
        if (!"COMPLETED".equalsIgnoreCase(status)) {
            throw Xeption.forDeveloper((String)("Unexpected response status: " + status), (Object[])new Object[0]);
        }
        List persons = response.getPersonList() != null ? response.getPersonList() : Collections.emptyList();
        BigInteger totalPackages = response.getALLPACK();
        BigInteger packageId = response.getIDPACK();
        String nextPackageId = packageId.equals(totalPackages) ? null : packageId.add(BigInteger.ONE).toString();
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.TRY_AGAIN, (Object)Boolean.FALSE);
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.SAP_PERSONS, (Object)persons);
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.PACKAGE_ID, (Object)nextPackageId);
    }
}

