/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.person;

import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapBatchOrganizations;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapIntegrationSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.severstal.pi.hcm.travel.DtDataReq;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.jibx.ws.http.client.Basic;

public class SapGetRequestIdBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SapBatchOrganizations batch = (SapBatchOrganizations)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.BATCH);
        SapIntegrationSettings setting = (SapIntegrationSettings)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.INTEGRATION_SETTING);
        LocalDateTime dateLastSyncSap = (LocalDateTime)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.DATE_LAST_SYNC);
        String inn = TextUtil.nonBlankStr((String)batch.getRegistrationId());
        String kpp = TextUtil.nonBlankStr((String)batch.getKpp());
        String reqDate = dateLastSyncSap.format(DateTimeFormatter.ISO_LOCAL_DATE);
        String login = TextUtil.nonBlankStr((String)setting.getLogin());
        String password = TextUtil.nonBlankStr((String)setting.getPassword());
        String url = TextUtil.nonBlankStr((String)setting.getUrl());
        Basic authorization = new Basic(login, password.toCharArray());
        DtDataReq request = new DtDataReq();
        request.setANSNR(inn);
        request.setKPP00(kpp);
        request.setDATUM(reqDate);
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.SAP_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.SAP_WS_AUTHORIZATION, (Object)authorization);
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.ENDPOINT, (Object)url);
    }
}

