/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.person;

import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sap.SapIntegrationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.severstal.pi.hcm.travel.DtEmpResponseById;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SapSearchExistPersonProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer<Person> result;
        DtEmpResponseById.Person sapPerson = (DtEmpResponseById.Person)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.SAP_PERSON);
        CostCodeProperties uniqueCostCode = (CostCodeProperties)ctx.getObject((Enum)IBusSapIntegrationContextKeys.SEARCH_COST_CODE);
        EntityReference orgRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.ORGANIZATION);
        String sapId = sapPerson.getUSRID();
        String sapUdid = MiscUtil.toString((Object)sapPerson.getPERNR());
        if (TextUtil.nonBlank((String)sapId)) {
            result = this.searchBySapId(sapId, (EntityReference<Organization>)orgRef);
            if (result == null) {
                result = this.searchBySapId(sapId, null);
            }
            if (result != null) {
                ctx.putObject((Enum)IBusSapIntegrationContextKeys.PERSON, result);
                ctx.putObject((Enum)IBusSapIntegrationContextKeys.PERSON_REFERENCE_EXISTS, (Object)Boolean.TRUE);
                return;
            }
        }
        if (uniqueCostCode != null && (result = this.searchByCostCode(sapUdid, (EntityReference<Organization>)orgRef, uniqueCostCode)) != null) {
            ctx.putObject((Enum)IBusSapIntegrationContextKeys.PERSON, result);
            ctx.putObject((Enum)IBusSapIntegrationContextKeys.PERSON_REFERENCE_EXISTS, (Object)Boolean.TRUE);
            return;
        }
        List<EntityContainer<Person>> persons = this.getPersons(sapPerson, true, this.createOrganizationCriterion((EntityReference<Organization>)orgRef));
        if (persons.size() > 1 && !this.getPersonsWithoutUdid(persons, uniqueCostCode, sapUdid).isEmpty()) {
            persons = this.getPersonsWithoutUdid(persons, uniqueCostCode, sapUdid);
        }
        if (this.processPersons(persons, ctx)) {
            return;
        }
        SearchQuery queryOrganization = new SearchQuery();
        queryOrganization.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.sapSyncEnabled.name(), (Object)Boolean.TRUE));
        queryOrganization.getCriteria().getCriterions().add(SearchCriterion.ne((String)OrganizationIndex.Property.sapId.name(), null));
        List organizationIndices = EntityStorage.get().search(OrganizationIndex.class, queryOrganization).getData();
        if (this.processPersons(this.getPersons(sapPerson, false, SearchQueryHelper.buildOrContainsStringCriterion((String)PersonIndex.Property.employmentsUids.name(), (Collection)organizationIndices.stream().map(oi -> oi.getSource().getUid()).collect(Collectors.toList())), SearchCriterion.doesNotContain((String)PersonIndex.Property.employmentsUids.name(), (Object)orgRef.getUid())), ctx)) {
            return;
        }
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.PERSON_REFERENCE_EXISTS, (Object)Boolean.FALSE);
    }

    private boolean processPersons(List<EntityContainer<Person>> persons, MessageContext ctx) {
        if (!persons.isEmpty()) {
            ctx.putObject((Enum)IBusSapIntegrationContextKeys.PERSON, persons.get(0));
            ctx.putObject((Enum)IBusSapIntegrationContextKeys.PERSON_REFERENCE_EXISTS, (Object)Boolean.TRUE);
            ((Person)persons.get(0).getEntity()).getPossibleDuplicate().addAll(persons.stream().filter(p -> !((EntityContainer)persons.get(0)).equals(p)).map(EntityContainer::toReference).collect(Collectors.toSet()));
            return true;
        }
        return false;
    }

    private List<EntityContainer<Person>> getPersonsWithoutUdid(List<EntityContainer<Person>> persons, CostCodeProperties properties, String udid) {
        return persons.stream().filter(personContainer -> ((Person)personContainer.getEntity()).getCostCodes().stream().noneMatch(costCode -> MiscUtil.equals((Object)properties, (Object)costCode.getCostCodeProperties(), (boolean)false) && !TextUtil.isSame((String)udid, (String)costCode.getValue(), (boolean)true) && TextUtil.isContainsDigits((String)costCode.getValue()))).collect(Collectors.toList());
    }

    private EntityContainer<Person> searchBySapId(String sapId, EntityReference<Organization> entityReference) {
        SearchQuery query = new SearchQuery();
        if (entityReference != null) {
            query.getCriteria().getCriterions().add(this.createOrganizationCriterion(entityReference));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.sapId.name(), (Object)sapId));
        List persons = EntityStorage.get().search(PersonIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(EntityStorageHelper::nonEmpty).collect(Collectors.toList());
        if (!persons.isEmpty()) {
            return (EntityContainer)persons.get(0);
        }
        return null;
    }

    private EntityContainer<Person> searchByCostCode(String sapUdid, EntityReference<Organization> entityReference, CostCodeProperties costCodeProperties) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(this.createOrganizationCriterion(entityReference));
        query.getCriteria().getCriterions().add(SearchCriterion.icontains((String)PersonIndex.Property.costCodesValues.name(), (String)sapUdid));
        List persons = EntityStorage.get().search(PersonIndex.class, query).getData().stream().map(index -> EntityStorage.get().resolve(index.getSource())).filter(EntityStorageHelper::nonEmpty).filter(personContainer -> ((Person)personContainer.getEntity()).getCostCodes().stream().anyMatch(costCode -> costCodeProperties.equals((Object)costCode.getCostCodeProperties()) && TextUtil.isSame((String)sapUdid, (String)costCode.getValue(), (boolean)true))).collect(Collectors.toList());
        if (!persons.isEmpty()) {
            return (EntityContainer)persons.get(0);
        }
        return null;
    }

    private List<EntityContainer<Person>> getPersons(DtEmpResponseById.Person sapPerson, boolean nullBirthday, SearchCriterion ... criteria) throws Exception {
        ArrayList<EntityContainer<Person>> result = new ArrayList<EntityContainer<Person>>();
        SearchQuery query = new SearchQuery();
        for (SearchCriterion criterion : criteria) {
            query.getCriteria().getCriterions().add(criterion);
        }
        List indices = EntityStorage.get().search(PersonIndex.class, query).getData();
        List<Object> indicesToCheck = new ArrayList(indices);
        List indicesWithSameEmail = indicesToCheck.stream().filter(i -> i.getEmails().stream().anyMatch(e -> TextUtil.isSame((String)e, (String)sapPerson.getUSRIDLONG(), (boolean)true, (boolean)true))).collect(Collectors.toList());
        if (indicesWithSameEmail.size() == 1) {
            EntityContainer person;
            PersonIndex index = (PersonIndex)indicesWithSameEmail.get(0);
            if ((index.getBirthday() == null || MiscUtil.isSameDaySafe((Date)index.getBirthday(), (Date)SapIntegrationHelper.getBirthdayDateFormat().parse(sapPerson.getGBDAT())) && index.getSearchFirstNames().stream().anyMatch(n -> TextUtil.isSame((String)n, (String)sapPerson.getVORNA(), (boolean)true, (boolean)true)) && index.getMiddleNameValues().stream().anyMatch(n -> TextUtil.isSame((String)n, (String)sapPerson.getMIDNM(), (boolean)true, (boolean)true))) && EntityStorageHelper.nonEmpty((EntityContainer)(person = EntityStorage.get().resolve(index.getSource())))) {
                result.add((EntityContainer<Person>)person);
                return result;
            }
        } else {
            List indicesWithSameOrNullBirthday;
            List indicesWithSameName;
            if (!indicesWithSameEmail.isEmpty()) {
                indicesToCheck = indicesWithSameEmail;
            }
            if (!(indicesWithSameName = indicesToCheck.stream().filter(i -> i.getSearchFirstNames().stream().anyMatch(n -> TextUtil.isSame((String)n, (String)sapPerson.getVORNA(), (boolean)true, (boolean)true)) && i.getSearchLastNames().stream().anyMatch(n -> TextUtil.isSame((String)n, (String)sapPerson.getNACHN(), (boolean)true, (boolean)true)) && i.getMiddleNameValues().stream().anyMatch(n -> TextUtil.isSame((String)n, (String)sapPerson.getMIDNM(), (boolean)true, (boolean)true))).collect(Collectors.toList())).isEmpty() && !(indicesWithSameOrNullBirthday = indicesWithSameName.stream().filter(i -> {
                try {
                    return nullBirthday && i.getBirthday() == null || MiscUtil.isSameDaySafe((Date)i.getBirthday(), (Date)SapIntegrationHelper.getBirthdayDateFormat().parse(sapPerson.getGBDAT()));
                }
                catch (ParseException e) {
                    return false;
                }
            }).collect(Collectors.toList())).isEmpty()) {
                indicesWithSameOrNullBirthday.stream().map(pi -> EntityStorage.get().resolve(pi.getSource())).filter(Objects::nonNull).sorted((p1, p2) -> ((Person)p1.getEntity()).getBirthday() != null && ((Person)p2.getEntity()).getBirthday() == null ? -1 : (((Person)p2.getEntity()).getBirthday() != null && ((Person)p1.getEntity()).getBirthday() == null ? 1 : 0)).forEach(result::add);
            }
        }
        return result;
    }

    private SearchCriterion createOrganizationCriterion(EntityReference<Organization> entityReference) {
        return SearchCriterion.contains((String)PersonIndex.Property.employmentsUids.name(), (Object)entityReference.getUid());
    }
}

