/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sap.person;

import com.gridnine.xtrip.common.ibecorp.model.sap.IBusSapIntegrationContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapIntegrationSettings;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapIntegrationSyncData;
import com.gridnine.xtrip.common.model.ibecorp.sap.SapSyncStatus;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.EmployeeCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sap.SapIntegrationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.severstal.pi.hcm.travel.DtEmpResponseById;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SapUpdatePersonProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Gender sapGender;
        String email;
        DtEmpResponseById.Person sapPerson = (DtEmpResponseById.Person)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.SAP_PERSON);
        EntityReference organizationRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.ORGANIZATION);
        Set costCodes = (Set)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.COST_CODES);
        EntityContainer momPerson = (EntityContainer)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.PERSON);
        List modifiedPersons = (List)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.MODIFIED_PERSONS);
        List modifiedBatchPersons = (List)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.MODIFIED_BATCH_PERSONS);
        SapIntegrationSettings setting = (SapIntegrationSettings)ctx.getMandatoryObject((Enum)IBusSapIntegrationContextKeys.INTEGRATION_SETTING);
        boolean skip = true;
        String lastName = sapPerson.getNACHN();
        String lastNameEn = sapPerson.getNACHNENG();
        String firstName = sapPerson.getVORNA();
        String firstNameEn = sapPerson.getVORNAENG();
        String middleName = sapPerson.getMIDNM();
        String middleNameEn = sapPerson.getMIDNMENG();
        Person person = (Person)momPerson.getEntity();
        String sapRussianName = Stream.of(lastName, firstName, middleName).filter(TextUtil::nonBlank).map(String::trim).collect(Collectors.joining(" "));
        String momRussianName = new PersonalLocalizableNameFormatter("L F M").format((PersonalLocalizableName)momPerson.getEntity(), LocaleHelper.RU_LOCALE, true);
        if (TextUtil.nonBlank((String)sapRussianName) && !TextUtil.isSame((String)sapRussianName, (String)momRussianName, (boolean)true)) {
            L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastName, (Locale)LocaleHelper.RU_LOCALE);
            L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstName, (Locale)LocaleHelper.RU_LOCALE);
            L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleName, (Locale)LocaleHelper.RU_LOCALE);
            skip = false;
        }
        String sapEnglishName = Stream.of(lastNameEn, firstNameEn, middleNameEn).filter(TextUtil::nonBlank).map(String::trim).collect(Collectors.joining(" "));
        String momEnglishName = new PersonalLocalizableNameFormatter("L F M").format((PersonalLocalizableName)momPerson.getEntity(), LocaleHelper.EN_LOCALE, true);
        if (TextUtil.nonBlank((String)sapEnglishName) && !TextUtil.isSame((String)sapEnglishName, (String)momEnglishName, (boolean)true)) {
            L10nStringHelper.setValue((L10nString)person.getLastName(), (String)lastNameEn, (Locale)LocaleHelper.EN_LOCALE);
            L10nStringHelper.setValue((L10nString)person.getFirstName(), (String)firstNameEn, (Locale)LocaleHelper.EN_LOCALE);
            L10nStringHelper.setValue((L10nString)person.getMiddleName(), (String)middleNameEn, (Locale)LocaleHelper.EN_LOCALE);
            skip = false;
        }
        if (!TextUtil.isSame((String)momRussianName, (String)sapRussianName, (boolean)true) && TextUtil.isBlank((String)sapEnglishName) && TextUtil.nonBlank((String)momEnglishName)) {
            L10nStringHelper.setValue((L10nString)person.getLastName(), null, (Locale)LocaleHelper.EN_LOCALE);
            L10nStringHelper.setValue((L10nString)person.getFirstName(), null, (Locale)LocaleHelper.EN_LOCALE);
            L10nStringHelper.setValue((L10nString)person.getMiddleName(), null, (Locale)LocaleHelper.EN_LOCALE);
            skip = false;
        }
        Date sapBirthDate = null;
        if (!TextUtil.isBlank((String)sapPerson.getGBDAT())) {
            sapBirthDate = SapIntegrationHelper.getBirthdayDateFormat().parse(sapPerson.getGBDAT());
        }
        Date momBirthDay = ProfileHelper.getPersonBirthday((Person)((Person)momPerson.getEntity()));
        if (sapBirthDate != null && !MiscUtil.isSameDaySafe((Date)sapBirthDate, (Date)momBirthDay)) {
            person.setBirthday(sapBirthDate);
            skip = false;
        }
        if (TextUtil.nonBlank((String)sapPerson.getUSRID()) && !MiscUtil.equals((Object)person.getSapId(), (Object)sapPerson.getUSRID())) {
            person.setSapId(sapPerson.getUSRID());
            skip = false;
        }
        if (TextUtil.nonBlank((String)(email = sapPerson.getUSRIDLONG()))) {
            PersonCommunication communication = new PersonCommunication();
            communication.setType(CommunicationType.EMAIL);
            communication.setOrganization(organizationRef);
            communication.setSense(email);
            List emails = person.getCommunications().stream().filter(pc -> MiscUtil.equals((Object)organizationRef, (Object)pc.getOrganization()) && pc.getType().equals((Object)CommunicationType.EMAIL)).collect(Collectors.toList());
            if (emails.size() != 1 || !TextUtil.isSame((String)email, (String)((PersonCommunication)emails.get(0)).getSense())) {
                skip = false;
            }
            person.getCommunications().removeIf(pc -> MiscUtil.equals((Object)organizationRef, (Object)pc.getOrganization()) && pc.getType().equals((Object)CommunicationType.EMAIL));
            person.getCommunications().add(0, communication);
        }
        Set personCostCodes = person.getCostCodes().stream().filter(it -> organizationRef.equals((Object)it.getOrganization())).filter(it -> costCodes.contains(it.getCostCodeProperties())).collect(Collectors.toSet());
        for (CostCodeProperties costCodeProperties : costCodes) {
            String sapUdidValue;
            CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCodeProperties.getCategory());
            if (costCodeCategory == null) continue;
            switch (costCodeCategory.getSapType()) {
                case EMPLOYEE_ID: {
                    sapUdidValue = MiscUtil.toString((Object)sapPerson.getPERNR());
                    break;
                }
                case EMPLOYER_ID: {
                    sapUdidValue = MiscUtil.toString((Object)sapPerson.getWERKS());
                    break;
                }
                case ASSISTANT_ID: {
                    sapUdidValue = sapPerson.getASSISTList().stream().map(a -> MiscUtil.toString((Object)a.getASSISTPERNR())).findFirst().orElse("");
                    break;
                }
                default: {
                    sapUdidValue = null;
                }
            }
            if (sapUdidValue == null) continue;
            PersonCostCode costCode = personCostCodes.stream().filter(it -> MiscUtil.equals((Object)it.getCostCodeProperties().getCategory(), (Object)costCodeProperties.getCategory())).findFirst().orElse(null);
            if (personCostCodes.isEmpty() || costCode == null) {
                person.getCostCodes().add(SapIntegrationHelper.createPersonCostCode((EntityReference<Organization>)organizationRef, costCodeProperties, sapUdidValue));
                skip = false;
                continue;
            }
            if (MiscUtil.equals((Object)costCode.getValue(), (Object)sapUdidValue)) continue;
            costCode.setValue(sapUdidValue);
            skip = false;
        }
        EmployeeCategory categorySap = new EmployeeCategory();
        categorySap.getName().getValues().put(LocaleHelper.RU_LOCALE, sapPerson.getKTGRY());
        EmployeeCategory category = GeneralProductHelper.getEmployeeCategory((EntityReference)organizationRef, (Person)person);
        PersonEmployment employment = person.getEmployments().stream().filter(emp -> MiscUtil.equals((Object)emp.getOrganization(), (Object)organizationRef)).findFirst().orElse(null);
        if (employment == null) {
            employment = new PersonEmployment();
            person.getEmployments().add(employment);
            employment.setOrganization(organizationRef);
            skip = false;
        }
        if (category == null && sapPerson.getKTGRY() != null) {
            category = new EmployeeCategory();
            category.getName().getValues().put(LocaleHelper.RU_LOCALE, sapPerson.getKTGRY());
            employment.setEmployeeCategory(category);
            SapIntegrationHelper.computeIfAbsentEmployeeCategoryToOrganization(category, (EntityReference<Organization>)organizationRef);
            skip = false;
        }
        if (category != null && !GeneralProductHelper.isEmployeeCategoriesEquals((EmployeeCategory)category, (EmployeeCategory)categorySap)) {
            category.getName().getValues().put(LocaleHelper.RU_LOCALE, sapPerson.getKTGRY());
            SapIntegrationHelper.computeIfAbsentEmployeeCategoryToOrganization(categorySap, (EntityReference<Organization>)organizationRef);
            skip = false;
        }
        if (sapPerson.getSTAT2().equals("0")) {
            if (employment.getClosed() == null) {
                employment.setClosed(new Date());
                skip = false;
            }
        } else if (sapPerson.getSTAT2().equals("3")) {
            if (employment.getClosed() != null) {
                employment.setClosed(null);
                skip = false;
            }
            for (PersonEmployment emp2 : person.getEmployments()) {
                if (MiscUtil.equals((Object)emp2, (Object)employment)) {
                    if (employment.isMainEmployment()) continue;
                    employment.setMainEmployment(true);
                    skip = false;
                    continue;
                }
                if (!emp2.isMainEmployment()) continue;
                emp2.setMainEmployment(false);
                skip = false;
            }
        }
        if ((sapGender = SapIntegrationHelper.getGender(sapPerson.getANREX())) != null && person.getGender() != sapGender) {
            person.setGender(sapGender);
            skip = false;
        }
        boolean assistant = BooleanUtil.nullAsFalse((Boolean)sapPerson.getASSISTF());
        if (person.isSapAssistant() != assistant) {
            person.setSapAssistant(assistant);
            skip = false;
        }
        if (setting.isSaveUnchanged() || !skip) {
            SapIntegrationSyncData syncData = person.getSapIntegrationSyncData();
            if (syncData == null) {
                syncData = new SapIntegrationSyncData();
                person.setSapIntegrationSyncData(syncData);
            }
            syncData.setStatusSync(SapSyncStatus.MODIFY);
            momPerson.getVersionInfo().setVersionNotes(SapSyncStatus.MODIFY.name());
            if (modifiedPersons.stream().noneMatch(p -> p.getUid().equals(momPerson.toReference().getUid()))) {
                modifiedPersons.add(momPerson.toReference());
            }
            if (modifiedBatchPersons.stream().noneMatch(p -> p.getUid().equals(momPerson.toReference().getUid()))) {
                modifiedBatchPersons.add(momPerson.toReference());
            }
        }
        ctx.putObject((Enum)IBusSapIntegrationContextKeys.SKIP_PERSON, (Object)(!setting.isSaveUnchanged() && skip ? 1 : 0));
    }
}

