/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis;

import com.google.common.base.Strings;
import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.ibecorp.rules.SbisActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.SbisExportParametersSettings;
import com.gridnine.xtrip.common.ibecorp.rules.SbisRentCarAktExportParametersSettings;
import com.gridnine.xtrip.common.ibecorp.rules.SbisTaxiAktExportParametersSettings;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.format.object.ModelFormatObjects;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeoLocationHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.SbisCostCodeType;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentFormat;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentFormatSettings;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisIntegrationSettings;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.format.object.Format;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisAcceptanceCertificateFile;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisDocumentSigner;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationAdditionalData;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationAdditionalDataIP;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationAdditionalDataNonIP;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationData;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisSerializable;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class SbisCreateAcceptanceCertificateFileProcessor
extends BaseProcessor {
    /*
     * WARNING - void declaration
     */
    public void process(MessageContext ctx) throws Exception {
        GeoLocation cityDeparture;
        Traveller traveller;
        Optional<String> personnelNumber;
        Person entity;
        EntityContainer resolve;
        EntityReference passenger;
        EntityContainer shipmentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SHIPMENT_CONTAINER);
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer acCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENT_CONTAINER);
        HashMap documents = (HashMap)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENTS);
        ArrayList documentsAsPdf = (ArrayList)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENTS_AS_PDF);
        String customerCode = (String)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_CUSTOMER_CODE);
        String customerIdentifier = (String)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_CUSTOMER_IDENTIFIER);
        Map vendorBillingItems = (Map)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_VENDOR_BILLING_ITEMS);
        if (((FinanceDocument)acCtr.getEntity()).getDate() == null) {
            throw Xeption.forEndUser((String)"\u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u0430\u043a\u0442\u0430", (Object[])new Object[0]);
        }
        SbisOrganizationData supplierData = SbisIntegrationHelper.buildOrganizationData((FinanceDocument)acCtr.getEntity(), sc, customerCode, customerIdentifier, true, true);
        SbisOrganizationData customerData = SbisIntegrationHelper.buildOrganizationData((FinanceDocument)acCtr.getEntity(), sc, customerCode, customerIdentifier, false, false);
        String fileId = String.format("DP_REZRUISP_%s_%s_%s_%s_%s_%s", supplierData.getInn(), supplierData.getKpp(), customerData.getInn(), customerData.getKpp(), SbisIntegrationHelper.filenameDateFormatter.format(MiscUtil.toLocalDate((Date)((FinanceDocument)acCtr.getEntity()).getDate())), acCtr.getUid()).replaceAll("_{2,}", "_");
        String pdfFileId = String.format("\u0410\u043a\u0442_%s_%s", ((FinanceDocument)acCtr.getEntity()).getNumber(), SbisIntegrationHelper.filenameDateFormatter.format(MiscUtil.toLocalDate((Date)((FinanceDocument)acCtr.getEntity()).getDate()))).replaceAll("_{2,}", "_");
        SbisDocumentFormatSettings formatSettings = (SbisDocumentFormatSettings)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.DOCUMENTS_FORMAT_SETTINGS);
        Document documentPdf = null;
        if (formatSettings.getAcceptanceCertificate() == SbisDocumentFormat.PDF || formatSettings.getAcceptanceCertificate() == SbisDocumentFormat.XML_AND_PDF) {
            documentPdf = SbisIntegrationHelper.createFinanceDocument((EntityContainer<FinanceDocument>)acCtr, pdfFileId);
            if (formatSettings.getAcceptanceCertificate() == SbisDocumentFormat.PDF) {
                documentsAsPdf.add(documentPdf);
                return;
            }
        }
        SbisIntegrationSettings settings = (SbisIntegrationSettings)ctx.getObject((Enum)IBusSbisContextKeys.INTEGRATION_SETTINGS);
        SbisAcceptanceCertificateFile result = new SbisAcceptanceCertificateFile();
        result.getSvUchDocObor().setIdPoluch(customerData.getUid());
        result.getSvUchDocObor().setIdOtpr(supplierData.getUid());
        result.setFileId(fileId);
        SbisAcceptanceCertificateFile.SbisAktDocument doc = result.getDocument();
        doc.setIdVisualValue(settings.getAccentanceCertificateSettings().getIdVisual() == null ? "\u041e\u041e\u041e \"\u0422\u0422-\u0422\u0440\u044d\u0432\u0435\u043b\"" : settings.getAccentanceCertificateSettings().getIdVisual());
        doc.setIspDate(MiscUtil.toLocalDateTime((Date)((FinanceDocument)acCtr.getEntity()).getDate()));
        doc.setNaimEconSubSost(supplierData.getName());
        doc.setNomDocPru(TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)shipmentCtr.getEntity())));
        doc.setDateDocPru(MiscUtil.toLocalDate((Date)((Shipment)shipmentCtr.getEntity()).getDate()));
        if (!TextUtil.isBlank((String)((FinanceDocument)acCtr.getEntity()).getCaptionTemplate())) {
            String zagSodOrderString = Format.of((String)((FinanceDocument)acCtr.getEntity()).getCaptionTemplate()).format(Format.FormatObjectDataBuilder.get().object((Object)acCtr.getEntity(), ModelFormatObjects.FINANCE_DOCUMENT.getId()).build(), sc);
            doc.setZagSodOper(zagSodOrderString);
        } else {
            doc.setZagSodOper(settings.getAccentanceCertificateSettings().getSignature());
            if (TextUtil.isBlank((String)doc.getZagSodOper())) {
                throw Xeption.forEndUser((String)"\u0432 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u0430\u0445 \u0438\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u0438 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u044c \u0432 \u0430\u043a\u0442\u0435", (Object[])new Object[0]);
            }
        }
        this.fillOrg(doc.getIspolnitel(), supplierData, true, false);
        this.fillOrg(doc.getZakazchik(), customerData, false, false);
        this.fillSbisDocumentSignerData(doc.getPodpisant());
        int n = 0;
        BigDecimal totalNDS = BigDecimal.ZERO;
        BigDecimal total = BigDecimal.ZERO;
        HashMap<Object, SbisActionSet> sbisActionSets = new HashMap<Object, SbisActionSet>();
        HashMap<Object, SbisActionSet> sbisIntermediaryActionSets = new HashMap<Object, SbisActionSet>();
        HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> resultAttributes = new HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>>();
        BaseProduct firstProduct = null;
        for (SbisIntegrationHelper.BillingItemWrapper billingItemWrapper : SbisIntegrationHelper.getMergedBillingItem((FinanceDocument)acCtr.getEntity(), sc, (Boolean)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SUPPLIER_IS_SIMPLE_TAXED), ((FinanceDocument)acCtr.getEntity()).getVatViewMode(), vendorBillingItems)) {
            BillingItem bi = billingItemWrapper.getBillingItem();
            SbisAcceptanceCertificateFile.SbisAktRabota item = this.createRabotaItem(bi, ++n);
            totalNDS = totalNDS.add(item.getNds());
            total = total.add(item.getStSNDS());
            if (firstProduct == null) {
                firstProduct = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)bi.getProduct(), (EntityStorageContext)sc);
            }
            Map<Object, Object> attributes = new HashMap();
            boolean isIntermediaryService = SbisIntegrationHelper.isIntermediaryService(billingItemWrapper, sc);
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)bi.getProduct(), (EntityStorageContext)sc);
            if (product != null) {
                void var34_58;
                ExtendedProductType productType = SbisIntegrationHelper.getExtendedProductType(product);
                ExtendedProductType extendedProductType = sbisActionSets.keySet().stream().filter(type -> type.getProductType() == productType.getProductType() && MiscUtil.equals((Object)type.getProductDescription(), (Object)productType.getProductDescription())).findFirst().orElse(null);
                if (isIntermediaryService) {
                    ExtendedProductType extendedProductType2 = sbisIntermediaryActionSets.keySet().stream().filter(type -> type.getProductType() == productType.getProductType() && MiscUtil.equals((Object)type.getProductDescription(), (Object)productType.getProductDescription())).findFirst().orElse(null);
                }
                SbisActionSet sbisActionSet = (SbisActionSet)sbisActionSets.get(var34_58);
                if (isIntermediaryService) {
                    sbisActionSet = (SbisActionSet)sbisIntermediaryActionSets.get(var34_58);
                }
                if (sbisActionSet == null) {
                    sbisActionSet = SbisIntegrationHelper.applyRules((EntityContainer<Shipment>)shipmentCtr, (FinanceDocument)acCtr.getEntity(), product, isIntermediaryService);
                    if (isIntermediaryService) {
                        sbisIntermediaryActionSets.put(productType, sbisActionSet);
                    } else {
                        sbisActionSets.put(productType, sbisActionSet);
                    }
                }
                attributes = SbisIntegrationHelper.getElementsAttributes(product, billingItemWrapper, (NestedEntityReference<BookingFile, Traveller>)bi.getTraveller(), sbisActionSet.getSbisDocumentElementsData(), ((FinanceDocument)acCtr.getEntity()).getDate(), sc);
                item.getSbisDocumentElementsAttributes().putAll(attributes);
            }
            for (Map.Entry entry : attributes.entrySet()) {
                HashSet elementAttributes = (HashSet)resultAttributes.get(entry.getKey());
                if (elementAttributes == null) {
                    elementAttributes = new HashSet();
                }
                elementAttributes.addAll((Collection)entry.getValue());
                resultAttributes.put((String)entry.getKey(), elementAttributes);
            }
            doc.getWorks().add(item);
        }
        doc.setStBezNDSIt(total.subtract(totalNDS));
        doc.setNdsIt(totalNDS);
        doc.setStSNDSIt(total);
        doc.setStartOfWork(MiscUtil.toLocalDate((Date)((Shipment)shipmentCtr.getEntity()).getPeriodBegin()));
        doc.setEndOfWork(MiscUtil.toLocalDate((Date)((Shipment)shipmentCtr.getEntity()).getPeriodEnd()));
        doc.setGruzootpravitel(String.format("%s,%s", customerData.getName(), customerData.getAddress()));
        doc.setDataPer(MiscUtil.toLocalDate((Date)((FinanceDocument)acCtr.getEntity()).getDate()));
        doc.getSbisDocumentElementsAttributes().putAll(SbisIntegrationHelper.mergeAttributes(resultAttributes));
        SbisExportParametersSettings parametersSettings = (SbisExportParametersSettings)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_EXPORT_PARAMETERS_SETTINGS);
        EntityContainer contractCtr = EntityStorage.get().resolve((EntityReference)((Shipment)shipmentCtr.getEntity()).getContract());
        String contractNumber = null;
        String dateContract = null;
        if (contractCtr != null) {
            contractNumber = ((Contract)contractCtr.getEntity()).getNumber();
            Date date = ((Contract)contractCtr.getEntity()).getIssueDate();
            if (date != null) {
                dateContract = SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(date);
            }
        }
        doc.setContractNumber(contractNumber);
        doc.setContractDate(dateContract);
        if (firstProduct instanceof Product) {
            List segments;
            Product airProduct = (Product)firstProduct;
            List segmentTariffs = airProduct.getSegmentTariffs();
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludeContractNumber())) {
                if (contractNumber != null) {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", contractNumber);
                } else {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludeDateContract())) {
                if (dateContract != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", dateContract);
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludeTypeServices())) {
                doc.getInfoSectionParamets().put("\u0422\u0438\u043f\u0423\u0441\u043b\u0443\u0433\u0438", "\u0410\u0432\u0438\u0430");
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludeTicketSale())) {
                String ticketSale = airProduct.getCarrierNumber() + airProduct.getSystemNumber();
                if (ticketSale != null) {
                    doc.getInfoSectionParamets().put("\u0411\u0438\u043b\u0435\u0442\u041f\u0440\u043e\u0434\u0430\u0436\u0430", ticketSale);
                } else {
                    doc.getInfoSectionParamets().put("\u0411\u0438\u043b\u0435\u0442\u041f\u0440\u043e\u0434\u0430\u0436\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludeTraveler())) {
                if (airProduct.getTraveller() != null) {
                    passenger = airProduct.getTraveller().getPassenger();
                    if (passenger != null) {
                        EntityContainer resolve2 = EntityStorage.get().resolve(passenger);
                        if (resolve2 != null) {
                            Person person = (Person)resolve2.getEntity();
                            if (person != null) {
                                String fullName2 = ProfileHelper.getFullName((Person)person, (Locale)LocaleHelper.getLocale((String)"ru"), (boolean)false);
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", fullName2);
                            } else {
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                            }
                        } else {
                            doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                        }
                    } else {
                        doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                }
            }
            List datesSegmentTariffs = segmentTariffs;
            if (!(airProduct.getRelatedProducts().isEmpty() || airProduct.getProductCategory() != ProductCategory.MCO && airProduct.getProductCategory() != ProductCategory.EXCESS_BAGAGE)) {
                datesSegmentTariffs = ((Product)airProduct.getRelatedProducts().get(0)).getSegmentTariffs();
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludeDateDeparture())) {
                if (!datesSegmentTariffs.isEmpty()) {
                    segments = ((SegmentTariff)datesSegmentTariffs.get(0)).getSegments();
                    if (!segments.isEmpty()) {
                        Date date = ((Segment)segments.get(0)).getStartDate();
                        if (date != null) {
                            doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(date));
                        } else {
                            doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                        }
                    } else {
                        doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludeDateArriver())) {
                if (!datesSegmentTariffs.isEmpty()) {
                    segments = ((SegmentTariff)datesSegmentTariffs.get(datesSegmentTariffs.size() - 1)).getSegments();
                    if (!segments.isEmpty()) {
                        Date date = ((Segment)segments.get(segments.size() - 1)).getEndDate();
                        if (date != null) {
                            doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(date));
                        } else {
                            doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", "");
                        }
                    } else {
                        doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludeCityDeparture())) {
                if (!segmentTariffs.isEmpty()) {
                    segments = ((SegmentTariff)segmentTariffs.get(0)).getSegments();
                    if (!segments.isEmpty()) {
                        DictionaryReference dictionaryReference = ((Segment)segments.get(0)).getDepartureLocation();
                        if (dictionaryReference != null) {
                            doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", GeoLocationHelper.getCity((DictionaryReference)dictionaryReference).toString());
                        } else {
                            doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                        }
                    } else {
                        doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludeCityArriver())) {
                DictionaryReference geoLocationDictionaryReference = AirProductHelper.destinationLocations((Product)airProduct);
                if (geoLocationDictionaryReference != null) {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", geoLocationDictionaryReference.getCaption());
                } else {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludeClassService())) {
                if (!segmentTariffs.isEmpty()) {
                    segments = ((SegmentTariff)segmentTariffs.get(segmentTariffs.size() - 1)).getSegments();
                    if (!segments.isEmpty()) {
                        ClassOfService classOfService = ((Segment)segments.get(0)).getServiceClass();
                        if (classOfService != null) {
                            doc.getInfoSectionParamets().put("\u041a\u043b\u0430\u0441\u0441\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", classOfService.toString());
                        } else {
                            doc.getInfoSectionParamets().put("\u041a\u043b\u0430\u0441\u0441\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", "");
                        }
                    } else {
                        doc.getInfoSectionParamets().put("\u041a\u043b\u0430\u0441\u0441\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u041a\u043b\u0430\u0441\u0441\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludePersonnelNumber())) {
                Optional<String> personnelNumber2 = this.getPersonnelNumber((BaseProduct)airProduct);
                if (personnelNumber2.isPresent()) {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", personnelNumber2.get());
                } else {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getAirSettings().getIncludeNumberSales()) && ProductStatus.REFUND.equals((Object)airProduct.getStatus())) {
                doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0410\u043a\u0442\u0430\u041f\u0440\u043e\u0434\u0430\u0436\u0438", SbisCreateAcceptanceCertificateFileProcessor.getShipment((BaseProduct)airProduct.getPreviousProduct(), sc));
            }
        }
        if (firstProduct instanceof AeroexpressTicket) {
            AeroexpressTicket aeroexpressProduct = (AeroexpressTicket)firstProduct;
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getExpressSettings().getIncludeContractNumber())) {
                if (contractNumber != null) {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", contractNumber);
                } else {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getExpressSettings().getIncludeDateContract())) {
                if (dateContract != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", dateContract);
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getExpressSettings().getIncludeTypeServices())) {
                doc.getInfoSectionParamets().put("\u0422\u0438\u043f\u0423\u0441\u043b\u0443\u0433\u0438", "\u0410\u044d\u0440\u043e\u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441");
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getExpressSettings().getIncludeTicketSale())) {
                String ticketSeal = aeroexpressProduct.getSystemNumber();
                if (ticketSeal != null) {
                    doc.getInfoSectionParamets().put("\u0411\u0438\u043b\u0435\u0442\u041f\u0440\u043e\u0434\u0430\u0436\u0430", ticketSeal);
                } else {
                    doc.getInfoSectionParamets().put("\u0411\u0438\u043b\u0435\u0442\u041f\u0440\u043e\u0434\u0430\u0436\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getExpressSettings().getIncludeTraveler())) {
                if (aeroexpressProduct.getTraveller() != null) {
                    EntityReference passenger2 = aeroexpressProduct.getTraveller().getPassenger();
                    if (passenger2 != null) {
                        resolve = EntityStorage.get().resolve(passenger2);
                        if (resolve != null) {
                            entity = (Person)resolve.getEntity();
                            if (entity != null) {
                                String string = ProfileHelper.getFullName((Person)entity, (Locale)LocaleHelper.getLocale((String)"ru"), (boolean)false);
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", string);
                            } else {
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                            }
                        } else {
                            doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                        }
                    } else {
                        doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getExpressSettings().getIncludeDateDeparture())) {
                if (aeroexpressProduct.getDepartureDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(aeroexpressProduct.getDepartureDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getExpressSettings().getIncludeDateArriver())) {
                if (aeroexpressProduct.getDepartureDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(aeroexpressProduct.getDepartureDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getExpressSettings().getIncludeCityDeparture())) {
                DictionaryReference departureLocation = aeroexpressProduct.getDepartureLocation();
                if (departureLocation != null) {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", GeoLocationHelper.getCity((DictionaryReference)departureLocation).toString());
                } else {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getExpressSettings().getIncludeClassService())) {
                if (aeroexpressProduct.getClassOfService() != null) {
                    doc.getInfoSectionParamets().put("\u041a\u043b\u0430\u0441\u0441\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", aeroexpressProduct.getClassOfService().toString());
                } else {
                    doc.getInfoSectionParamets().put("\u041a\u043b\u0430\u0441\u0441\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getExpressSettings().getIncludePersonnelNumber())) {
                Optional<String> personnelNumber3 = this.getPersonnelNumber((BaseProduct)aeroexpressProduct);
                if (personnelNumber3.isPresent()) {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", personnelNumber3.get());
                } else {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getExpressSettings().getIncludeNumberSales()) && ProductStatus.REFUND.equals((Object)aeroexpressProduct.getStatus())) {
                doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0410\u043a\u0442\u0430\u041f\u0440\u043e\u0434\u0430\u0436\u0438", SbisCreateAcceptanceCertificateFileProcessor.getShipment((BaseProduct)aeroexpressProduct.getPreviousProduct(), sc));
            }
        }
        if (firstProduct instanceof RailwayProduct) {
            RailwayStation railwayStation;
            RailwayProduct railwayProduct = (RailwayProduct)firstProduct;
            List segments = railwayProduct.getSegments();
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludeContractNumber())) {
                if (contractNumber != null) {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", contractNumber);
                } else {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludeDateContract())) {
                if (dateContract != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", dateContract);
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludeTypeServices())) {
                doc.getInfoSectionParamets().put("\u0422\u0438\u043f\u0423\u0441\u043b\u0443\u0433\u0438", "\u0416\u0414");
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludeTicketSale())) {
                String ticketSeal = railwayProduct.getSystemNumber();
                if (ticketSeal != null) {
                    doc.getInfoSectionParamets().put("\u0411\u0438\u043b\u0435\u0442\u041f\u0440\u043e\u0434\u0430\u0436\u0430", ticketSeal);
                } else {
                    doc.getInfoSectionParamets().put("\u0411\u0438\u043b\u0435\u0442\u041f\u0440\u043e\u0434\u0430\u0436\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludeTraveler())) {
                if (!railwayProduct.getPassengers().isEmpty()) {
                    passenger = ((Traveller)railwayProduct.getPassengers().get(0)).getPassenger();
                    if (passenger != null) {
                        EntityContainer resolve2 = EntityStorage.get().resolve(passenger);
                        if (resolve2 != null) {
                            Person person = (Person)resolve2.getEntity();
                            if (person != null) {
                                String fullName = ProfileHelper.getFullName((Person)person, (Locale)LocaleHelper.getLocale((String)"ru"), (boolean)false);
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", fullName);
                            } else {
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                            }
                        } else {
                            doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                        }
                    } else {
                        doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludeDateDeparture())) {
                if (!segments.isEmpty()) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(((RailwaySegment)segments.get(0)).getDepartureDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludeDateArriver())) {
                Date arriveDate = null;
                if (!segments.isEmpty()) {
                    arriveDate = ((RailwaySegment)segments.get(segments.size() - 1)).getArriveDate();
                }
                doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", arriveDate != null ? SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(arriveDate) : "");
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludeCityDeparture())) {
                if (!segments.isEmpty()) {
                    railwayStation = (RailwayStation)DictionaryCache.get().resolveReference(((RailwaySegment)segments.get(0)).getDepartureStation());
                    if (railwayStation != null) {
                        doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", railwayStation.toString());
                    } else {
                        doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludeCityArriver())) {
                if (!segments.isEmpty()) {
                    railwayStation = (RailwayStation)DictionaryCache.get().resolveReference(((RailwaySegment)segments.get(segments.size() - 1)).getArriveStation());
                    if (railwayStation != null) {
                        doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", railwayStation.toString());
                    } else {
                        doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludeClassService())) {
                if (!segments.isEmpty()) {
                    doc.getInfoSectionParamets().put("\u041a\u043b\u0430\u0441\u0441\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", ((RailwaySegment)segments.get(0)).getCarriageType().toString());
                } else {
                    doc.getInfoSectionParamets().put("\u041a\u043b\u0430\u0441\u0441\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludePersonnelNumber())) {
                personnelNumber = this.getPersonnelNumber((BaseProduct)railwayProduct);
                if (personnelNumber.isPresent()) {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", personnelNumber.get());
                } else {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRailwaySettings().getIncludeNumberSales()) && ProductStatus.REFUND.equals((Object)railwayProduct.getStatus())) {
                doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0410\u043a\u0442\u0430\u041f\u0440\u043e\u0434\u0430\u0436\u0438", SbisCreateAcceptanceCertificateFileProcessor.getShipmentNumberByTicket((BaseProduct)railwayProduct.getPreviousProduct(), sc));
            }
        }
        if (firstProduct instanceof HotelProduct) {
            HotelProduct hotelProduct = (HotelProduct)firstProduct;
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getResidenceSettings().getIncludeContractNumber())) {
                if (contractNumber != null) {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", contractNumber);
                } else {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getResidenceSettings().getIncludeDateContract())) {
                if (dateContract != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", dateContract);
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getResidenceSettings().getIncludeTypeServices())) {
                doc.getInfoSectionParamets().put("\u0422\u0438\u043f\u0423\u0441\u043b\u0443\u0433\u0438", "\u041f\u0440\u043e\u0436\u0438\u0432\u0430\u043d\u0438\u0435");
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getResidenceSettings().getIncludeTraveler())) {
                if (!hotelProduct.getTravellers().isEmpty()) {
                    EntityReference passenger3 = ((Traveller)hotelProduct.getTravellers().get(0)).getPassenger();
                    if (passenger3 != null) {
                        resolve = EntityStorage.get().resolve(passenger3);
                        if (resolve != null) {
                            entity = (Person)resolve.getEntity();
                            if (entity != null) {
                                String string = ProfileHelper.getFullName((Person)entity, (Locale)LocaleHelper.getLocale((String)"ru"), (boolean)false);
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", string);
                            } else {
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                            }
                        } else {
                            doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                        }
                    } else {
                        doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getResidenceSettings().getIncludeDateDeparture())) {
                List rooms = hotelProduct.getRooms();
                if (!rooms.isEmpty()) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(((Room)rooms.get(0)).getCheckInDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getResidenceSettings().getIncludeDateArriver())) {
                List rooms = hotelProduct.getRooms();
                if (!rooms.isEmpty()) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(((Room)rooms.get(rooms.size() - 1)).getCheckOutDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getResidenceSettings().getIncludeCityDeparture())) {
                DictionaryReference hotelLocation = hotelProduct.getHotelLocation();
                if (hotelLocation != null) {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", GeoLocationHelper.getCity((DictionaryReference)hotelLocation).toString());
                } else {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getResidenceSettings().getIncludeClassService())) {
                List rooms = hotelProduct.getRooms();
                if (!rooms.isEmpty()) {
                    doc.getInfoSectionParamets().put("\u041a\u043b\u0430\u0441\u0441\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", ((Room)rooms.get(0)).getRoomName());
                } else {
                    doc.getInfoSectionParamets().put("\u041a\u043b\u0430\u0441\u0441\u041e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getResidenceSettings().getIncludePersonnelNumber())) {
                Optional<String> personnelNumber4 = this.getPersonnelNumber((BaseProduct)hotelProduct);
                if (personnelNumber4.isPresent()) {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", personnelNumber4.get());
                } else {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getResidenceSettings().getIncludeNumberSales()) && ProductStatus.REFUND.equals((Object)hotelProduct.getStatus())) {
                doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0410\u043a\u0442\u0430\u041f\u0440\u043e\u0434\u0430\u0436\u0438", SbisCreateAcceptanceCertificateFileProcessor.getShipment((BaseProduct)hotelProduct.getPreviousProduct(), sc));
            }
        }
        if (firstProduct instanceof Transfer) {
            Transfer transfer = (Transfer)firstProduct;
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getTransferSettings().getIncludeContractNumber())) {
                if (contractNumber != null) {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", contractNumber);
                } else {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getTransferSettings().getIncludeDateContract())) {
                if (dateContract != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", dateContract);
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getTransferSettings().getIncludeTypeServices())) {
                doc.getInfoSectionParamets().put("\u0422\u0438\u043f\u0423\u0441\u043b\u0443\u0433\u0438", "\u0422\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u043d\u044b\u0435 \u0443\u0441\u043b\u0443\u0433\u0438");
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getTransferSettings().getIncludeTraveler())) {
                if (!transfer.getTravellers().isEmpty()) {
                    EntityReference passenger4 = ((Traveller)transfer.getTravellers().get(0)).getPassenger();
                    if (passenger4 != null) {
                        resolve = EntityStorage.get().resolve(passenger4);
                        if (resolve != null) {
                            entity = (Person)resolve.getEntity();
                            if (entity != null) {
                                String string = ProfileHelper.getFullName((Person)entity, (Locale)LocaleHelper.getLocale((String)"ru"), (boolean)false);
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", string);
                            } else {
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                            }
                        } else {
                            doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                        }
                    } else {
                        doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getTransferSettings().getIncludeDateDeparture())) {
                if (transfer.getStartDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(transfer.getStartDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getTransferSettings().getIncludeDateArriver())) {
                if (transfer.getEndDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(transfer.getEndDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getTransferSettings().getIncludeCityDeparture())) {
                if (transfer.getStartCity() != null) {
                    GeoLocation cityDeparture2 = GeoLocationHelper.getCity((DictionaryReference)transfer.getStartCity());
                    if (cityDeparture2 != null) {
                        doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", cityDeparture2.toString());
                    } else {
                        doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getTransferSettings().getIncludePersonnelNumber())) {
                Optional<String> personnelNumber5 = this.getPersonnelNumber((BaseProduct)transfer);
                if (personnelNumber5.isPresent()) {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", personnelNumber5.get());
                } else {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getTransferSettings().getIncludeNumberSales()) && ProductStatus.REFUND.equals((Object)transfer.getStatus())) {
                doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0410\u043a\u0442\u0430\u041f\u0440\u043e\u0434\u0430\u0436\u0438", SbisCreateAcceptanceCertificateFileProcessor.getShipment((BaseProduct)transfer.getPreviousProduct(), sc));
            }
        }
        if (firstProduct instanceof TaxiProduct) {
            TaxiProduct taxi = (TaxiProduct)firstProduct;
            SbisTaxiAktExportParametersSettings taxiSettings = parametersSettings.getAktSettings().getTaxiSettings();
            if (Boolean.TRUE.equals(taxiSettings.getIncludeContractNumber())) {
                if (contractNumber != null) {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", contractNumber);
                } else {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(taxiSettings.getIncludeDateContract())) {
                if (dateContract != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", dateContract);
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(taxiSettings.getIncludeTypeServices())) {
                doc.getInfoSectionParamets().put("\u0422\u0438\u043f\u0423\u0441\u043b\u0443\u0433\u0438", "\u0422\u0430\u043a\u0441\u0438");
            }
            if (Boolean.TRUE.equals(taxiSettings.getIncludeTraveler())) {
                if (!taxi.getTravellers().isEmpty()) {
                    traveller = (Traveller)taxi.getTravellers().get(0);
                    doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", this.getNameTraveller(traveller));
                } else {
                    doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                }
            }
            if (Boolean.TRUE.equals(taxiSettings.getIncludeDateDeparture())) {
                if (taxi.getFinishDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(taxi.getFinishDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(taxiSettings.getIncludeDateArriver())) {
                if (taxi.getFinishDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(taxi.getFinishDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(taxiSettings.getIncludeCityDeparture())) {
                if (taxi.getCity() != null) {
                    cityDeparture = GeoLocationHelper.getCity((DictionaryReference)taxi.getCity());
                    if (cityDeparture != null) {
                        doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", cityDeparture.toString());
                    } else {
                        doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(taxiSettings.getIncludePersonnelNumber())) {
                personnelNumber = this.getPersonnelNumber((BaseProduct)taxi);
                if (personnelNumber.isPresent()) {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", personnelNumber.get());
                } else {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getTaxiSettings().getIncludeNumberSales()) && ProductStatus.REFUND.equals((Object)taxi.getStatus())) {
                doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0410\u043a\u0442\u0430\u041f\u0440\u043e\u0434\u0430\u0436\u0438", SbisCreateAcceptanceCertificateFileProcessor.getShipment((BaseProduct)taxi.getPreviousProduct(), sc));
            }
        }
        if (firstProduct instanceof CarRentalProduct) {
            CarRentalProduct carRental = (CarRentalProduct)firstProduct;
            SbisRentCarAktExportParametersSettings rentCarSettings = parametersSettings.getAktSettings().getRentCarSettings();
            if (Boolean.TRUE.equals(rentCarSettings.getIncludeContractNumber())) {
                if (contractNumber != null) {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", contractNumber);
                } else {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(rentCarSettings.getIncludeDateContract())) {
                if (dateContract != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", dateContract);
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(rentCarSettings.getIncludeTypeServices())) {
                doc.getInfoSectionParamets().put("\u0422\u0438\u043f\u0423\u0441\u043b\u0443\u0433\u0438", "\u0410\u0440\u0435\u043d\u0434\u0430 \u0430\u0432\u0442\u043e");
            }
            if (Boolean.TRUE.equals(rentCarSettings.getIncludeTraveler())) {
                if (!carRental.getTravellers().isEmpty()) {
                    traveller = (Traveller)carRental.getTravellers().get(0);
                    doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", this.getNameTraveller(traveller));
                } else {
                    doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                }
            }
            if (Boolean.TRUE.equals(rentCarSettings.getIncludeDateDeparture())) {
                if (carRental.getStartDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(carRental.getStartDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(rentCarSettings.getIncludeDateArriver())) {
                if (carRental.getEndDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(carRental.getEndDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u041f\u0440\u0438\u0431\u044b\u0442\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(rentCarSettings.getIncludeCityDeparture())) {
                if (carRental.getStartLocation() != null) {
                    cityDeparture = GeoLocationHelper.getCity((DictionaryReference)carRental.getStartLocation());
                    if (cityDeparture != null) {
                        doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", cityDeparture.toString());
                    } else {
                        doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u0413\u043e\u0440\u043e\u0434\u041e\u0442\u044a\u0435\u0437\u0434\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(rentCarSettings.getIncludePersonnelNumber())) {
                personnelNumber = this.getPersonnelNumber((BaseProduct)carRental);
                if (personnelNumber.isPresent()) {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", personnelNumber.get());
                } else {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getRentCarSettings().getIncludeNumberSales()) && ProductStatus.REFUND.equals((Object)carRental.getStatus())) {
                doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0410\u043a\u0442\u0430\u041f\u0440\u043e\u0434\u0430\u0436\u0438", SbisCreateAcceptanceCertificateFileProcessor.getShipment((BaseProduct)carRental.getPreviousProduct(), sc));
            }
        }
        if (firstProduct instanceof VisaProduct) {
            VisaProduct visaProduct = (VisaProduct)firstProduct;
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getVisaSettings().getIncludeContractNumber())) {
                if (contractNumber != null) {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", contractNumber);
                } else {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getVisaSettings().getIncludeDateContract())) {
                if (dateContract != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", dateContract);
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getVisaSettings().getIncludeTypeServices())) {
                doc.getInfoSectionParamets().put("\u0422\u0438\u043f\u0423\u0441\u043b\u0443\u0433\u0438", "\u0412\u0418\u0417\u0410");
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getVisaSettings().getIncludeTraveler())) {
                if (!visaProduct.getTravellers().isEmpty()) {
                    EntityReference passenger5 = ((Traveller)visaProduct.getTravellers().get(0)).getPassenger();
                    if (passenger5 != null) {
                        resolve = EntityStorage.get().resolve(passenger5);
                        if (resolve != null) {
                            entity = (Person)resolve.getEntity();
                            if (entity != null) {
                                String string = ProfileHelper.getFullName((Person)entity, (Locale)LocaleHelper.getLocale((String)"ru"), (boolean)false);
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", string);
                            } else {
                                doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                            }
                        } else {
                            doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                        }
                    } else {
                        doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                    }
                } else {
                    doc.getInfoSectionParamets().put("\u041f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getVisaSettings().getIncludePersonnelNumber())) {
                Optional<String> personnelNumber6 = this.getPersonnelNumber((BaseProduct)visaProduct);
                if (personnelNumber6.isPresent()) {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", personnelNumber6.get());
                } else {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getVisaSettings().getIncludeDateStart())) {
                if (visaProduct.getStartDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(visaProduct.getStartDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getVisaSettings().getIncludeDateEnd())) {
                if (visaProduct.getEndDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(visaProduct.getEndDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getVisaSettings().getIncludeCountry())) {
                if (visaProduct.getCountry() != null) {
                    doc.getInfoSectionParamets().put("\u0421\u0422\u0420\u0410\u041d\u0410", visaProduct.getCountry().getCaption());
                } else {
                    doc.getInfoSectionParamets().put("\u0421\u0422\u0420\u0410\u041d\u0410", "");
                }
            }
        }
        if (firstProduct instanceof InsuranceTouristic) {
            InsuranceTouristic insuranceTouristicProduct = (InsuranceTouristic)firstProduct;
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getInsuranceTouristicSettings().getIncludeContractNumber())) {
                if (contractNumber != null) {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", contractNumber);
                } else {
                    doc.getInfoSectionParamets().put("\u041d\u043e\u043c\u0435\u0440\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getInsuranceTouristicSettings().getIncludeDateContract())) {
                if (dateContract != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", dateContract);
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getInsuranceTouristicSettings().getIncludeTypeServices())) {
                doc.getInfoSectionParamets().put("\u0422\u0438\u043f\u0423\u0441\u043b\u0443\u0433\u0438", "\u0421\u0422\u0420\u0410\u0425\u041e\u0412\u041a\u0410");
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getInsuranceTouristicSettings().getIncludeTraveler())) {
                // empty if block
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getInsuranceTouristicSettings().getIncludePersonnelNumber())) {
                Optional<String> personnelNumber7 = this.getPersonnelNumber((BaseProduct)insuranceTouristicProduct);
                if (personnelNumber7.isPresent()) {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", personnelNumber7.get());
                } else {
                    doc.getInfoSectionParamets().put("\u0422\u0430\u0431\u0435\u043b\u044c\u043d\u044b\u0439\u041d\u043e\u043c\u0435\u0440", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getInsuranceTouristicSettings().getIncludeDateStart())) {
                if (insuranceTouristicProduct.getStartDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(insuranceTouristicProduct.getStartDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getInsuranceTouristicSettings().getIncludeDateEnd())) {
                if (insuranceTouristicProduct.getEndDate() != null) {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", SbisCreateAcceptanceCertificateFileProcessor.getDateFormatter(insuranceTouristicProduct.getEndDate()));
                } else {
                    doc.getInfoSectionParamets().put("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", "");
                }
            }
            if (Boolean.TRUE.equals(parametersSettings.getAktSettings().getInsuranceTouristicSettings().getIncludeCountry())) {
                if (insuranceTouristicProduct.getCountryName() != null) {
                    doc.getInfoSectionParamets().put("\u0421\u0422\u0420\u0410\u041d\u0410", insuranceTouristicProduct.getCountryName());
                } else {
                    doc.getInfoSectionParamets().put("\u0421\u0422\u0420\u0410\u041d\u0410", "");
                }
            }
        }
        documents.put(result, documentPdf);
    }

    private SbisAcceptanceCertificateFile.SbisAktRabota createRabotaItem(BillingItem bi, int number) {
        SbisAcceptanceCertificateFile.SbisAktRabota result = new SbisAcceptanceCertificateFile.SbisAktRabota();
        result.setDescription(String.format("%s(%s)", bi.getName(), bi.getName()));
        int positionsCount = bi.getPositionsCount() == 0 ? 1 : bi.getPositionsCount();
        result.setKolvo(positionsCount);
        result.setName(bi.getName());
        result.setNds(MiscUtil.guarded((BigDecimal)bi.getAmount().getVatAmount()));
        result.setPrice(MiscUtil.guarded((BigDecimal)bi.getAmount().getValue()).divide(BigDecimal.valueOf(positionsCount), 2, RoundingMode.HALF_UP));
        result.setStavka(bi.getAmount().getVat());
        result.setStBezNDS(MiscUtil.guarded((BigDecimal)bi.getAmount().getValue()));
        result.setStSNDS(MiscUtil.guarded((BigDecimal)bi.getAmount().getTotal()));
        result.setNumber(number);
        return result;
    }

    private void fillOrg(SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrg result, SbisOrganizationData orgData, boolean supplier, boolean fillCorSchetNumber) {
        SbisOrganizationAdditionalData additionalData;
        SbisSerializable sbisAcceptanceCertificateOrgHead;
        result.setAddress(orgData.getAddress());
        result.setOkpo(orgData.getOkpo());
        if (orgData.getAdditionalData() instanceof SbisOrganizationAdditionalDataNonIP) {
            sbisAcceptanceCertificateOrgHead = (SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadNonIP)result.getSbisAcceptanceCertificateOrgHead();
            if (sbisAcceptanceCertificateOrgHead == null) {
                sbisAcceptanceCertificateOrgHead = new SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadNonIP();
                result.setSbisAcceptanceCertificateOrgHead(sbisAcceptanceCertificateOrgHead);
            }
            additionalData = (SbisOrganizationAdditionalDataNonIP)orgData.getAdditionalData();
            ((SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadNonIP)sbisAcceptanceCertificateOrgHead).setOrgName(Strings.nullToEmpty((String)((SbisOrganizationAdditionalDataNonIP)additionalData).getOrgName()));
            ((SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadNonIP)sbisAcceptanceCertificateOrgHead).setInn(Strings.nullToEmpty((String)((SbisOrganizationAdditionalDataNonIP)additionalData).getInn()));
            ((SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadNonIP)sbisAcceptanceCertificateOrgHead).setKpp(Strings.nullToEmpty((String)((SbisOrganizationAdditionalDataNonIP)additionalData).getKpp()));
        }
        if (orgData.getAdditionalData() instanceof SbisOrganizationAdditionalDataIP) {
            sbisAcceptanceCertificateOrgHead = (SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadIP)result.getSbisAcceptanceCertificateOrgHead();
            if (sbisAcceptanceCertificateOrgHead == null) {
                sbisAcceptanceCertificateOrgHead = new SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadIP();
                result.setSbisAcceptanceCertificateOrgHead(sbisAcceptanceCertificateOrgHead);
            }
            additionalData = (SbisOrganizationAdditionalDataIP)orgData.getAdditionalData();
            ((SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadIP)sbisAcceptanceCertificateOrgHead).setName(Strings.nullToEmpty((String)((SbisOrganizationAdditionalDataIP)additionalData).getName()));
            ((SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadIP)sbisAcceptanceCertificateOrgHead).setSurname(Strings.nullToEmpty((String)((SbisOrganizationAdditionalDataIP)additionalData).getSurname()));
            ((SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadIP)sbisAcceptanceCertificateOrgHead).setPatronymic(Strings.nullToEmpty((String)((SbisOrganizationAdditionalDataIP)additionalData).getPatronymic()));
            ((SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadIP)sbisAcceptanceCertificateOrgHead).setInn(Strings.nullToEmpty((String)((SbisOrganizationAdditionalDataIP)additionalData).getInn()));
            ((SbisAcceptanceCertificateFile.SbisAcceptanceCertificateOrgHeadIP)sbisAcceptanceCertificateOrgHead).setStateRegistrationInfo(Strings.nullToEmpty((String)((SbisOrganizationAdditionalDataIP)additionalData).getStateRegistrationInfo()));
        }
        if (supplier) {
            result.setBankName(orgData.getBankName());
            result.setBik(orgData.getBik());
            result.setPhone(orgData.getPhoneNumber());
            result.setSchetNumber(orgData.getSettlementAccount());
        }
    }

    private static String getDateFormatter(Date date) {
        return new SimpleDateFormat("dd.MM.yyyy").format(date);
    }

    private static String getShipment(BaseProduct product, EntityStorageContext sc) {
        if (product == null) {
            return "";
        }
        StringBuilder shipments = new StringBuilder();
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).map(fopComponent -> EntityStorageHelper.resolve((EntityReference)fopComponent.getShipment(), (EntityStorageContext)sc)).filter(Objects::nonNull).filter(shipmentEntityContainer -> !shipments.toString().contains(((Shipment)shipmentEntityContainer.getEntity()).getNumber())).forEach(shipmentEntityContainer -> shipments.append(((Shipment)shipmentEntityContainer.getEntity()).getNumber()).append(" "));
        return shipments.toString().trim();
    }

    private static String getShipmentNumberByTicket(BaseProduct product, EntityStorageContext sc) {
        if (product == null) {
            return "";
        }
        String systemNumberProduct = GeneralProductHelper.getSystemNumber((BaseProduct)product);
        if (TextUtil.isBlank((String)systemNumberProduct)) {
            return "";
        }
        return product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).map(fopComponent -> EntityStorageHelper.resolve((EntityReference)fopComponent.getShipment(), (EntityStorageContext)sc)).filter(Objects::nonNull).filter(shipmentEntityContainer -> {
            Shipment shipment = (Shipment)shipmentEntityContainer.getEntity();
            List billingItemList = FinanceDocumentHelper.getBillingItems((List)shipment.getBillingItems(), (EntityStorageContext)sc);
            String numberShipment = billingItemList.stream().filter(billingItem -> {
                BaseProduct baseProduct = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItem.getProduct(), (EntityStorageContext)sc);
                if (baseProduct != null) {
                    String systemNumberFromBillingItem = GeneralProductHelper.getSystemNumber((BaseProduct)baseProduct);
                    return systemNumberProduct.equals(systemNumberFromBillingItem) && ServiceType.TICKET.equals((Object)billingItem.getServiceType());
                }
                return false;
            }).findFirst().map(billingItem -> {
                if (billingItem.getShipment() != null) {
                    return billingItem.getShipment().getCaption();
                }
                return "";
            }).orElse("");
            return !TextUtil.isBlank((String)numberShipment);
        }).findFirst().map(shipmentEntityContainer -> ((Shipment)shipmentEntityContainer.getEntity()).getNumber()).orElse("");
    }

    private Optional<String> getPersonnelNumber(BaseProduct product) {
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        StatisticalData statisticalData = handler.getStatisticalData(product);
        if (statisticalData == null) {
            return Optional.empty();
        }
        return this.getPersonnelNumber(statisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()));
    }

    private Optional<String> getPersonnelNumber(Stream<CostCode> costCodes) {
        return costCodes.filter(costCode -> costCode.getCostCodeProperties() != null).filter(costCode -> {
            CostCodeCategory costCodeCategory = (CostCodeCategory)DictionaryCache.get().resolveReference(costCode.getCostCodeProperties().getCategory());
            return costCodeCategory != null && costCodeCategory.getSbisCostCodeType() == SbisCostCodeType.PERSONNEL_NUMBER;
        }).map(CostCode::getValue).filter(TextUtil::nonBlank).findFirst();
    }

    private String getNameTraveller(Traveller traveller) {
        if (traveller.getCyrillicName() != null) {
            return traveller.getCyrillicName();
        }
        if (traveller.getName() != null) {
            return traveller.getName();
        }
        return "";
    }

    private void fillSbisDocumentSignerData(SbisDocumentSigner podpisant) {
        podpisant.setOblPoln("1");
        podpisant.setFirstName("-");
        podpisant.setLastName("-");
    }
}

