/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis;

import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.ibecorp.rules.SbisActionSet;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentFormat;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentFormatSettings;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisDocumentSigner;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisInvoiceFacturaFile;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganization;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationData;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisSvedTov;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SbisCreateInvoiceFacturaFileProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer shipmentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SHIPMENT_CONTAINER);
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer invoiceFacturaCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENT_CONTAINER);
        HashMap documents = (HashMap)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENTS);
        ArrayList documentsAsPdf = (ArrayList)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENTS_AS_PDF);
        String customerCode = (String)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_CUSTOMER_CODE);
        String customerIdentifier = (String)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_CUSTOMER_IDENTIFIER);
        Map vendorBillingItems = (Map)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_VENDOR_BILLING_ITEMS);
        FinanceDocument invoiceFactura = (FinanceDocument)invoiceFacturaCtr.getEntity();
        if (invoiceFactura.getDate() == null) {
            throw Xeption.forEndUser((String)"\u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u0441\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b", (Object[])new Object[0]);
        }
        LocalDate documentDate = MiscUtil.toLocalDate((Date)invoiceFactura.getDate());
        SbisInvoiceFacturaFile result = new SbisInvoiceFacturaFile();
        SbisOrganizationData supplierData = SbisIntegrationHelper.buildOrganizationData(invoiceFactura, sc, customerCode, customerIdentifier, true, true);
        SbisOrganizationData customerData = SbisIntegrationHelper.buildOrganizationData(invoiceFactura, sc, customerCode, customerIdentifier, false, false);
        result.getSvUchDocObor().setIdOtpr(supplierData.getUid());
        result.getSvUchDocObor().setIdPoluch(customerData.getUid());
        String fileId = String.format("ON_NSCHFDOPPR_%s_%s_%s_%s_0_0_0_0_0_00", result.getSvUchDocObor().getIdPoluch(), result.getSvUchDocObor().getIdOtpr(), SbisIntegrationHelper.filenameDateFormatter.format(documentDate), invoiceFacturaCtr.getUid());
        String pdfFileId = String.format("\u0421\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0430_%s_%s", invoiceFactura.getNumber(), SbisIntegrationHelper.filenameDateFormatter.format(documentDate)).replaceAll("_{2,}", "_");
        SbisDocumentFormatSettings formatSettings = (SbisDocumentFormatSettings)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.DOCUMENTS_FORMAT_SETTINGS);
        Document documentPdf = null;
        if (formatSettings.getInvoiceFactura() == SbisDocumentFormat.PDF || formatSettings.getInvoiceFactura() == SbisDocumentFormat.XML_AND_PDF) {
            documentPdf = SbisIntegrationHelper.createFinanceDocument((EntityContainer<FinanceDocument>)invoiceFacturaCtr, pdfFileId);
            if (formatSettings.getInvoiceFactura() == SbisDocumentFormat.PDF) {
                documentsAsPdf.add(documentPdf);
                return;
            }
        }
        documents.put(result, documentPdf);
        result.setFileId(fileId);
        result.setInfPrDate(MiscUtil.toLocalDateTime((Date)invoiceFacturaCtr.getModified()));
        result.setNaimEconSubSost(String.format("%s, \u0418\u041d\u041d/\u041a\u041f\u041f %s/%s", supplierData.getName(), supplierData.getInn(), supplierData.getKpp()));
        result.setNumber(TextUtil.buildFullNumber((CompositeNumber)invoiceFactura));
        result.setFacturaDate(documentDate);
        this.fillOrg(result.getSvProd(), supplierData, true, true);
        this.fillOrg(result.getSvPok(), customerData, false, false);
        this.fillSbisDocumentSignerData(result.getPodpisant());
        String bookingCtrUid = null;
        int porNomer = 1;
        BigDecimal itogoSNDS = BigDecimal.ZERO;
        BigDecimal itogoNDS = BigDecimal.ZERO;
        HashMap<ExtendedProductType, SbisActionSet> sbisActionSets = new HashMap<ExtendedProductType, SbisActionSet>();
        HashMap<ExtendedProductType, SbisActionSet> sbisIntermediaryActionSets = new HashMap<ExtendedProductType, SbisActionSet>();
        HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> resultAttributes = new HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>>();
        for (SbisIntegrationHelper.BillingItemWrapper billingItemWrapper : SbisIntegrationHelper.getMergedBillingItem(invoiceFactura, sc, (Boolean)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SUPPLIER_IS_SIMPLE_TAXED), invoiceFactura.getVatViewMode(), vendorBillingItems)) {
            BillingItem bi = billingItemWrapper.getBillingItem();
            Nomenclature nom = null;
            for (NestedEntityReference fopComp : bi.getFopComponents()) {
                FopComponent fopComponent;
                if (bookingCtrUid == null) {
                    bookingCtrUid = fopComp.getUid();
                }
                if ((fopComponent = (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)fopComp, (EntityStorageContext)sc)) == null || (nom = (Nomenclature)DictionaryCache.get().resolveReference(fopComponent.getNomenclature())) == null) continue;
                break;
            }
            if (nom == null) {
                throw Xeption.forEndUser((String)"\u0432 \u0441\u0447\u0435\u0442\u0435 \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u0443", (Object[])new Object[]{porNomer});
            }
            Integer nds = bi.getAmount().getVat() == null ? null : Integer.valueOf((int)Math.round(bi.getAmount().getVat()));
            SbisSvedTov row = new SbisSvedTov(result.getPriceFormatter());
            int positionsCount = bi.getPositionsCount() == 0 ? 1 : bi.getPositionsCount();
            row.setKolTov(positionsCount);
            row.setNaimTov(bi.getName());
            row.setNomStr(porNomer);
            row.setStTovSNDS(MiscUtil.guarded((BigDecimal)bi.getAmount().getTotal()));
            row.setStTovBezNDS(MiscUtil.guarded((BigDecimal)bi.getAmount().getValue()));
            row.setPriceTov(row.getStTovBezNDS().divide(BigDecimal.valueOf(positionsCount), 2, RoundingMode.HALF_UP));
            row.setStavkaNDS(nds);
            row.setSumNal(MiscUtil.guarded((BigDecimal)bi.getAmount().getVatAmount()));
            row.setId(bi.getUid());
            String ruNomName = (String)nom.getTranslations().get(LocaleHelper.RU_LOCALE);
            if (ruNomName == null) {
                if (!nom.getTranslations().isEmpty()) {
                    ruNomName = (String)nom.getTranslations().values().iterator().next();
                } else {
                    throw Xeption.forEndUser((String)"\u0432 \u043d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u0435 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", (Object[])new Object[]{nom.getCode()});
                }
            }
            row.setNaimenovanie(ruNomName);
            EntityContainer bookingCtr = EntityStorageHelper.resolve((EntityReference)new EntityReference(bookingCtrUid, BookingFile.class, null), (EntityStorageContext)sc);
            row.setHarakteristika(String.format("\u0417\u0430\u043a\u0430\u0437 \u2116 %s \u043e\u0442 %s", ((BookingFile)bookingCtr.getEntity()).getNumber(), SbisIntegrationHelper.dateFormat.format(MiscUtil.toLocalDate((Date)(((BookingFile)bookingCtr.getEntity()).getCreateDate() == null ? bookingCtr.getCreated() : ((BookingFile)bookingCtr.getEntity()).getCreateDate())))));
            row.setKodTov(nom.getCode());
            Map<Object, Object> attributes = new HashMap();
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)bi.getProduct(), (EntityStorageContext)sc);
            boolean isIntermediaryService = SbisIntegrationHelper.isIntermediaryService(billingItemWrapper, sc);
            if (product != null) {
                ExtendedProductType productType = SbisIntegrationHelper.getExtendedProductType(product);
                ExtendedProductType appliedProductType = sbisActionSets.keySet().stream().filter(type -> type.getProductType() == productType.getProductType() && MiscUtil.equals((Object)type.getProductDescription(), (Object)productType.getProductDescription())).findFirst().orElse(null);
                if (isIntermediaryService) {
                    appliedProductType = sbisIntermediaryActionSets.keySet().stream().filter(type -> type.getProductType() == productType.getProductType() && MiscUtil.equals((Object)type.getProductDescription(), (Object)productType.getProductDescription())).findFirst().orElse(null);
                }
                SbisActionSet sbisActionSet = (SbisActionSet)sbisActionSets.get(appliedProductType);
                if (isIntermediaryService) {
                    sbisActionSet = (SbisActionSet)sbisIntermediaryActionSets.get(appliedProductType);
                }
                if (sbisActionSet == null) {
                    sbisActionSet = SbisIntegrationHelper.applyRules((EntityContainer<Shipment>)shipmentCtr, invoiceFactura, product, isIntermediaryService);
                    if (isIntermediaryService) {
                        sbisIntermediaryActionSets.put(productType, sbisActionSet);
                    } else {
                        sbisActionSets.put(productType, sbisActionSet);
                    }
                }
                attributes = SbisIntegrationHelper.getElementsAttributes(product, billingItemWrapper, (NestedEntityReference<BookingFile, Traveller>)bi.getTraveller(), sbisActionSet.getSbisDocumentElementsData(), invoiceFactura.getDate(), sc);
                row.setSbisDocumentElementsAttributes(new HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>>());
                row.getSbisDocumentElementsAttributes().putAll(attributes);
            }
            for (Map.Entry entry : attributes.entrySet()) {
                HashSet elementAttributes = (HashSet)resultAttributes.get(entry.getKey());
                if (elementAttributes == null) {
                    elementAttributes = new HashSet();
                }
                elementAttributes.addAll((Collection)entry.getValue());
                resultAttributes.put((String)entry.getKey(), elementAttributes);
            }
            itogoSNDS = itogoSNDS.add(row.getStTovSNDS());
            itogoNDS = itogoNDS.add(row.getSumNal());
            ++porNomer;
            result.getPositions().add(row);
        }
        result.setIdDocOsn(bookingCtrUid);
        result.setTotalBezNDS(itogoSNDS.subtract(itogoNDS));
        result.setTotalSNDS(itogoSNDS);
        result.setTotalKolvo(result.getPositions().size());
        result.getSbisDocumentElementsAttributes().putAll(SbisIntegrationHelper.mergeAttributes(resultAttributes));
    }

    private void fillOrg(SbisOrganization result, SbisOrganizationData orgData, boolean supplier, boolean fillCorSchetNumber) {
        result.setAddress(orgData.getAddress());
        result.setCountryCode(orgData.getCountryCode());
        result.setCountryName(orgData.getCountryName());
        result.setZip(orgData.getZip());
        result.setRegionCode(orgData.getRegionCode());
        result.setRegionName(orgData.getRegionName());
        result.setCityName(orgData.getCityName());
        result.setStreet(orgData.getStreet());
        result.setHouse(orgData.getHouse());
        result.setInn(orgData.getInn());
        result.setKpp(orgData.getKpp());
        result.setNaimOrg(orgData.getName());
        if (supplier) {
            result.setBankName(orgData.getBankName());
            result.setBik(orgData.getBik());
            result.setPhone(orgData.getPhoneNumber());
            result.setSchetNumber(orgData.getSettlementAccount());
            if (fillCorSchetNumber) {
                result.setCorSchetNumber(orgData.getCorrespondentAccount());
            }
        }
    }

    private void fillSbisDocumentSignerData(SbisDocumentSigner podpisant) {
        podpisant.setOblPoln("5");
        podpisant.setFirstName("-");
        podpisant.setLastName("-");
    }
}

