/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis;

import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.ibecorp.rules.SbisActionSet;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentFormat;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentFormatSettings;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisInvoiceFile;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationAdditionalDataIP;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SbisCreateInvoiceFileProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer shipmentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SHIPMENT_CONTAINER);
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer invoiceCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENT_CONTAINER);
        HashMap documents = (HashMap)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENTS);
        ArrayList documentsAsPdf = (ArrayList)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENTS_AS_PDF);
        String customerCode = (String)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_CUSTOMER_CODE);
        String customerIdentifier = (String)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_CUSTOMER_IDENTIFIER);
        Map vendorBillingItems = (Map)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_VENDOR_BILLING_ITEMS);
        FinanceDocument invoice = (FinanceDocument)invoiceCtr.getEntity();
        if (invoice.getDate() == null) {
            throw Xeption.forEndUser((String)"\u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u0441\u0447\u0435\u0442\u0430", (Object[])new Object[0]);
        }
        String fileId = String.format("ON_SCHET___%s_%s", SbisIntegrationHelper.filenameDateFormatter.format(MiscUtil.toLocalDate((Date)invoice.getDate())), invoiceCtr.getUid());
        String pdfFileId = String.format("\u0421\u0447\u0435\u0442_%s_%s", invoice.getNumber(), SbisIntegrationHelper.filenameDateFormatter.format(MiscUtil.toLocalDate((Date)invoice.getDate()))).replaceAll("_{2,}", "_");
        SbisDocumentFormatSettings formatSettings = (SbisDocumentFormatSettings)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.DOCUMENTS_FORMAT_SETTINGS);
        Document documentPdf = null;
        if (formatSettings.getInvoice() == SbisDocumentFormat.PDF || formatSettings.getInvoice() == SbisDocumentFormat.XML_AND_PDF) {
            documentPdf = SbisIntegrationHelper.createFinanceDocument((EntityContainer<FinanceDocument>)invoiceCtr, pdfFileId);
            if (formatSettings.getInvoice() == SbisDocumentFormat.PDF) {
                documentsAsPdf.add(documentPdf);
                return;
            }
        }
        SbisInvoiceFile result = new SbisInvoiceFile();
        documents.put(result, documentPdf);
        result.setFileId(fileId);
        result.setDate(MiscUtil.toLocalDateTime((Date)invoice.getDate()));
        result.setNumber(TextUtil.buildFullNumber((CompositeNumber)invoice));
        SbisOrganizationData supplierData = SbisIntegrationHelper.buildOrganizationData(invoice, sc, customerCode, customerIdentifier, true, true);
        SbisInvoiceFile.SbisInvoiceSupplier supplier = result.getSupplier();
        if (supplierData.getAdditionalData() instanceof SbisOrganizationAdditionalDataIP) {
            supplier.setIndividualEntrepreneur(true);
        } else {
            supplier.setIndividualEntrepreneur(false);
            supplier.setKpp(supplierData.getKpp());
        }
        supplier.setAddressText(supplierData.getAddress());
        supplier.setInn(supplierData.getInn());
        supplier.setName(supplierData.getName());
        supplier.setPhone(supplierData.getPhoneNumber());
        supplier.setBankName(supplierData.getBankName());
        supplier.setBik(supplierData.getBik());
        supplier.setSettlementAccount(supplierData.getSettlementAccount());
        supplier.setCorrespondentAccount(supplierData.getCorrespondentAccount());
        SbisOrganizationData customerData = SbisIntegrationHelper.buildOrganizationData(invoice, sc, customerCode, customerIdentifier, false, false);
        SbisInvoiceFile.SbisInvoiceCustomer customer = result.getCustomer();
        if (customerData.getAdditionalData() instanceof SbisOrganizationAdditionalDataIP) {
            customer.setIndividualEntrepreneur(true);
        } else {
            customer.setIndividualEntrepreneur(false);
            customer.setKpp(supplierData.getKpp());
        }
        customer.setAddressText(customerData.getAddress());
        customer.setInn(customerData.getInn());
        customer.setKpp(customerData.getKpp());
        customer.setName(customerData.getName());
        customer.setPhone(customerData.getPhoneNumber());
        EntityContainer contractCtr = EntityStorageHelper.resolve((EntityReference)((FinanceDocument)invoiceCtr.getEntity()).getContract(), (EntityStorageContext)sc);
        if (contractCtr == null) {
            throw Xeption.forEndUser((String)"\u0432 \u0421\u0447\u0435\u0442\u0435 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440", (Object[])new Object[0]);
        }
        if (((Contract)contractCtr.getEntity()).getIssueDate() == null) {
            throw Xeption.forEndUser((String)"\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f", (Object[])new Object[]{contractCtr.toReference()});
        }
        result.setDogovorDate(MiscUtil.toLocalDate((Date)((Contract)contractCtr.getEntity()).getIssueDate()));
        String dogovorNumber = ((Contract)contractCtr.getEntity()).getNumber();
        if (TextUtil.isBlank((String)dogovorNumber)) {
            throw Xeption.forEndUser((String)"\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u043d\u043e\u043c\u0435\u0440", (Object[])new Object[]{contractCtr.toReference()});
        }
        result.setDogovorNumber(dogovorNumber);
        result.setInfPodval(String.format("\u0420\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u2116%s \u043e\u0442 %s", ((Shipment)shipmentCtr.getEntity()).getNumber(), SbisIntegrationHelper.dateFormat.format(MiscUtil.toLocalDate((Date)((Shipment)shipmentCtr.getEntity()).getDate()))));
        int porNomer = 1;
        BigDecimal itogoKOplate = BigDecimal.ZERO;
        BigDecimal itogoNDS = BigDecimal.ZERO;
        BigDecimal nds10 = BigDecimal.ZERO;
        BigDecimal nds20 = BigDecimal.ZERO;
        BigDecimal bezNds = BigDecimal.ZERO;
        HashSet<NestedEntityReference> includedProducts = new HashSet<NestedEntityReference>();
        HashMap<ExtendedProductType, SbisActionSet> sbisActionSets = new HashMap<ExtendedProductType, SbisActionSet>();
        HashMap<ExtendedProductType, SbisActionSet> sbisIntermediaryActionSets = new HashMap<ExtendedProductType, SbisActionSet>();
        HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> resultAttributes = new HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>>();
        for (SbisIntegrationHelper.BillingItemWrapper billingItemWrapper : SbisIntegrationHelper.getMergedBillingItem(invoice, sc, (Boolean)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SUPPLIER_IS_SIMPLE_TAXED), invoice.getVatViewMode(), vendorBillingItems)) {
            NestedEntityReference fopComp;
            FopComponent fopComponent;
            BillingItem bi = billingItemWrapper.getBillingItem();
            boolean isIntermediaryService = SbisIntegrationHelper.isIntermediaryService(billingItemWrapper, sc);
            Map<Object, Object> attributes = new HashMap();
            BaseProduct product = null;
            if (bi.getProduct() != null) {
                includedProducts.add(bi.getProduct());
                product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)bi.getProduct(), (EntityStorageContext)sc);
            }
            Nomenclature nom = null;
            Iterator iterator = bi.getFopComponents().iterator();
            while (iterator.hasNext() && ((fopComponent = (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)(fopComp = (NestedEntityReference)iterator.next()), (EntityStorageContext)sc)) == null || (nom = (Nomenclature)DictionaryCache.get().resolveReference(fopComponent.getNomenclature())) == null)) {
            }
            if (nom == null) {
                throw Xeption.forEndUser((String)"\u0432 \u0441\u0447\u0435\u0442\u0435 \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u0443", (Object[])new Object[]{porNomer});
            }
            Integer nds = bi.getAmount().getVat() == null ? null : Integer.valueOf((int)Math.round(bi.getAmount().getVat()));
            SbisInvoiceFile.SbisInvoiceTableRow row = new SbisInvoiceFile.SbisInvoiceTableRow(result.getKolvoFormatter(), result.getPriceFormatter());
            row.setCode(nom.getCode());
            row.setId(nom.getUid());
            int positionsCount = bi.getPositionsCount() == 0 ? 1 : bi.getPositionsCount();
            row.setKolvo(positionsCount);
            row.setName(bi.getName());
            row.setPorNomer(porNomer);
            row.setNds(nds);
            row.setSum(MiscUtil.guarded((BigDecimal)bi.getAmount().getTotal()));
            row.setSumBezNal(MiscUtil.guarded((BigDecimal)bi.getAmount().getValue()));
            row.setPrice(row.getSumBezNal().divide(BigDecimal.valueOf(positionsCount), 2, RoundingMode.HALF_UP));
            BigDecimal ndsValue = MiscUtil.guarded((BigDecimal)bi.getAmount().getVatAmount());
            itogoKOplate = itogoKOplate.add(row.getSum());
            itogoNDS = itogoNDS.add(ndsValue);
            if (nds == null) {
                bezNds = bezNds.add(row.getSum());
            } else if (nds == 10) {
                nds10 = nds10.add(ndsValue);
            } else {
                nds20 = nds20.add(ndsValue);
            }
            if (product != null) {
                ExtendedProductType productType = SbisIntegrationHelper.getExtendedProductType(product);
                ExtendedProductType appliedProductType = sbisActionSets.keySet().stream().filter(type -> type.getProductType() == productType.getProductType() && MiscUtil.equals((Object)type.getProductDescription(), (Object)productType.getProductDescription())).findFirst().orElse(null);
                SbisActionSet sbisActionSet = (SbisActionSet)sbisActionSets.get(appliedProductType);
                if (isIntermediaryService) {
                    sbisActionSet = (SbisActionSet)sbisIntermediaryActionSets.get(appliedProductType);
                }
                if (sbisActionSet == null) {
                    sbisActionSet = SbisIntegrationHelper.applyRules((EntityContainer<Shipment>)shipmentCtr, invoice, product, isIntermediaryService);
                    if (isIntermediaryService) {
                        sbisIntermediaryActionSets.put(productType, sbisActionSet);
                    } else {
                        sbisActionSets.put(productType, sbisActionSet);
                    }
                }
                attributes = SbisIntegrationHelper.getElementsAttributes(product, billingItemWrapper, (NestedEntityReference<BookingFile, Traveller>)bi.getTraveller(), sbisActionSet.getSbisDocumentElementsData(), invoice.getDate(), sc);
                row.getSbisDocumentElementsAttributes().putAll(attributes);
            }
            for (Map.Entry entry : attributes.entrySet()) {
                HashSet elementAttributes = (HashSet)resultAttributes.get(entry.getKey());
                if (elementAttributes == null) {
                    elementAttributes = new HashSet();
                }
                elementAttributes.addAll((Collection)entry.getValue());
                resultAttributes.put((String)entry.getKey(), elementAttributes);
            }
            result.getRows().add(row);
            ++porNomer;
        }
        BigDecimal totalCommission = BigDecimal.ZERO;
        for (NestedEntityReference productRef : includedProducts) {
            GeneralProductContractRelationData contractRelation;
            BaseProduct ticketProduct = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)productRef, (EntityStorageContext)sc);
            if (ticketProduct == null || (contractRelation = (GeneralProductContractRelationData)ProductHandler.of((BaseProduct)ticketProduct).getUnmodifiableContractRelations(ticketProduct).stream().filter(item -> MiscUtil.equals((Object)item.getGeneralData().getContractData().getContract(), (Object)invoice.getContract())).findFirst().orElse(null)) == null) continue;
            BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)contractRelation.getCommissions(), (Set)GeneralProductHelper.commissionCommissionPropertyTypes, null, null));
            ProductStatus status = GeneralProductHelper.getStatus((BaseProduct)ticketProduct);
            totalCommission = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalCommission, status == ProductStatus.REFUND || status == ProductStatus.EXCHANGE ? MiscUtil.negate((BigDecimal)commissionsEquivalentValue) : commissionsEquivalentValue});
        }
        itogoKOplate = itogoKOplate.subtract(totalCommission);
        result.setItogoKolvo(result.getRows().size());
        result.setItogoKOplate(itogoKOplate);
        result.setBezNDS(bezNds);
        result.setNds10(nds10);
        result.setNds20(nds20);
        result.setCommission(totalCommission);
        result.setItogoNDS(itogoNDS);
        result.setItogoSum(itogoKOplate);
        result.setItogoSumBezNal(itogoKOplate.subtract(itogoNDS));
        result.getSbisDocumentElementsAttributes().putAll(SbisIntegrationHelper.mergeAttributes(resultAttributes));
    }
}

