/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis;

import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisIntegrationSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisFile;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationAdditionalDataIP;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationData;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisSerializable;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisServiceFile;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SbisCreateServiceFileProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SbisServiceFile result = new SbisServiceFile();
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SHIPMENT);
        SbisOrganizationData supplierData = (SbisOrganizationData)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SUPPLIER_DATA);
        SbisOrganizationData customerData = (SbisOrganizationData)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.CUSTOMER_DATA);
        HashMap documents = (HashMap)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENTS);
        ArrayList documentsAsPdf = (ArrayList)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENTS_AS_PDF);
        result.setContragent(this.createLegalEntity(customerData));
        result.setOrganization(this.createLegalEntity(supplierData));
        result.setDocumentUid(shipment.getUid());
        for (Map.Entry entry : documents.entrySet()) {
            this.addFinanceDocumentAttachment(result.getAttachments(), ctx, (SbisFile)entry.getKey(), (Document)entry.getValue());
        }
        for (Document document : documentsAsPdf) {
            this.addFinanceDocumentAttachment(result.getAttachments(), ctx, null, document);
        }
        this.addRelatedDocumentsAttachments(result.getAttachments(), ctx);
        List docs = (List)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.FILES_TO_EXPORT);
        Document reg = docs.stream().filter(it -> it.getType() == DocumentType.SHIPMENT_TICKETS_REGISTRY).findFirst().orElse(null);
        if (reg != null) {
            SbisIntegrationSettings settings = (SbisIntegrationSettings)ctx.getObject((Enum)IBusSbisContextKeys.INTEGRATION_SETTINGS);
            String baseDirInDocument = settings.getGeneralSettings().getBaseDirInDocument();
            SbisServiceFile.SbisDocumentsAttachment attachment = new SbisServiceFile.SbisDocumentsAttachment();
            attachment.setFileName(reg.getName());
            attachment.setPath(TextUtil.nonBlank((String)baseDirInDocument) ? baseDirInDocument + "\\" + reg.getName() : reg.getName());
            result.getAttachments().add(attachment);
        }
        Document doc = new Document();
        EntityReference currentUser = ProfileHelper.getCurrentUser();
        String format = "DOCUMENTS_%s%s_%s%s_%s_%s.native.xml";
        EntityContainer currentUserCtr = EntityStorage.get().resolve(currentUser);
        if (currentUserCtr != null && ((Person)currentUserCtr.getEntity()).isSwitchNativeOnOriginalSbis()) {
            format = "DOCUMENTS_%s%s_%s%s_%s_%s.original.xml";
        }
        doc.setName(String.format(format, supplierData.getInn(), supplierData.getKpp(), customerData.getInn(), customerData.getKpp(), SbisIntegrationHelper.filenameDateFormatter.format(MiscUtil.toLocalDate((Date)shipment.getDate())), shipment.getUid()));
        doc.setContent(SbisSerializable.serialize(result));
        doc.setContentType(ContentType.XML);
        doc.setType(DocumentType.OTHER);
        docs.add(doc);
    }

    private void addFinanceDocumentAttachment(List<SbisServiceFile.SbisDocumentsAttachment> attachments, MessageContext ctx, SbisFile file, Document fileAsPdf) throws Exception {
        SbisServiceFile.SbisDocumentsAttachment attachment;
        EntityContainer personCtr;
        SbisIntegrationSettings settings = (SbisIntegrationSettings)ctx.getObject((Enum)IBusSbisContextKeys.INTEGRATION_SETTINGS);
        if (!settings.getGeneralSettings().isEnabled()) {
            throw Xeption.forEndUser((String)"\u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430 \u0432 \u0421\u0411\u0418\u0421 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u044b", (Object[])new Object[0]);
        }
        EntityReference currentUser = ProfileHelper.getCurrentUser();
        if (currentUser != null && (personCtr = EntityStorage.get().resolve(currentUser)) != null) {
            String directoryInDocSbis = ((Person)personCtr.getEntity()).getExportDirectorySbis();
            settings.getGeneralSettings().setBaseDirInDocument(!TextUtil.isBlank((String)directoryInDocSbis) ? directoryInDocSbis : settings.getGeneralSettings().getBaseDirInDocument());
        }
        String baseDirInDocument = settings.getGeneralSettings().getBaseDirInDocument();
        List docs = (List)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.FILES_TO_EXPORT);
        if (fileAsPdf != null) {
            attachment = new SbisServiceFile.SbisDocumentsAttachment();
            attachment.setFileName(fileAsPdf.getName());
            attachment.setPath(TextUtil.nonBlank((String)baseDirInDocument) ? baseDirInDocument + "\\" + fileAsPdf.getName() : fileAsPdf.getName());
            attachments.add(attachment);
            docs.add(fileAsPdf);
        }
        if (file == null) {
            return;
        }
        attachment = new SbisServiceFile.SbisDocumentsAttachment();
        attachment.setFileName(file.getFileName());
        attachment.setPath(TextUtil.nonBlank((String)baseDirInDocument) ? baseDirInDocument + "\\" + file.getFileName() : file.getFileName());
        attachments.add(attachment);
        byte[] content = SbisSerializable.serialize(file);
        Document doc = new Document();
        doc.setName(file.getFileName());
        doc.setContent(content);
        doc.setContentType(ContentType.XML);
        doc.setType(DocumentType.OTHER);
        docs.add(doc);
    }

    private SbisServiceFile.SbisDocumentsLegalEntity createLegalEntity(SbisOrganizationData data) {
        SbisServiceFile.SbisDocumentsLegalEntity result = new SbisServiceFile.SbisDocumentsLegalEntity();
        result.setInn(data.getInn());
        if (data.getAdditionalData() instanceof SbisOrganizationAdditionalDataIP) {
            result.setIndividualEntrepreneur(true);
        } else {
            result.setIndividualEntrepreneur(false);
            result.setKpp(data.getKpp());
        }
        result.setCustomerCode(data.getCustomerCode());
        result.setCustomerIdentifier(data.getCustomerIdentifier());
        return result;
    }

    private void addRelatedDocumentsAttachments(List<SbisServiceFile.SbisDocumentsAttachment> attachments, MessageContext ctx) {
        SbisIntegrationSettings settings = (SbisIntegrationSettings)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.INTEGRATION_SETTINGS);
        List relatedDocuments = (List)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.RELATED_DOCUMENTS);
        List filesToExport = (List)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.FILES_TO_EXPORT);
        String baseDirInDocument = settings.getGeneralSettings().getBaseDirInDocument();
        for (Document relatedDocument : relatedDocuments) {
            SbisServiceFile.SbisDocumentsAttachment attachment = new SbisServiceFile.SbisDocumentsAttachment();
            attachment.setFileName(relatedDocument.getName());
            attachment.setPath(TextUtil.nonBlank((String)baseDirInDocument) ? baseDirInDocument + "\\" + relatedDocument.getName() : relatedDocument.getName());
            attachments.add(attachment);
            filesToExport.add(relatedDocument);
        }
    }
}

