/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis;

import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.ibecorp.rules.SbisActionSet;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentFormat;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentFormatSettings;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganization;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationData;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisSvedTov;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisUniversalDocumentFile;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SbisCreateUniversalDocumentFileProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer shipmentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SHIPMENT_CONTAINER);
        EntityStorageContext sc = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        EntityContainer universalDocumentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENT_CONTAINER);
        HashMap documents = (HashMap)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENTS);
        ArrayList documentsAsPdf = (ArrayList)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENTS_AS_PDF);
        String customerCode = (String)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_CUSTOMER_CODE);
        String customerIdentifier = (String)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_CUSTOMER_IDENTIFIER);
        Map vendorBillingItems = (Map)ctx.getObject((Enum)IBusSbisContextKeys.SBIS_VENDOR_BILLING_ITEMS);
        SbisDocumentFormatSettings formatSettings = (SbisDocumentFormatSettings)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.DOCUMENTS_FORMAT_SETTINGS);
        FinanceDocument universalDocument = (FinanceDocument)universalDocumentCtr.getEntity();
        SbisUniversalDocumentFile result = new SbisUniversalDocumentFile();
        SbisOrganizationData supplierData = SbisIntegrationHelper.buildOrganizationData(universalDocument, sc, customerCode, customerIdentifier, true, true);
        SbisOrganizationData customerData = SbisIntegrationHelper.buildOrganizationData(universalDocument, sc, customerCode, customerIdentifier, false, true);
        UniversalDocumentStatus universalDocumentStatus = universalDocument.getUniversalDocumentStatus();
        if (universalDocument.getDate() == null) {
            throw Xeption.forEndUser((String)L10n.get((String)Messages.SBIS_INTEGRATION_MISSING_DOCUMENT_DATE), (Object[])new Object[0]);
        }
        if (universalDocumentStatus == null) {
            throw Xeption.forEndUser((String)L10n.get((String)Messages.SBIS_INTEGRATION_MISSING_UNIVERSAL_DOCUMENT_STATUS), (Object[])new Object[0]);
        }
        LocalDate documentDate = MiscUtil.toLocalDate((Date)universalDocument.getDate());
        result.getSvUchDocObor().setIdOtpr(supplierData.getUid());
        result.getSvUchDocObor().setIdPoluch(customerData.getUid());
        String fileId = String.format("ON_NSCHFDOPPR_%s_%s_%s_%s_0_0_0_0_0_00", result.getSvUchDocObor().getIdPoluch(), result.getSvUchDocObor().getIdOtpr(), SbisIntegrationHelper.filenameDateFormatter.format(documentDate), universalDocumentCtr.getUid());
        String pdfFileId = String.format("\u0423\u041f\u0414_%s_%s", universalDocument.getNumber(), SbisIntegrationHelper.filenameDateFormatter.format(documentDate)).replaceAll("_{2,}", "_");
        Document documentPdf = null;
        if (formatSettings.getUniversalDocument() == SbisDocumentFormat.PDF || formatSettings.getUniversalDocument() == SbisDocumentFormat.XML_AND_PDF) {
            documentPdf = SbisIntegrationHelper.createFinanceDocument((EntityContainer<FinanceDocument>)universalDocumentCtr, pdfFileId);
            if (formatSettings.getUniversalDocument() == SbisDocumentFormat.PDF) {
                documentsAsPdf.add(documentPdf);
                return;
            }
        }
        documents.put(result, documentPdf);
        result.setFileId(fileId);
        result.setInfPrDate(MiscUtil.toLocalDateTime((Date)universalDocumentCtr.getModified()));
        result.setNaimEconSubSost(String.format("%s, \u0418\u041d\u041d/\u041a\u041f\u041f %s/%s", supplierData.getName(), supplierData.getInn(), supplierData.getKpp()));
        result.setNumber(TextUtil.buildFullNumber((CompositeNumber)universalDocument));
        result.setDocumentDate(documentDate);
        result.setPeriodBegin(MiscUtil.toLocalDate((Date)((Shipment)shipmentCtr.getEntity()).getPeriodBegin()));
        result.setPeriodEnd(MiscUtil.toLocalDate((Date)((Shipment)shipmentCtr.getEntity()).getPeriodEnd()));
        if (universalDocumentStatus == UniversalDocumentStatus.ONE) {
            result.setFunction("\u0421\u0427\u0424\u0414\u041e\u041f");
            result.setNaimDocOpr("\u0421\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0430 \u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e\u0431 \u043e\u0442\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 (\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0440\u0430\u0431\u043e\u0442), \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u043f\u0440\u0430\u0432 (\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e\u0431 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0438 \u0443\u0441\u043b\u0443\u0433)");
        } else if (universalDocumentStatus == UniversalDocumentStatus.TWO) {
            result.setFunction("\u0414\u041e\u041f");
            result.setNaimDocOpr("\u041f\u0435\u0440\u0435\u0434\u0430\u0442\u043e\u0447\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        }
        this.fillOrganizationData(result.getSvProd(), supplierData);
        this.fillOrganizationData(result.getSvPok(), customerData);
        SbisIntegrationHelper.fillSignerData(result.getSigner(), universalDocument, result.getSvProd(), "5", sc);
        this.fillContractData(result, (EntityContainer<Shipment>)shipmentCtr);
        String bookingCtrUid = null;
        int porNomer = 1;
        BigDecimal itogoSNDS = BigDecimal.ZERO;
        BigDecimal itogoNDS = BigDecimal.ZERO;
        HashMap<ExtendedProductType, SbisActionSet> sbisActionSets = new HashMap<ExtendedProductType, SbisActionSet>();
        HashMap<ExtendedProductType, SbisActionSet> sbisIntermediaryActionSets = new HashMap<ExtendedProductType, SbisActionSet>();
        HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> resultAttributes = new HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>>();
        for (SbisIntegrationHelper.BillingItemWrapper billingItemWrapper : SbisIntegrationHelper.getMergedBillingItem(universalDocument, sc, (Boolean)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SUPPLIER_IS_SIMPLE_TAXED), universalDocument.getVatViewMode(), vendorBillingItems)) {
            BillingItem bi = billingItemWrapper.getBillingItem();
            Nomenclature nomenclature = null;
            for (NestedEntityReference fopComp : bi.getFopComponents()) {
                FopComponent fopComponent;
                if (bookingCtrUid == null) {
                    bookingCtrUid = fopComp.getUid();
                }
                if ((fopComponent = (FopComponent)EntityStorageHelper.resolve((NestedEntityReference)fopComp, (EntityStorageContext)sc)) == null || (nomenclature = (Nomenclature)DictionaryCache.get().resolveReference(fopComponent.getNomenclature())) == null) continue;
                break;
            }
            if (nomenclature == null) {
                throw Xeption.forEndUser((String)"\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435 \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 {0} \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u0443", (Object[])new Object[]{porNomer});
            }
            Integer nds = bi.getAmount().getVat() != null ? Integer.valueOf((int)Math.round(bi.getAmount().getVat())) : null;
            int positionsCount = bi.getPositionsCount() == 0 ? 1 : bi.getPositionsCount();
            SbisSvedTov row = new SbisSvedTov(result.getPriceFormatter());
            row.setKolTov(positionsCount);
            row.setNaimTov(bi.getName());
            row.setNomStr(porNomer);
            row.setStTovSNDS(MiscUtil.guarded((BigDecimal)bi.getAmount().getTotal()));
            row.setStTovBezNDS(MiscUtil.guarded((BigDecimal)bi.getAmount().getValue()));
            row.setPriceTov(row.getStTovBezNDS().divide(BigDecimal.valueOf(positionsCount), 2, RoundingMode.HALF_UP));
            row.setStavkaNDS(nds);
            row.setSumNal(MiscUtil.guarded((BigDecimal)bi.getAmount().getVatAmount()));
            row.setId(bi.getUid());
            String ruNomName = (String)nomenclature.getTranslations().get(LocaleHelper.RU_LOCALE);
            if (ruNomName == null) {
                if (!nomenclature.getTranslations().isEmpty()) {
                    ruNomName = (String)nomenclature.getTranslations().values().iterator().next();
                } else {
                    throw Xeption.forEndUser((String)"\u0432 \u043d\u043e\u043c\u0435\u043d\u043a\u043b\u0430\u0442\u0443\u0440\u0435 {0} \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", (Object[])new Object[]{nomenclature.getCode()});
                }
            }
            row.setNaimenovanie(ruNomName);
            EntityContainer bookingCtr = EntityStorageHelper.resolve((EntityReference)new EntityReference(bookingCtrUid, BookingFile.class, null), (EntityStorageContext)sc);
            row.setHarakteristika(String.format("\u0417\u0430\u043a\u0430\u0437 \u2116 %s \u043e\u0442 %s", ((BookingFile)bookingCtr.getEntity()).getNumber(), SbisIntegrationHelper.dateFormat.format(MiscUtil.toLocalDate((Date)(((BookingFile)bookingCtr.getEntity()).getCreateDate() == null ? bookingCtr.getCreated() : ((BookingFile)bookingCtr.getEntity()).getCreateDate())))));
            row.setKodTov(nomenclature.getCode());
            Map<Object, Object> attributes = new HashMap();
            boolean isIntermediaryService = SbisIntegrationHelper.isIntermediaryService(billingItemWrapper, sc);
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)bi.getProduct(), (EntityStorageContext)sc);
            if (product != null) {
                ExtendedProductType productType = SbisIntegrationHelper.getExtendedProductType(product);
                ExtendedProductType appliedProductType = sbisActionSets.keySet().stream().filter(type -> type.getProductType() == productType.getProductType() && MiscUtil.equals((Object)type.getProductDescription(), (Object)productType.getProductDescription())).findFirst().orElse(null);
                if (isIntermediaryService) {
                    appliedProductType = sbisIntermediaryActionSets.keySet().stream().filter(type -> type.getProductType() == productType.getProductType() && MiscUtil.equals((Object)type.getProductDescription(), (Object)productType.getProductDescription())).findFirst().orElse(null);
                }
                SbisActionSet sbisActionSet = (SbisActionSet)sbisActionSets.get(appliedProductType);
                if (isIntermediaryService) {
                    sbisActionSet = (SbisActionSet)sbisIntermediaryActionSets.get(appliedProductType);
                }
                if (sbisActionSet == null) {
                    sbisActionSet = SbisIntegrationHelper.applyRules((EntityContainer<Shipment>)shipmentCtr, universalDocument, product, isIntermediaryService);
                    if (isIntermediaryService) {
                        sbisIntermediaryActionSets.put(productType, sbisActionSet);
                    } else {
                        sbisActionSets.put(productType, sbisActionSet);
                    }
                }
                if ((attributes = SbisIntegrationHelper.getElementsAttributes(product, billingItemWrapper, (NestedEntityReference<BookingFile, Traveller>)bi.getTraveller(), sbisActionSet.getSbisDocumentElementsData(), universalDocument.getDate(), sc)).get(SbisIntegrationHelper.INF_POL_FHG_2) != null || attributes.get(SbisIntegrationHelper.INF_POLE_OPIS_RABOT) != null) {
                    row.setSbisDocumentElementsAttributes(new HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>>());
                    row.getSbisDocumentElementsAttributes().putAll(attributes);
                }
            }
            for (Map.Entry entry : attributes.entrySet()) {
                HashSet elementAttributes = (HashSet)resultAttributes.get(entry.getKey());
                if (elementAttributes == null) {
                    elementAttributes = new HashSet();
                }
                elementAttributes.addAll((Collection)entry.getValue());
                resultAttributes.put((String)entry.getKey(), elementAttributes);
            }
            itogoSNDS = itogoSNDS.add(row.getStTovSNDS());
            itogoNDS = itogoNDS.add(row.getSumNal());
            ++porNomer;
            result.getPositions().add(row);
        }
        result.setTotalBezNDS(itogoSNDS.subtract(itogoNDS));
        result.setTotalSNDS(itogoSNDS);
        result.setTotalKolvo(result.getPositions().size());
        result.getSbisDocumentElementsAttributes().putAll(SbisIntegrationHelper.mergeAttributes(resultAttributes));
    }

    private void fillOrganizationData(SbisOrganization organization, SbisOrganizationData orgData) {
        organization.setAddress(orgData.getAddress());
        organization.setCountryCode(orgData.getCountryCode());
        organization.setCountryName(orgData.getCountryName());
        organization.setZip(orgData.getZip());
        organization.setRegionCode(orgData.getRegionCode());
        organization.setRegionName(orgData.getRegionName());
        organization.setCityName(orgData.getCityName());
        organization.setStreet(orgData.getStreet());
        organization.setHouse(orgData.getHouse());
        organization.setInn(orgData.getInn());
        organization.setKpp(orgData.getKpp());
        organization.setNaimOrg(orgData.getName());
        organization.setBankName(orgData.getBankName());
        organization.setBik(orgData.getBik());
        organization.setPhone(orgData.getPhoneNumber());
        organization.setSchetNumber(orgData.getSettlementAccount());
        organization.setCorSchetNumber(orgData.getCorrespondentAccount());
    }

    private void fillContractData(SbisUniversalDocumentFile file, EntityContainer<Shipment> shipmentCtr) {
        EntityContainer contract = EntityStorage.get().resolve((EntityReference)((Shipment)shipmentCtr.getEntity()).getContract());
        if (contract != null) {
            file.setContractNumber(((Contract)contract.getEntity()).getNumber());
            Date date = ((Contract)contract.getEntity()).getIssueDate();
            if (date != null) {
                String dateContract = new SimpleDateFormat("dd.MM.yyyy").format(date);
                file.setContractDate(dateContract);
            }
        }
    }
}

