/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis;

import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;

public class SbisLoadRegistryProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer ctr;
        SearchQuery query = new SearchQuery();
        EntityReference shipmentRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SHIPMENT_REFERENCE);
        Shipment shipment = (Shipment)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SHIPMENT);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)shipmentRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.SHIPMENT_TICKETS_REGISTRY));
        List indexList = EntityStorage.get().search(BasicDocumentIndex.class, query).getData();
        if (!indexList.isEmpty() && (ctr = EntityStorage.get().resolve(((BasicDocumentIndex)indexList.get(0)).getSource())) != null) {
            Document doc = new Document();
            doc.setType(DocumentType.SHIPMENT_TICKETS_REGISTRY);
            doc.setContentType(ContentType.EXCEL_2007);
            doc.setContent(((BaseFileDocument)ctr.getEntity()).getContent());
            doc.setName(String.format("\u0420\u0435\u0435\u0441\u0442\u0440_%s_%s.XLSX", shipment.getNumber(), SbisIntegrationHelper.filenameDateFormatter.format(MiscUtil.toLocalDate((Date)shipment.getDate()))).replaceAll("_{2,}", "_"));
            ctx.putObject((Enum)IBusSbisContextKeys.REGISTRY, (Object)doc);
            List filesToExport = (List)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.FILES_TO_EXPORT);
            filesToExport.add(doc);
        }
    }
}

