/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis;

import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.helpers.DocumentHelper;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisRelatedDocumentsJoiningSettings;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SbisLoadRelatedDocumentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer shipment = (EntityContainer)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SHIPMENT_CONTAINER);
        EntityStorageContext storageContext = (EntityStorageContext)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT);
        boolean exportRelatedDocuments = (Boolean)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.EXPORT_RELATED_DOCUMENTS);
        List joiningSettings = (List)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SBIS_RELATED_DOCUMENTS_JOINING_SETTINGS);
        ArrayList<Document> convertedDocuments = new ArrayList<Document>();
        if (exportRelatedDocuments) {
            List<EntityContainer<Document>> relatedDocuments = this.getRelatedDocuments((EntityContainer<Shipment>)shipment, storageContext);
            HashMap<String, Integer> names = new HashMap<String, Integer>();
            List<ContentType> pdfContentTypes = Arrays.asList(ContentType.JASPERPRINT, ContentType.PDF);
            for (SbisRelatedDocumentsJoiningSettings sbisRelatedDocumentsJoiningSettings : joiningSettings) {
                List<EntityContainer<Document>> joinedPdfDocuments = relatedDocuments.stream().filter(d -> settings.getDocumentTypes().contains(((Document)d.getEntity()).getType()) && pdfContentTypes.contains(((Document)d.getEntity()).getContentType())).collect(Collectors.toList());
                String name = TextUtil.nonBlank((String)sbisRelatedDocumentsJoiningSettings.getDocumentName()) ? this.cleanupName(sbisRelatedDocumentsJoiningSettings.getDocumentName()) : "relatedDocuments";
                Document joinedPdfDocument = SbisIntegrationHelper.createJoinedPdfDocument(joinedPdfDocuments, name = String.format("%s_%s_%s", name, SbisIntegrationHelper.filenameDateFormatter.format(MiscUtil.toLocalDate((Date)((Shipment)shipment.getEntity()).getDate())), ((Shipment)shipment.getEntity()).getUid()), names);
                if (joinedPdfDocument != null) {
                    convertedDocuments.add(joinedPdfDocument);
                }
                relatedDocuments.removeAll(joinedPdfDocuments);
            }
            for (EntityContainer entityContainer : relatedDocuments) {
                String name = this.cleanupName(TextUtil.nonBlank((String)((Document)entityContainer.getEntity()).getName()) ? ((Document)entityContainer.getEntity()).getName() : "document");
                convertedDocuments.add(SbisIntegrationHelper.createDocument((EntityContainer<Document>)entityContainer, name, names));
            }
        }
        ctx.putObject((Enum)IBusSbisContextKeys.RELATED_DOCUMENTS, convertedDocuments);
    }

    private String cleanupName(String name) {
        return name.replace("\\", "_").replace("/", "_");
    }

    private List<EntityContainer<Document>> getRelatedDocuments(EntityContainer<Shipment> shipment, EntityStorageContext storageContext) {
        List productRefs = FinanceDocumentHelper.getBillingItems((List)((Shipment)shipment.getEntity()).getBillingItems(), (EntityStorageContext)storageContext).stream().map(BillingItem::getProduct).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (productRefs.isEmpty()) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"navigationKey", (Collection)productRefs.stream().map(NestedEntityReference::getNestedEntityUid).collect(Collectors.toList())));
        return EntityStorage.get().search(BasicDocumentIndex.class, query).getData().stream().map(EntityIndex::getSource).filter(document -> Document.class.isAssignableFrom(document.getType())).distinct().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).map(document -> document).filter(EntityStorageHelper::nonEmpty).filter(doc -> ((Document)doc.getEntity()).getContent() != null && ((Document)doc.getEntity()).getContent().length > 0).filter(doc -> ((Document)doc.getEntity()).getContentType() == ContentType.JASPERPRINT || DocumentHelper.getExtensions((ContentType)((Document)doc.getEntity()).getContentType()) != null).collect(Collectors.toList());
    }
}

