/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis;

import com.gridnine.xtrip.common.ibecorp.model.IBusSbisContextKeys;
import com.gridnine.xtrip.common.ibecorp.rules.SbisActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.SbisExportParametersSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentFormat;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentFormatSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SbisPutCommonEntitiesToContextProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ctx.putObject((Enum)IBusSbisContextKeys.FILES_TO_EXPORT, new ArrayList());
        EntityContainer shipmentCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusSbisContextKeys.SHIPMENT_CONTAINER);
        ctx.putObject((Enum)IBusSbisContextKeys.INTEGRATION_SETTINGS, (Object)SbisIntegrationHelper.getSettings((Shipment)shipmentCtr.getEntity()));
        EntityStorageContext sc = EntityStorageHelper.createContext((EntityContainer)shipmentCtr);
        ctx.putObject((Enum)IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT, (Object)sc);
        HashSet financeDocumentTypes = new HashSet();
        ctx.putObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENT_TYPES, financeDocumentTypes);
        SbisActionSet sbisActionSet = SbisIntegrationHelper.applyRules((EntityContainer<Shipment>)shipmentCtr, null, null, false);
        SbisDocumentFormatSettings settings = sbisActionSet.getSbisDocumentFormatSettings();
        if (settings == null) {
            settings = new SbisDocumentFormatSettings();
            settings.setInvoiceFactura(SbisDocumentFormat.XML);
            settings.setInvoice(SbisDocumentFormat.XML);
            settings.setAcceptanceCertificate(SbisDocumentFormat.XML);
            settings.setUniversalDocument(SbisDocumentFormat.XML);
        }
        boolean exportRelatedDocuments = sbisActionSet.isExportRelatedDocuments();
        SbisExportParametersSettings parametersSettings = sbisActionSet.getSbisExportParametersSettings();
        if (parametersSettings == null) {
            parametersSettings = new SbisExportParametersSettings();
        }
        String customerCode = sbisActionSet.getCustomerCode();
        ctx.putObject((Enum)IBusSbisContextKeys.SBIS_CUSTOMER_CODE, (Object)customerCode);
        String customerIdentifier = sbisActionSet.getCustomerIdentifier();
        ctx.putObject((Enum)IBusSbisContextKeys.SBIS_CUSTOMER_IDENTIFIER, (Object)customerIdentifier);
        ctx.putObject((Enum)IBusSbisContextKeys.SUPPLIER_DATA, (Object)SbisIntegrationHelper.buildOrganizationData((Shipment)shipmentCtr.getEntity(), sc, customerCode, customerIdentifier, true, true));
        ctx.putObject((Enum)IBusSbisContextKeys.CUSTOMER_DATA, (Object)SbisIntegrationHelper.buildOrganizationData((Shipment)shipmentCtr.getEntity(), sc, customerCode, customerIdentifier, false, false));
        ctx.putObject((Enum)IBusSbisContextKeys.SBIS_EXPORT_PARAMETERS_SETTINGS, (Object)parametersSettings);
        ctx.putObject((Enum)IBusSbisContextKeys.DOCUMENTS_FORMAT_SETTINGS, (Object)settings);
        ctx.putObject((Enum)IBusSbisContextKeys.EXPORT_RELATED_DOCUMENTS, (Object)exportRelatedDocuments);
        ctx.putObject((Enum)IBusSbisContextKeys.SBIS_RELATED_DOCUMENTS_JOINING_SETTINGS, (Object)sbisActionSet.getSbisRelatedDocumentsJoiningSettings());
        EntityContainer supplierCtr = EntityStorage.get().resolve(((Shipment)shipmentCtr.getEntity()).getSupplier());
        ctx.putObject((Enum)IBusSbisContextKeys.SUPPLIER_IS_SIMPLE_TAXED, (Object)(supplierCtr != null && ((Organization)supplierCtr.getEntity()).isSimpleTaxed() ? 1 : 0));
        financeDocumentTypes.addAll(sbisActionSet.getFinanceDocumentTypes());
        HashSet financeDocumentsContainers = new HashSet();
        ctx.putObject((Enum)IBusSbisContextKeys.SBIS_FINANCE_DOCUMENT_CONTAINERS, financeDocumentsContainers);
        financeDocumentsContainers.addAll(((Shipment)shipmentCtr.getEntity()).getFinanceDocuments().stream().map(item -> EntityStorageHelper.resolve((EntityReference)item, (EntityStorageContext)sc)).filter(Objects::nonNull).filter(item -> SbisIntegrationHelper.getSbisFinanceDocumentTypes().contains(((FinanceDocument)item.getEntity()).getType())).collect(Collectors.toSet()));
        HashMap<BillingItem, List> vendorBillingItems = new HashMap<BillingItem, List>();
        List vendorFinanceDocuments = financeDocumentsContainers.stream().filter(item -> ((FinanceDocument)item.getEntity()).isVendorDocument()).collect(Collectors.toList());
        for (EntityContainer financeDocument : vendorFinanceDocuments) {
            List billingItems = FinanceDocumentHelper.getBillingItems((List)((FinanceDocument)financeDocument.getEntity()).getBillingItems(), (EntityStorageContext)sc);
            for (BillingItem billingItem : billingItems) {
                List financeDocuments = vendorBillingItems.computeIfAbsent(billingItem, b -> new ArrayList());
                financeDocuments.add(financeDocument.getEntity());
                vendorBillingItems.put(billingItem, financeDocuments);
            }
        }
        ctx.putObject((Enum)IBusSbisContextKeys.SBIS_VENDOR_BILLING_ITEMS, vendorBillingItems);
    }
}

