/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis.model;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisDocumentSigner;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisFile;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisSerializable;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisSvUchDocObor;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SbisAcceptanceCertificateFile
implements SbisFile {
    private static NumberFormat rabotaPriceFormatter = new DecimalFormat("#.##;#.##", new DecimalFormatSymbols(Locale.ENGLISH));
    private static NumberFormat priceFormatter = new DecimalFormat("0.00;-0.00", new DecimalFormatSymbols(Locale.ENGLISH));
    private String fileId;
    private final String progVersion = "1\u0421:\u041f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 8";
    private final String formVersion = "5.01";
    private final String idOtpr = "2BE7\u0417a0d5c693\u0430\u043511\u043539047005056917125";
    private final String idPoluch = "2BM-6635000195-2012111212443364411880000000000";
    private final String orgName = "\u041e\u041e\u041e &quot;\u041a\u043e\u043c\u043f\u0430\u043d\u0438\u044f &quot;\u0422\u0435\u043d\u0437\u043e\u0440&quot;";
    private final String orgInn = "7605016030";
    private final String idEdo = "2BE";
    private final SbisSvUchDocObor svUchDocObor = new SbisSvUchDocObor("2BE7\u0417a0d5c693\u0430\u043511\u043539047005056917125", "2BM-6635000195-2012111212443364411880000000000", "\u041e\u041e\u041e &quot;\u041a\u043e\u043c\u043f\u0430\u043d\u0438\u044f &quot;\u0422\u0435\u043d\u0437\u043e\u0440&quot;", "7605016030", "2BE");
    private final SbisAktDocument document = new SbisAktDocument();

    public String getProgVersion() {
        return "1\u0421:\u041f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 8";
    }

    public String getFormVersion() {
        return "5.01";
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public SbisSvUchDocObor getSvUchDocObor() {
        return this.svUchDocObor;
    }

    @Override
    public String getFileName() {
        return this.fileId + ".xml";
    }

    public SbisAktDocument getDocument() {
        return this.document;
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("\u0424\u0430\u0439\u043b");
        writer.writeAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute("\u0418\u0434\u0424\u0430\u0439\u043b", this.fileId);
        writer.writeAttribute("\u0412\u0435\u0440\u0441\u041f\u0440\u043e\u0433", "1\u0421:\u041f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 8");
        writer.writeAttribute("\u0412\u0435\u0440\u0441\u0424\u043e\u0440\u043c", "5.01");
        this.svUchDocObor.toXML(writer);
        this.document.toXML(writer);
        writer.writeEndElement();
    }

    private static void writeInfPolFhg1(String id, String value, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("\u0422\u0435\u043a\u0441\u0442\u0418\u043d\u0444");
        writer.writeAttribute("\u0418\u0434\u0435\u043d\u0442\u0438\u0444", id);
        writer.writeAttribute("\u0417\u043d\u0430\u0447\u0435\u043d", value);
        writer.writeEndElement();
    }

    public static class SbisAcceptanceCertificateOrg
    implements SbisSerializable {
        private final String kodStr = "643";
        private String address;
        private String phone;
        private String schetNumber;
        private String bankName;
        private String bik;
        private String okpo;
        private SbisSerializable sbisAcceptanceCertificateOrgHead;

        public String getOkpo() {
            return this.okpo;
        }

        public void setOkpo(String okpo) {
            this.okpo = okpo;
        }

        public String getKodStr() {
            return "643";
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getSchetNumber() {
            return this.schetNumber;
        }

        public void setSchetNumber(String schetNumber) {
            this.schetNumber = schetNumber;
        }

        public String getBankName() {
            return this.bankName;
        }

        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        public String getBik() {
            return this.bik;
        }

        public void setBik(String bik) {
            this.bik = bik;
        }

        public SbisSerializable getSbisAcceptanceCertificateOrgHead() {
            return this.sbisAcceptanceCertificateOrgHead;
        }

        public void setSbisAcceptanceCertificateOrgHead(SbisSerializable sbisAcceptanceCertificateOrgHead) {
            this.sbisAcceptanceCertificateOrgHead = sbisAcceptanceCertificateOrgHead;
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            this.sbisAcceptanceCertificateOrgHead.toXML(writer);
            writer.writeStartElement("\u0410\u0434\u0440\u0435\u0441");
            writer.writeStartElement("\u0410\u0434\u0440\u0418\u043d\u043e");
            writer.writeAttribute("\u041a\u043e\u0434\u0421\u0442\u0440", "643");
            writer.writeAttribute("\u0410\u0434\u0440\u0422\u0435\u043a\u0441\u0442", this.address);
            writer.writeEndElement();
            writer.writeEndElement();
            if (!TextUtil.isBlank((String)this.phone)) {
                writer.writeStartElement("\u041a\u043e\u043d\u0442\u0430\u043a\u0442");
                writer.writeAttribute("\u0422\u043b\u0444", this.phone);
                writer.writeEndElement();
            }
            if (!TextUtil.isBlank((String)this.schetNumber)) {
                writer.writeStartElement("\u0411\u0430\u043d\u043a\u0420\u0435\u043a\u0432");
                writer.writeAttribute("\u041d\u043e\u043c\u0435\u0440\u0421\u0447\u0435\u0442\u0430", this.schetNumber);
                writer.writeStartElement("\u0421\u0432\u0411\u0430\u043d\u043a");
                writer.writeAttribute("\u041d\u0430\u0438\u043c\u0411\u0430\u043d\u043a", this.bankName);
                writer.writeAttribute("\u0411\u0418\u041a", this.bik);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    }

    public static class SbisAcceptanceCertificateOrgHeadNonIP
    implements SbisSerializable {
        private String orgName;
        private String inn;
        private String kpp;

        public String getOrgName() {
            return this.orgName;
        }

        public void setOrgName(String orgName) {
            this.orgName = orgName;
        }

        public String getInn() {
            return this.inn;
        }

        public void setInn(String inn) {
            this.inn = inn;
        }

        public String getKpp() {
            return this.kpp;
        }

        public void setKpp(String kpp) {
            this.kpp = kpp;
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            writer.writeStartElement("\u0418\u0434\u0421\u0432");
            writer.writeStartElement("\u0421\u0432\u041e\u0440\u0433");
            writer.writeStartElement("\u0421\u0432\u042e\u041b");
            writer.writeAttribute("\u041d\u0430\u0438\u043c\u041e\u0440\u0433", this.orgName);
            writer.writeAttribute("\u0418\u041d\u041d\u042e\u041b", this.inn);
            writer.writeAttribute("\u041a\u041f\u041f", this.kpp);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    public static class SbisAcceptanceCertificateOrgHeadIP
    implements SbisSerializable {
        private String name;
        private String surname;
        private String patronymic;
        private String inn;
        private String stateRegistrationInfo;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSurname() {
            return this.surname;
        }

        public void setSurname(String surname) {
            this.surname = surname;
        }

        public String getPatronymic() {
            return this.patronymic;
        }

        public void setPatronymic(String patronymic) {
            this.patronymic = patronymic;
        }

        public String getInn() {
            return this.inn;
        }

        public void setInn(String inn) {
            this.inn = inn;
        }

        public String getStateRegistrationInfo() {
            return this.stateRegistrationInfo;
        }

        public void setStateRegistrationInfo(String stateRegistrationInfo) {
            this.stateRegistrationInfo = stateRegistrationInfo;
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            writer.writeStartElement("\u0418\u0434\u0421\u0432");
            writer.writeStartElement("\u0421\u0432\u0418\u041f");
            writer.writeAttribute("\u0418\u041d\u041d\u0424\u041b", this.inn);
            if (TextUtil.nonBlank((String)this.stateRegistrationInfo)) {
                writer.writeAttribute("\u0421\u0432\u0413\u043e\u0441\u0420\u0435\u0433\u0418\u041f", this.stateRegistrationInfo);
            }
            writer.writeStartElement("\u0424\u0418\u041e");
            writer.writeAttribute("\u0424\u0430\u043c\u0438\u043b\u0438\u044f", this.surname);
            if (TextUtil.nonBlank((String)this.patronymic)) {
                writer.writeAttribute("\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e", this.patronymic);
            }
            writer.writeAttribute("\u0418\u043c\u044f", this.name);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    public static class SbisAktRabota
    implements SbisSerializable {
        private int number;
        private String name;
        private final String edIzm = "\u0448\u0442";
        private final String okei = "796";
        private BigDecimal price;
        private int kolvo;
        private BigDecimal stBezNDS;
        private Double stavka;
        private BigDecimal nds;
        private BigDecimal stSNDS;
        private String description;
        private Map<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> sbisDocumentElementsAttributes = new HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>>();

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getEdIzm() {
            return "\u0448\u0442";
        }

        public String getOkei() {
            return "796";
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public int getKolvo() {
            return this.kolvo;
        }

        public void setKolvo(int kolvo) {
            this.kolvo = kolvo;
        }

        public BigDecimal getStBezNDS() {
            return this.stBezNDS;
        }

        public void setStBezNDS(BigDecimal stBezNDS) {
            this.stBezNDS = stBezNDS;
        }

        public Double getStavka() {
            return this.stavka;
        }

        public void setStavka(Double stavka) {
            this.stavka = stavka;
        }

        public BigDecimal getNds() {
            return this.nds;
        }

        public void setNds(BigDecimal nds) {
            this.nds = nds;
        }

        public BigDecimal getStSNDS() {
            return this.stSNDS;
        }

        public void setStSNDS(BigDecimal stSNDS) {
            this.stSNDS = stSNDS;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Map<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> getSbisDocumentElementsAttributes() {
            return this.sbisDocumentElementsAttributes;
        }

        public void add(SbisAktRabota other) {
            this.price = this.price.add(other.price);
            this.stBezNDS = this.stBezNDS.add(other.stBezNDS);
            this.nds = this.nds.add(other.nds);
            this.stSNDS = this.stSNDS.add(other.stSNDS);
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute> attributesInfPoleOpisRabot;
            writer.writeStartElement("\u0420\u0430\u0431\u043e\u0442\u0430");
            writer.writeAttribute("\u041d\u043e\u043c\u0435\u0440", Integer.toString(this.number));
            writer.writeAttribute("\u041d\u0430\u0438\u043c\u0420\u0430\u0431\u043e\u0442", this.name);
            writer.writeAttribute("\u041d\u0430\u0438\u043c\u0415\u0434\u0418\u0437\u043c", "\u0448\u0442");
            writer.writeAttribute("\u041e\u041a\u0415\u0418", "796");
            writer.writeAttribute("\u0426\u0435\u043d\u0430", rabotaPriceFormatter.format(this.price));
            writer.writeAttribute("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", Integer.toString(this.kolvo));
            writer.writeAttribute("\u0421\u0442\u043e\u0438\u043c\u0411\u0435\u0437\u041d\u0414\u0421", rabotaPriceFormatter.format(this.stBezNDS));
            writer.writeAttribute("\u041d\u0430\u043b\u0421\u0442", this.stavka == null ? "\u0431\u0435\u0437 \u041d\u0414\u0421" : Math.round(this.stavka) + "%");
            writer.writeAttribute("\u0421\u0443\u043c\u041d\u0414\u0421", rabotaPriceFormatter.format(this.nds));
            writer.writeAttribute("\u0421\u0442\u043e\u0438\u043c\u0423\u0447\u041d\u0414\u0421", rabotaPriceFormatter.format(this.stSNDS));
            writer.writeStartElement("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
            writer.writeCharacters(this.description);
            writer.writeEndElement();
            HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute> attributesInfPolFhg2 = this.sbisDocumentElementsAttributes.get(SbisIntegrationHelper.INF_POL_FHG_2);
            if (attributesInfPolFhg2 != null) {
                for (SbisIntegrationHelper.SbisDocumentElementAttribute attribute : attributesInfPolFhg2) {
                    SbisIntegrationHelper.writeElement(attribute.getIdentifier(), attribute.getValue(), SbisIntegrationHelper.INF_POL_FHG_2, writer);
                }
            }
            if ((attributesInfPoleOpisRabot = this.sbisDocumentElementsAttributes.get(SbisIntegrationHelper.INF_POLE_OPIS_RABOT)) != null) {
                for (SbisIntegrationHelper.SbisDocumentElementAttribute attribute : attributesInfPoleOpisRabot) {
                    SbisIntegrationHelper.writeElement(attribute.getIdentifier(), attribute.getValue(), SbisIntegrationHelper.INF_POLE_OPIS_RABOT, writer);
                }
            }
            writer.writeEndElement();
        }
    }

    public static class SbisAktDocument
    implements SbisSerializable {
        private final String knd = "1175012";
        private LocalDateTime ispDate;
        private String naimEconSubSost;
        private final String poFactHG = "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0440\u0430\u0431\u043e\u0442 (\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e\u0431 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0438 \u0443\u0441\u043b\u0443\u0433)";
        private final String naimDocOpr = "\u0410\u043a\u0442 \u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0440\u0430\u0431\u043e\u0442 (\u0410\u043a\u0442 \u043e\u0431 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0438 \u0443\u0441\u043b\u0443\u0433)";
        private String nomDocPru;
        private LocalDate dateDocPru;
        private final String kodOKV = "643";
        private final String naimOKV = "\u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c";
        private String zagSodOper;
        private final SbisAcceptanceCertificateOrg ispolnitel = new SbisAcceptanceCertificateOrg();
        private final SbisAcceptanceCertificateOrg zakazchik = new SbisAcceptanceCertificateOrg();
        private String contractNumber;
        private String contractDate;
        private LocalDate startOfWork;
        private LocalDate endOfWork;
        private BigDecimal stBezNDSIt;
        private BigDecimal ndsIt;
        private BigDecimal stSNDSIt;
        private final List<SbisAktRabota> works = new ArrayList<SbisAktRabota>();
        private String idVisualValue;
        private String gruzootpravitel;
        private final String sodOper = "\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0440\u0430\u0431\u043e\u0442 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u044b (\u0443\u0441\u043b\u0443\u0433\u0438 \u043e\u043a\u0430\u0437\u0430\u043d\u044b)";
        private LocalDate dataPer;
        private final SbisDocumentSigner podpisant = new SbisDocumentSigner();
        private final Map<String, String> infoSectionParamets = new LinkedHashMap<String, String>();
        private Map<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> sbisDocumentElementsAttributes = new HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>>();

        public Map<String, String> getInfoSectionParamets() {
            return this.infoSectionParamets;
        }

        public String getKnd() {
            return "1175012";
        }

        public LocalDateTime getIspDate() {
            return this.ispDate;
        }

        public void setIspDate(LocalDateTime ispDate) {
            this.ispDate = ispDate;
        }

        public String getNaimEconSubSost() {
            return this.naimEconSubSost;
        }

        public void setNaimEconSubSost(String naimEconSubSost) {
            this.naimEconSubSost = naimEconSubSost;
        }

        public String getPoFactHG() {
            return "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0440\u0430\u0431\u043e\u0442 (\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e\u0431 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0438 \u0443\u0441\u043b\u0443\u0433)";
        }

        public String getNaimDocOpr() {
            return "\u0410\u043a\u0442 \u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0440\u0430\u0431\u043e\u0442 (\u0410\u043a\u0442 \u043e\u0431 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0438 \u0443\u0441\u043b\u0443\u0433)";
        }

        public String getNomDocPru() {
            return this.nomDocPru;
        }

        public void setNomDocPru(String nomDocPru) {
            this.nomDocPru = nomDocPru;
        }

        public LocalDate getDateDocPru() {
            return this.dateDocPru;
        }

        public void setDateDocPru(LocalDate dateDocPru) {
            this.dateDocPru = dateDocPru;
        }

        public String getKodOKV() {
            return "643";
        }

        public String getNaimOKV() {
            return "\u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c";
        }

        public String getZagSodOper() {
            return this.zagSodOper;
        }

        public void setZagSodOper(String zagSodOper) {
            this.zagSodOper = zagSodOper;
        }

        public SbisAcceptanceCertificateOrg getIspolnitel() {
            return this.ispolnitel;
        }

        public SbisAcceptanceCertificateOrg getZakazchik() {
            return this.zakazchik;
        }

        public String getContractNumber() {
            return this.contractNumber;
        }

        public void setContractNumber(String contractNumber) {
            this.contractNumber = contractNumber;
        }

        public String getContractDate() {
            return this.contractDate;
        }

        public void setContractDate(String contractDate) {
            this.contractDate = contractDate;
        }

        public LocalDate getStartOfWork() {
            return this.startOfWork;
        }

        public void setStartOfWork(LocalDate startOfWork) {
            this.startOfWork = startOfWork;
        }

        public LocalDate getEndOfWork() {
            return this.endOfWork;
        }

        public void setEndOfWork(LocalDate endOfWork) {
            this.endOfWork = endOfWork;
        }

        public BigDecimal getStBezNDSIt() {
            return this.stBezNDSIt;
        }

        public void setStBezNDSIt(BigDecimal stBezNDSIt) {
            this.stBezNDSIt = stBezNDSIt;
        }

        public BigDecimal getNdsIt() {
            return this.ndsIt;
        }

        public void setNdsIt(BigDecimal ndsIt) {
            this.ndsIt = ndsIt;
        }

        public BigDecimal getStSNDSIt() {
            return this.stSNDSIt;
        }

        public void setStSNDSIt(BigDecimal stSNDSIt) {
            this.stSNDSIt = stSNDSIt;
        }

        public List<SbisAktRabota> getWorks() {
            return this.works;
        }

        public String getIdVisualValue() {
            return this.idVisualValue;
        }

        public void setIdVisualValue(String idVisualValue) {
            this.idVisualValue = idVisualValue;
        }

        public String getGruzootpravitel() {
            return this.gruzootpravitel;
        }

        public void setGruzootpravitel(String gruzootpravitel) {
            this.gruzootpravitel = gruzootpravitel;
        }

        public String getSodOper() {
            return "\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0440\u0430\u0431\u043e\u0442 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u044b (\u0443\u0441\u043b\u0443\u0433\u0438 \u043e\u043a\u0430\u0437\u0430\u043d\u044b)";
        }

        public LocalDate getDataPer() {
            return this.dataPer;
        }

        public void setDataPer(LocalDate dataPer) {
            this.dataPer = dataPer;
        }

        public Map<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> getSbisDocumentElementsAttributes() {
            return this.sbisDocumentElementsAttributes;
        }

        public SbisDocumentSigner getPodpisant() {
            return this.podpisant;
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            writer.writeStartElement("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
            writer.writeAttribute("\u041a\u041d\u0414", "1175012");
            writer.writeAttribute("\u0414\u0430\u0442\u0430\u0418\u043d\u0444\u0418\u0441\u043f", SbisIntegrationHelper.dateFormat.format(this.ispDate));
            writer.writeAttribute("\u0412\u0440\u0435\u043c\u0418\u043d\u0444\u0418\u0441\u043f", SbisIntegrationHelper.timeFormat.format(this.ispDate));
            writer.writeAttribute("\u041d\u0430\u0438\u043c\u042d\u043a\u043e\u043d\u0421\u0443\u0431\u0421\u043e\u0441\u0442", this.naimEconSubSost);
            writer.writeStartElement("\u0421\u0432\u0414\u043e\u043a\u041f\u0420\u0423");
            writer.writeStartElement("\u041d\u0430\u0438\u043c\u0414\u043e\u043a");
            writer.writeAttribute("\u041f\u043e\u0424\u0430\u043a\u0442\u0425\u0416", "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0440\u0430\u0431\u043e\u0442 (\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e\u0431 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0438 \u0443\u0441\u043b\u0443\u0433)");
            writer.writeAttribute("\u041d\u0430\u0438\u043c\u0414\u043e\u043a\u041e\u043f\u0440", "\u0410\u043a\u0442 \u043e \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0440\u0430\u0431\u043e\u0442 (\u0410\u043a\u0442 \u043e\u0431 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0438 \u0443\u0441\u043b\u0443\u0433)");
            writer.writeEndElement();
            writer.writeStartElement("\u0418\u0434\u0435\u043d\u0442\u0414\u043e\u043a");
            writer.writeAttribute("\u041d\u043e\u043c\u0414\u043e\u043a\u041f\u0420\u0423", this.nomDocPru);
            writer.writeAttribute("\u0414\u0430\u0442\u0430\u0414\u043e\u043a\u041f\u0420\u0423", SbisIntegrationHelper.dateFormat.format(this.dateDocPru));
            writer.writeEndElement();
            writer.writeStartElement("\u0414\u0435\u043d\u0418\u0437\u043c");
            writer.writeAttribute("\u041a\u043e\u0434\u041e\u041a\u0412", "643");
            writer.writeAttribute("\u041d\u0430\u0438\u043c\u041e\u041a\u0412", "\u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c");
            writer.writeEndElement();
            writer.writeStartElement("\u0421\u043e\u0434\u0424\u0425\u04161");
            writer.writeStartElement("\u0417\u0430\u0433\u0421\u043e\u0434\u041e\u043f\u0435\u0440");
            writer.writeCharacters(this.zagSodOper);
            writer.writeEndElement();
            writer.writeStartElement("\u0418\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c");
            if (!TextUtil.isBlank((String)this.ispolnitel.getOkpo())) {
                writer.writeAttribute("\u041e\u041a\u041f\u041e", this.ispolnitel.getOkpo());
            }
            this.ispolnitel.toXML(writer);
            writer.writeEndElement();
            writer.writeStartElement("\u0417\u0430\u043a\u0430\u0437\u0447\u0438\u043a");
            this.zakazchik.toXML(writer);
            writer.writeEndElement();
            writer.writeStartElement("\u041e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
            writer.writeAttribute("\u041d\u0430\u0438\u043c\u041e\u0441\u043d", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440");
            writer.writeAttribute("\u041d\u043e\u043c\u041e\u0441\u043d", this.contractNumber != null ? this.contractNumber : "");
            writer.writeAttribute("\u0414\u0430\u0442\u0430\u041e\u0441\u043d", this.contractDate != null ? this.contractDate : "");
            writer.writeEndElement();
            writer.writeStartElement("\u041e\u043f\u0438\u0441\u0420\u0430\u0431\u043e\u0442");
            writer.writeAttribute("\u041d\u0430\u0447\u0420\u0430\u0431\u043e\u0442", SbisIntegrationHelper.dateFormat.format(this.startOfWork));
            writer.writeAttribute("\u041a\u043e\u043d\u0420\u0430\u0431\u043e\u0442", SbisIntegrationHelper.dateFormat.format(this.endOfWork));
            writer.writeAttribute("\u0421\u0442\u0411\u0435\u0437\u041d\u0414\u0421\u0418\u0442", priceFormatter.format(this.stBezNDSIt));
            writer.writeAttribute("\u0421\u0443\u043c\u041d\u0414\u0421\u0418\u0442", priceFormatter.format(this.ndsIt));
            writer.writeAttribute("\u0421\u0442\u0423\u0447\u041d\u0414\u0421\u0418\u0442", priceFormatter.format(this.stSNDSIt));
            for (SbisAktRabota work : this.works) {
                work.toXML(writer);
            }
            writer.writeEndElement();
            HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute> attributesInfPolFhg1 = this.sbisDocumentElementsAttributes.get(SbisIntegrationHelper.INF_POL_FHG_1);
            writer.writeStartElement(SbisIntegrationHelper.INF_POL_FHG_1);
            if (this.infoSectionParamets.isEmpty() && attributesInfPolFhg1 == null) {
                SbisAcceptanceCertificateFile.writeInfPolFhg1("\u0418\u0434\u0412\u0438\u0437\u0443\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438", this.idVisualValue, writer);
                SbisAcceptanceCertificateFile.writeInfPolFhg1("\u0413\u0440\u0443\u0437\u043e\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c", this.gruzootpravitel, writer);
            }
            if (!this.infoSectionParamets.isEmpty()) {
                for (Map.Entry entry : this.infoSectionParamets.entrySet()) {
                    SbisAcceptanceCertificateFile.writeInfPolFhg1((String)entry.getKey(), (String)entry.getValue(), writer);
                }
            }
            if (attributesInfPolFhg1 != null) {
                for (SbisIntegrationHelper.SbisDocumentElementAttribute sbisDocumentElementAttribute : attributesInfPolFhg1) {
                    SbisAcceptanceCertificateFile.writeInfPolFhg1(sbisDocumentElementAttribute.getIdentifier(), sbisDocumentElementAttribute.getValue(), writer);
                }
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("\u0421\u043e\u0434\u0424\u0425\u04162");
            writer.writeAttribute("\u0421\u043e\u0434\u041e\u043f\u0435\u0440", "\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u0440\u0430\u0431\u043e\u0442 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u044b (\u0443\u0441\u043b\u0443\u0433\u0438 \u043e\u043a\u0430\u0437\u0430\u043d\u044b)");
            writer.writeAttribute("\u0414\u0430\u0442\u0430\u041f\u0435\u0440", SbisIntegrationHelper.dateFormat.format(this.dataPer));
            writer.writeEndElement();
            this.podpisant.toXML(writer);
            writer.writeEndElement();
        }
    }
}

