/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis.model;

import com.gridnine.bof.midoffice.helper.PDFUtil;
import com.gridnine.xtrip.common.ibecorp.rules.SbisActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.SbisPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ExtendedProductType;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.DocumentHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentElement;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentElementData;
import com.gridnine.xtrip.common.model.ibecorp.sbis.SbisIntegrationSettings;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.AuthorityLetter;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.Signature;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.common.StorageHelper;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisDocumentSigner;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganization;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationAdditionalDataIP;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationAdditionalDataNonIP;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisOrganizationData;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.model.ibus.finance.documents.FinanceDocumentsIbusHelper;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SbisIntegrationHelper {
    public static DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    public static DateTimeFormatter filenameDateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH.mm.ss");
    public static final String INF_POL_FHG_1 = SbisDocumentElement.INF_POL_FHG_1.toString(LocaleHelper.RU_LOCALE);
    public static final String INF_POL_FHG_2 = SbisDocumentElement.INF_POL_FHG_2.toString(LocaleHelper.RU_LOCALE);
    public static final String INF_POLE_OPIS_RABOT = SbisDocumentElement.INF_POLE_OPIS_RABOT.toString(LocaleHelper.RU_LOCALE);
    private static final String YES = "\u0414\u0430";
    private static final String NO = "\u041d\u0435\u0442";
    private static final String oldSettingsUid = "sbis-integration-settings-uid";
    private static final List<FinanceDocumentType> sbisFinanceDocumentTypes = Arrays.asList(FinanceDocumentType.ACCEPTANCE_CERTIFICATE, FinanceDocumentType.INVOICE, FinanceDocumentType.INVOICE_FACTURA, FinanceDocumentType.INVOICE_FACTURA_FEES, FinanceDocumentType.UNIVERSAL_DOCUMENT);

    public static List<FinanceDocumentType> getSbisFinanceDocumentTypes() {
        return sbisFinanceDocumentTypes;
    }

    public static boolean hasEnabledSbisIntegrationSettings() {
        return SbisIntegrationHelper.getAllSbisSettings().stream().anyMatch(it -> ((SbisIntegrationSettings)it.getEntity()).getGeneralSettings().isEnabled());
    }

    private static Set<EntityContainer<SbisIntegrationSettings>> getAllSbisSettings() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.SBIS_INTEGRATION_SETTINGS));
        HashSet<EntityContainer<SbisIntegrationSettings>> result = new HashSet<EntityContainer<SbisIntegrationSettings>>();
        StorageHelper.getEntityContainers((SearchQuery)query, BasicSystemSettingsIndex.class).forEach(it -> {
            if (it.getEntity() instanceof SbisIntegrationSettings) {
                result.add((EntityContainer<SbisIntegrationSettings>)it);
            }
        });
        EntityContainer settingsCtr = EntityStorage.get().load(SbisIntegrationSettings.class, oldSettingsUid);
        if (settingsCtr != null) {
            result.add((EntityContainer<SbisIntegrationSettings>)settingsCtr);
        }
        return result;
    }

    public static SbisIntegrationSettings getSettings(Shipment shipment) {
        if (shipment.getSupplier() == null) {
            return null;
        }
        Set<EntityContainer<SbisIntegrationSettings>> allSbisSettings = SbisIntegrationHelper.getAllSbisSettings();
        EntityContainer result = allSbisSettings.stream().filter(it -> shipment.getSupplier().equals((Object)((SbisIntegrationSettings)it.getEntity()).getGeneralSettings().getOrganization())).findFirst().orElse(null);
        if (result == null) {
            result = allSbisSettings.stream().filter(it -> ((SbisIntegrationSettings)it.getEntity()).getGeneralSettings().getOrganization() == null).findFirst().orElse(null);
        }
        if (result == null) {
            result = new EntityContainer(SbisIntegrationSettings.class, oldSettingsUid);
            ((SbisIntegrationSettings)result.getEntity()).setType(SystemSettingsType.SBIS_INTEGRATION_SETTINGS);
            ((SbisIntegrationSettings)result.getEntity()).setName(MetaRegistryHelper.getDisplayName(SbisIntegrationSettings.class));
            EntityStorage.get().save(result, true);
        }
        return result != null ? (SbisIntegrationSettings)result.getEntity() : null;
    }

    public static SbisOrganizationData buildOrganizationData(EntityContainer<Organization> orgCtr, String customerCode, String customerIdentifier, boolean supplier, boolean disableCustomerQuotes, Date date) {
        Locale locale = LocaleHelper.RU_LOCALE;
        SbisOrganizationData result = new SbisOrganizationData();
        EntityReference orgRef = orgCtr.toReference();
        if (((Organization)orgCtr.getEntity()).getRegistrationId() == null) {
            throw Xeption.forEndUser((String)"\u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u0418\u041d\u041d", (Object[])new Object[]{orgRef});
        }
        result.setInn(((Organization)orgCtr.getEntity()).getRegistrationId());
        result.setOkpo(((Organization)orgCtr.getEntity()).getOkpoCode());
        Address address = SbisIntegrationHelper.findAddress((Organization)orgCtr.getEntity(), date);
        if (address == null) {
            throw Xeption.forEndUser((String)"\u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u0430\u0434\u0440\u0435\u0441", (Object[])new Object[]{orgRef});
        }
        result.setAddress(ProfileHelper.buildFullAddress((Address)address, (Locale)locale, (boolean)false));
        if (address.getCountry() != null) {
            result.setCountryCode(address.getCountry().getCode());
            result.setCountryName(address.getCountry().toString(locale));
        }
        result.setZip(address.getZip());
        if (address.getRegion() != null) {
            GeoRegion region = (GeoRegion)DictionaryCache.get().resolveReference(address.getRegion());
            if (region != null) {
                result.setRegionName(DictHelper.getTranslation((BaseDictionary)region, (Locale)locale, (boolean)true));
                result.setRegionCode(DictHelper.getCodeVariant((BaseDictionary)region, (CodeSystem)CodeSystem.ISO_NUMERIC));
            } else {
                result.setRegionName(address.getRegion().toString(locale));
            }
        }
        if (address.getCity() != null) {
            String prefix = ProfileHelper.getCityPrefix((Locale)locale);
            result.setCityName((TextUtil.nonBlank((String)prefix) ? prefix : "") + address.getCity().toString(locale));
            if ("MOW".equals(address.getCity().getCode()) || "\u041c\u043e\u0441\u043a\u0432\u0430".equals(address.getCity().getCode())) {
                if (TextUtil.isBlank((String)result.getRegionName())) {
                    result.setRegionName(address.getCity().toString(locale));
                }
                if (TextUtil.isBlank((String)result.getRegionCode())) {
                    result.setRegionCode("77");
                }
            }
        }
        result.setStreet(L10nStringHelper.getValue((L10nString)address.getAddress(), (Locale)locale));
        result.setHouse(L10nStringHelper.getValue((L10nString)address.getHouse(), (Locale)locale));
        String name = ((Organization)orgCtr.getEntity()).getFullName().toString();
        if (TextUtil.isBlank((String)name)) {
            name = ((Organization)orgCtr.getEntity()).getShortName().toString();
        }
        if (TextUtil.isBlank((String)name)) {
            throw Xeption.forEndUser((String)"\u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", (Object[])new Object[]{orgRef});
        }
        LegalForm legalForm = (LegalForm)DictionaryCache.get().resolveReference(((Organization)orgCtr.getEntity()).getLegalForm());
        String legalFormAbbr = null;
        if (legalForm != null) {
            legalFormAbbr = (String)MiscUtil.findByLocale((Map)legalForm.getAbbreviations(), (Locale)locale);
        }
        if (!supplier && disableCustomerQuotes) {
            name = TextUtil.nonBlank((String)legalFormAbbr) ? String.format("%s %s", legalFormAbbr, name) : String.format("%s", name);
        } else {
            String string = name = TextUtil.nonBlank(legalFormAbbr) ? String.format("%s \"%s\"", legalFormAbbr, name) : String.format("\"%s\"", name);
        }
        if (legalForm == null || !legalForm.isIndividualEntrepreneur()) {
            SbisOrganizationAdditionalDataNonIP sbisOrganizationAdditionalDataNonIP = new SbisOrganizationAdditionalDataNonIP();
            sbisOrganizationAdditionalDataNonIP.setInn(((Organization)orgCtr.getEntity()).getRegistrationId());
            sbisOrganizationAdditionalDataNonIP.setKpp(((Organization)orgCtr.getEntity()).getKpp() != null ? ((Organization)orgCtr.getEntity()).getKpp() : "");
            sbisOrganizationAdditionalDataNonIP.setOrgName(name);
            result.setAdditionalData(sbisOrganizationAdditionalDataNonIP);
        } else {
            SbisOrganizationAdditionalDataIP sbisOrganizationAdditionalDataIP = new SbisOrganizationAdditionalDataIP();
            EntityReference individualEntrepreneur = ((Organization)orgCtr.getEntity()).getIndividualEntrepreneur();
            Person individualEntrepreneurProfileCtr = null;
            EntityContainer individualEntrepreneurCtr = EntityStorage.get().resolve(individualEntrepreneur);
            if (individualEntrepreneurCtr != null) {
                individualEntrepreneurProfileCtr = (Person)individualEntrepreneurCtr.getEntity();
                L10nString firstName = individualEntrepreneurProfileCtr.getFirstName();
                L10nString lastName = individualEntrepreneurProfileCtr.getLastName();
                L10nString patronymic = individualEntrepreneurProfileCtr.getMiddleName();
                if (firstName == null || firstName.getValues().size() == 0) {
                    throw Xeption.forEndUser((String)"\u0412 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u0435 \"\u0438\u043c\u044f\"", (Object[])new Object[]{individualEntrepreneur});
                }
                Optional.ofNullable(L10nStringHelper.getValue((L10nString)firstName, (Locale)LocaleHelper.getCurrentLocale())).ifPresent(sbisOrganizationAdditionalDataIP::setName);
                if (lastName == null || lastName.getValues().size() == 0) {
                    throw Xeption.forEndUser((String)"\u0412 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u043f\u043e\u043b\u0435 \"\u0444\u0430\u043c\u0438\u043b\u0438\u044f\"", (Object[])new Object[]{individualEntrepreneur});
                }
                Optional.ofNullable(L10nStringHelper.getValue((L10nString)lastName, (Locale)LocaleHelper.getCurrentLocale())).ifPresent(sbisOrganizationAdditionalDataIP::setSurname);
                if (patronymic != null && patronymic.getValues().size() != 0) {
                    Optional.ofNullable(L10nStringHelper.getValue((L10nString)patronymic, (Locale)LocaleHelper.getCurrentLocale())).ifPresent(sbisOrganizationAdditionalDataIP::setPatronymic);
                }
            } else {
                throw Xeption.forEndUser((String)"\u0412 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0418\u041f", (Object[])new Object[]{individualEntrepreneur});
            }
            sbisOrganizationAdditionalDataIP.setInn(((Organization)orgCtr.getEntity()).getRegistrationId());
            sbisOrganizationAdditionalDataIP.setStateRegistrationInfo(((Organization)orgCtr.getEntity()).getVatLicenseNumber());
            result.setAdditionalData(sbisOrganizationAdditionalDataIP);
        }
        result.setName(name);
        if (((Organization)orgCtr.getEntity()).getKpp() == null) {
            if (legalForm == null || !legalForm.isIndividualEntrepreneur()) {
                throw Xeption.forEndUser((String)"\u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u041a\u041f\u041f", (Object[])new Object[]{orgRef});
            }
        } else {
            result.setKpp(((Organization)orgCtr.getEntity()).getKpp());
        }
        result.setUid(orgRef.getUid());
        if (supplier) {
            String phone = null;
            Communication phoneComm = SbisIntegrationHelper.findPhone((Organization)orgCtr.getEntity());
            if (phoneComm != null) {
                phone = ProfileHelper.buildFullPhoneNumber((Communication)phoneComm);
            }
            if (TextUtil.isBlank(phone)) {
                throw Xeption.forEndUser((String)"\u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u0442\u0435\u043b\u0435\u0444\u043e\u043d", (Object[])new Object[]{orgRef});
            }
            result.setPhoneNumber(phone);
        }
        if (!supplier) {
            result.setCustomerCode(customerCode);
            result.setCustomerIdentifier(customerIdentifier);
        }
        return result;
    }

    public static SbisOrganizationData buildOrganizationData(FinanceDocument financeDocument, EntityStorageContext sc, String customerCode, String customerIdentifier, boolean supplier, boolean fillBankAccountData) {
        EntityReference orgRef = supplier ? financeDocument.getSupplier() : financeDocument.getCustomer();
        EntityContainer orgCtr = EntityStorageHelper.resolve((EntityReference)orgRef, (EntityStorageContext)sc);
        if (orgCtr == null) {
            throw Xeption.forEndUser((String)(supplier ? "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430" : "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f"), (Object[])new Object[0]);
        }
        SbisOrganizationData result = SbisIntegrationHelper.buildOrganizationData((EntityContainer<Organization>)orgCtr, customerCode, customerIdentifier, supplier, financeDocument.isDisableCustomerQuotes(), financeDocument.getDate());
        if (fillBankAccountData) {
            BankAccount bankAccount = null;
            if (supplier) {
                bankAccount = (BankAccount)EntityStorageHelper.resolve((NestedEntityReference)financeDocument.getSupplierBankAccount(), (EntityStorageContext)sc);
            } else if (financeDocument.getPayerBankAccount() != null) {
                bankAccount = (BankAccount)EntityStorageHelper.resolve((NestedEntityReference)financeDocument.getPayerBankAccount(), (EntityStorageContext)sc);
            }
            SbisIntegrationHelper.fillBankAccountData(result, (EntityContainer<Organization>)orgCtr, bankAccount);
        }
        return result;
    }

    public static SbisOrganizationData buildOrganizationData(Shipment shipment, EntityStorageContext sc, String customerCode, String customerIdentifier, boolean supplier, boolean fillBankAccountData) {
        EntityReference orgRef = supplier ? shipment.getSupplier() : shipment.getCustomer();
        EntityContainer orgCtr = EntityStorageHelper.resolve((EntityReference)orgRef, (EntityStorageContext)sc);
        if (orgCtr == null) {
            throw Xeption.forEndUser((String)(supplier ? "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430" : "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f"), (Object[])new Object[0]);
        }
        SbisOrganizationData result = SbisIntegrationHelper.buildOrganizationData((EntityContainer<Organization>)orgCtr, customerCode, customerIdentifier, supplier, false, shipment.getDate());
        if (fillBankAccountData) {
            BankAccount bankAccount = null;
            for (EntityReference doc : shipment.getFinanceDocuments()) {
                EntityContainer docCtr = EntityStorageHelper.resolve((EntityReference)doc, (EntityStorageContext)sc);
                if (docCtr == null) continue;
                BankAccount ba = null;
                if (supplier) {
                    ba = (BankAccount)EntityStorageHelper.resolve((NestedEntityReference)((FinanceDocument)docCtr.getEntity()).getSupplierBankAccount(), (EntityStorageContext)sc);
                } else if (((FinanceDocument)docCtr.getEntity()).getPayerBankAccount() != null) {
                    ba = (BankAccount)EntityStorageHelper.resolve((NestedEntityReference)((FinanceDocument)docCtr.getEntity()).getPayerBankAccount(), (EntityStorageContext)sc);
                }
                if (ba == null) continue;
                bankAccount = ba;
                break;
            }
            SbisIntegrationHelper.fillBankAccountData(result, (EntityContainer<Organization>)orgCtr, bankAccount);
        }
        return result;
    }

    private static Communication findPhone(Organization entity) {
        Communication def = null;
        for (Communication comm : entity.getCommunications()) {
            if (comm.getType() == CommunicationType.WORK_PHONE) {
                return comm;
            }
            if (comm.getType() != CommunicationType.MOBILE && comm.getType() != CommunicationType.HOME_PHONE) continue;
            def = comm;
        }
        return def;
    }

    private static Address findAddress(Organization entity, Date date) {
        Address def = null;
        for (Address add : ProfileHelper.getOrganizationAddresses((Organization)entity, (Date)date)) {
            if (add.getAddressType() == AddressType.LEGAL) {
                return add;
            }
            if (def != null) continue;
            def = add;
        }
        return def;
    }

    private static void fillBankAccountData(SbisOrganizationData result, EntityContainer<Organization> orgCtr, BankAccount bankAccount) {
        EntityReference orgRef = orgCtr.toReference();
        if (bankAccount == null && ((Organization)orgCtr.getEntity()).getBankAccounts().size() == 1) {
            bankAccount = (BankAccount)((Organization)orgCtr.getEntity()).getBankAccounts().get(0);
        }
        if (bankAccount == null || TextUtil.isBlank((String)bankAccount.getSettlementAccount()) || TextUtil.isBlank((String)bankAccount.getBankName()) || TextUtil.isBlank((String)bankAccount.getBik())) {
            throw Xeption.forEndUser((String)"\u0432 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 {0} \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b, \u043b\u0438\u0431\u043e \u0432 \u0444\u0438\u043d\u0434\u043e\u043a\u0430\u0445 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0441\u0447\u0435\u0442", (Object[])new Object[]{orgRef});
        }
        result.setSettlementAccount(bankAccount.getSettlementAccount());
        result.setCorrespondentAccount(bankAccount.getCorrespondentAccount());
        result.setBankName(bankAccount.getBankName());
        result.setBik(bankAccount.getBik());
    }

    public static List<BillingItemWrapper> getMergedBillingItem(FinanceDocument doc, EntityStorageContext sc, boolean simpleTaxed, VatViewMode vatViewMode, Map<BillingItem, List<FinanceDocument>> vendorBillingItems) throws Exception {
        Locale locale = LocaleHelper.getCurrentLocale();
        boolean hasColumnVatRate = false;
        boolean noPenaltyVat = false;
        EntityContainer templateCtr = EntityStorageHelper.resolve((EntityReference)doc.getTemplate(), (EntityStorageContext)sc);
        if (templateCtr != null) {
            String localeStr = SystemHelper.findMetadataAsString((Collection)((TemplateDocument)templateCtr.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_LOCALE);
            if (!TextUtil.isBlank((String)localeStr)) {
                locale = LocaleHelper.getLocale((String)localeStr);
            }
            hasColumnVatRate = Boolean.TRUE.equals(SystemHelper.getMetadataAsBoolean((Collection)((TemplateDocument)templateCtr.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_HAS_COLUMN_VAT_RATE));
            noPenaltyVat = Boolean.TRUE.equals(SystemHelper.getMetadataAsBoolean((Collection)((TemplateDocument)templateCtr.getEntity()).getMetadata(), (MetadataKey)MetadataKey.KEY_NO_PENALTY_VAT));
        }
        ArrayList<BillingItemWrapper> billingItems = new ArrayList<BillingItemWrapper>();
        Collection mergedBillingItems = FinanceDocumentsIbusHelper.prepareBillingItems((FinanceDocument)doc, (boolean)hasColumnVatRate, (boolean)noPenaltyVat, (Locale)locale, (EntityStorageContext)sc);
        for (FinanceDocumentsIbusHelper.MergedBillingItem item : mergedBillingItems) {
            BillingItemWrapper wrapper = new BillingItemWrapper(item.getMergedBillingItem());
            for (BillingItem bi : item.getBillingItems()) {
                List<FinanceDocument> financeDocuments = vendorBillingItems.get(bi);
                if (financeDocuments == null) continue;
                wrapper.setVendorBillingItem(true);
                financeDocuments.stream().filter(d -> d.getType() == FinanceDocumentType.INVOICE_FACTURA).findFirst().ifPresent(d -> {
                    wrapper.setVendorInvoiceFacturaNumber(d.getNumber());
                    wrapper.setVendorInvoiceFacturaDate(d.getDate());
                });
                break;
            }
            boolean vatInclude = hasColumnVatRate;
            BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)item.getMergedBillingItem().getProduct(), (EntityStorageContext)sc);
            if (product != null) {
                boolean bl = vatInclude = vatInclude && ProductHandler.of((BaseProduct)product).isVatIncludeBillingItem(product, vatViewMode, item.getMergedBillingItem());
            }
            if ((!vatInclude || simpleTaxed) && wrapper.getBillingItem().getAmount() != null) {
                BigDecimal total = wrapper.getBillingItem().getAmount().getTotal();
                wrapper.getBillingItem().getAmount().setTotalNoVat(total);
            }
            billingItems.add(wrapper);
        }
        return billingItems;
    }

    public static Document createFinanceDocument(EntityContainer<FinanceDocument> financeDocument, String fileId) throws Exception {
        byte[] content = JasperUtil.convertToPdf((byte[])((FinanceDocument)financeDocument.getEntity()).getContent().getData());
        String name = String.format("%s.pdf", fileId);
        Document doc = new Document();
        doc.setType(DocumentType.OTHER);
        doc.setContentType(ContentType.PDF);
        doc.setName(name);
        doc.setContent(content);
        return doc;
    }

    public static Document createDocument(EntityContainer<Document> document, String fileId, Map<String, Integer> names) throws Exception {
        byte[] content = ((Document)document.getEntity()).getContent();
        ContentType contentType = ((Document)document.getEntity()).getContentType();
        if (contentType == ContentType.JASPERPRINT) {
            content = JasperUtil.convertToPdf((byte[])((Document)document.getEntity()).getContent());
            contentType = ContentType.PDF;
        }
        String extension = (String)CollectionUtil.head((Iterable)DocumentHelper.getExtensions((ContentType)contentType));
        if (names.containsKey(fileId)) {
            int index = names.get(fileId) + 1;
            fileId = !fileId.endsWith("." + extension) ? String.format("%s_%s", fileId, index) : String.format("%s_%s.%s", fileId.substring(0, fileId.lastIndexOf("." + extension)), index, extension);
            names.put(fileId, index);
        } else {
            names.put(fileId, 1);
        }
        String name = !fileId.endsWith("." + extension) ? String.format("%s.%s", fileId, extension) : fileId;
        Document doc = new Document();
        doc.setType(((Document)document.getEntity()).getType());
        doc.setContentType(contentType);
        doc.setName(name);
        doc.setContent(content);
        return doc;
    }

    public static Document createJoinedPdfDocument(List<EntityContainer<Document>> documents, String fileId, Map<String, Integer> names) throws Exception {
        List<ContentType> pdfContentTypes = Arrays.asList(ContentType.PDF, ContentType.JASPERPRINT);
        List pdfDocuments = documents.stream().filter(d -> pdfContentTypes.contains(((Document)d.getEntity()).getContentType())).collect(Collectors.toList());
        ArrayList<byte[]> contents = new ArrayList<byte[]>();
        for (EntityContainer document : pdfDocuments) {
            byte[] documentContent = ((Document)document.getEntity()).getContent();
            ContentType contentType = ((Document)document.getEntity()).getContentType();
            if (contentType == ContentType.JASPERPRINT) {
                documentContent = JasperUtil.convertToPdf((byte[])((Document)document.getEntity()).getContent());
            }
            if (documentContent.length == 0) continue;
            contents.add(documentContent);
        }
        if (contents.size() == 0) {
            return null;
        }
        byte[] content = PDFUtil.joinPdf((byte[][])((byte[][])contents.toArray((T[])new byte[contents.size()][])));
        String extension = (String)CollectionUtil.head((Iterable)DocumentHelper.getExtensions((ContentType)ContentType.PDF));
        if (names.containsKey(fileId)) {
            int index = names.get(fileId) + 1;
            fileId = !fileId.endsWith("." + extension) ? String.format("%s_%s", fileId, index) : String.format("%s_%s.%s", fileId.substring(0, fileId.lastIndexOf("." + extension)), index, extension);
            names.put(fileId, index);
        } else {
            names.put(fileId, 1);
        }
        String name = !fileId.endsWith("." + extension) ? String.format("%s.%s", fileId, extension) : fileId;
        Document doc = new Document();
        doc.setContentType(ContentType.PDF);
        doc.setName(name);
        doc.setContent(content);
        return doc;
    }

    public static SbisActionSet applyRules(EntityContainer<Shipment> shipment, FinanceDocument financeDocument, BaseProduct product, boolean intermediaryService) throws Exception {
        RuleProxy proxy = new RuleProxy();
        SbisPropertySet propertySet = new SbisPropertySet(proxy);
        SbisActionSet actionSet = new SbisActionSet();
        proxy.setProxyType(Targets.SBIS_PARAMETERS.getId());
        proxy.setProxyDate(((Shipment)shipment.getEntity()).getDate());
        proxy.setPropertySet((Object)propertySet);
        proxy.setActionSet((Object)actionSet);
        propertySet.init(financeDocument, product, intermediaryService);
        List<MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo>> contracts = IbecorpRulesHelper.getContractsForShipment(shipment);
        for (MiscUtil.Pair<EntityContainer<Contract>, ContractCustomerInfo> contract : contracts) {
            List rules = ProfileHelper.getRuleContainers((EntityContainer)((EntityContainer)contract.getFirst()), (Date)((Shipment)shipment.getEntity()).getDate());
            for (EntityContainer rule : rules) {
                RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rule.getEntity()).getRuleSet(), (RuleResultHandler)new RuleResultHandler(){

                    public boolean isProcessAllRuleResults() {
                        return true;
                    }

                    public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) throws Exception {
                    }
                });
            }
        }
        return actionSet;
    }

    public static Map<String, HashSet<SbisDocumentElementAttribute>> getElementsAttributes(BaseProduct product, BillingItemWrapper billingItemWrapper, NestedEntityReference<BookingFile, Traveller> travellerRef, List<SbisDocumentElementData> sbisDocumentElementsData, Date date, EntityStorageContext storageContext) {
        HashMap<String, HashSet<SbisDocumentElementAttribute>> result = new HashMap<String, HashSet<SbisDocumentElementAttribute>>();
        if (product == null) {
            return result;
        }
        ProductHandler productHandler = ProductHandler.of((BaseProduct)product);
        StatisticalData statisticalData = productHandler.getStatisticalData(product);
        ServiceType serviceType = billingItemWrapper.getBillingItem().getServiceType();
        for (SbisDocumentElementData data : sbisDocumentElementsData) {
            if (data.getElement() == null) continue;
            ArrayList<Object> attributes = new ArrayList<Object>();
            if (data.getAttributesPredefined() != null) {
                SbisDocumentElementAttribute attribute;
                Date createDate;
                String number;
                Object attribute2;
                ProductStatus status;
                if (data.getAttributesPredefined().isProductStatus() && (status = productHandler.getStatus(product)) != null) {
                    attribute2 = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_SERVICE_TYPE"), status.toString(LocaleHelper.RU_LOCALE).toLowerCase());
                    attributes.add(attribute2);
                }
                if (data.getAttributesPredefined().isBookingNumber() && TextUtil.nonBlank((String)(number = product.getReservation().getBookingFile().getNumber()))) {
                    attribute2 = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_BOOKING_NUMBER"), number);
                    attributes.add(attribute2);
                }
                if (data.getAttributesPredefined().isBooking\u0421reateDate() && (createDate = product.getReservation().getBookingFile().getCreateDate()) != null) {
                    attribute2 = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_BOOKING_CREATE_DATE"), dateFormat.format(MiscUtil.toLocalDate((Date)createDate)));
                    attributes.add(attribute2);
                }
                if (data.getAttributesPredefined().isCarrierRegistrationId() || data.getAttributesPredefined().isCarrierKpp()) {
                    SbisDocumentElementAttribute attribute3;
                    EntityContainer organizationContainer;
                    String carrierRegistrationId = null;
                    String carrierRegistrationKpp = null;
                    EntityReference supplier = GeneralProductHelper.getAgency((BaseProduct)product);
                    if (billingItemWrapper.isVendorBillingItem()) {
                        supplier = GeneralProductHelper.getSupplier((BaseProduct)product);
                    }
                    if (supplier != null && (organizationContainer = EntityStorageHelper.resolve((EntityReference)supplier, (EntityStorageContext)storageContext)) != null) {
                        Organization organization = (Organization)organizationContainer.getEntity();
                        carrierRegistrationId = (String)HistoricalValueHelper.getValue((List)organization.getRegistrationIdHistory(), (Date)(date != null ? date : new Date()));
                        carrierRegistrationKpp = (String)HistoricalValueHelper.getValue((List)organization.getKppHistory(), (Date)(date != null ? date : new Date()));
                    }
                    if (product instanceof Product && ServiceType.FEE != serviceType) {
                        carrierRegistrationId = null;
                        carrierRegistrationKpp = null;
                        Airline airline = Optional.ofNullable(((Product)product).getCarrier()).map(c -> (Airline)DictionaryCache.get().resolveReference(c)).orElse(null);
                        if (airline != null) {
                            carrierRegistrationId = airline.getRegistrationId();
                            carrierRegistrationKpp = airline.getKpp();
                        }
                    }
                    if (product instanceof RailwayProduct && ServiceType.FEE != serviceType) {
                        carrierRegistrationId = null;
                        carrierRegistrationKpp = null;
                        RailwayCarrier railwayCarrier = ((RailwayProduct)product).getSegments().stream().map(item -> (RailwayCarrier)DictionaryCache.get().resolveReference(item.getCarrier())).filter(Objects::nonNull).findFirst().orElse(null);
                        if (railwayCarrier != null) {
                            carrierRegistrationId = railwayCarrier.getInn();
                            carrierRegistrationKpp = railwayCarrier.getKpp();
                        }
                    }
                    if (data.getAttributesPredefined().isCarrierRegistrationId() && TextUtil.nonBlank(carrierRegistrationKpp)) {
                        attribute3 = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_CARRIER_REGISTRATION_ID"), carrierRegistrationId);
                        attributes.add(attribute3);
                    }
                    if (data.getAttributesPredefined().isCarrierKpp() && TextUtil.nonBlank(carrierRegistrationKpp)) {
                        attribute3 = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_CARRIER_KPP"), carrierRegistrationKpp);
                        attributes.add(attribute3);
                    }
                }
                if (product instanceof BaseTicketProduct) {
                    Date issueDate;
                    String systemNumber;
                    if (data.getAttributesPredefined().isTicketNumber() && TextUtil.nonBlank((String)(systemNumber = ((BaseTicketProduct)product).getSystemNumber()))) {
                        attribute2 = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_TICKET_NUMBER"), systemNumber);
                        attributes.add(attribute2);
                    }
                    if (data.getAttributesPredefined().isTicketDate() && (issueDate = ((BaseTicketProduct)product).getIssueDate()) != null) {
                        attribute2 = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_TICKET_DATE"), dateFormat.format(MiscUtil.toLocalDate((Date)issueDate)));
                        attributes.add(attribute2);
                    }
                }
                if (data.getAttributesPredefined().isIntermediaryService()) {
                    attribute = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_INTERMEDIARY_SERVICE"), SbisIntegrationHelper.isIntermediaryService(billingItemWrapper, storageContext) ? YES : NO);
                    attributes.add(attribute);
                }
                if (billingItemWrapper.isVendorBillingItem()) {
                    Date vendorInvoiceFacturaDate;
                    String vendorInvoiceFacturaNumber;
                    if (data.getAttributesPredefined().isVendorInvoiceFacturaNumber() && TextUtil.nonBlank((String)(vendorInvoiceFacturaNumber = billingItemWrapper.getVendorInvoiceFacturaNumber()))) {
                        attribute2 = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_VENDOR_INVOICE_FACTURA_NUMBER"), vendorInvoiceFacturaNumber);
                        attributes.add(attribute2);
                    }
                    if (data.getAttributesPredefined().isVendorInvoiceFacturaDate() && (vendorInvoiceFacturaDate = billingItemWrapper.getVendorInvoiceFacturaDate()) != null) {
                        attribute2 = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_VENDOR_INVOICE_FACTURA_DATE"), dateFormat.format(MiscUtil.toLocalDate((Date)vendorInvoiceFacturaDate)));
                        attributes.add(attribute2);
                    }
                }
                if (data.getAttributesPredefined().isLocationType()) {
                    attribute = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_LOCATION_TYPE"), SbisIntegrationHelper.getLocationTypeValue(product));
                    attributes.add(attribute);
                }
                if (data.getAttributesPredefined().isServiceType()) {
                    attribute = new SbisDocumentElementAttribute(L10n.get((String)"SBIS_BILLING_ITEM_SERVICE_TYPE"), serviceType != null ? serviceType.toString() : "");
                    attributes.add(attribute);
                }
            }
            if (statisticalData == null) {
                return result;
            }
            Traveller traveller = (Traveller)EntityStorageHelper.resolve(travellerRef, (EntityStorageContext)storageContext);
            for (com.gridnine.xtrip.common.model.ibecorp.sbis.SbisDocumentElementAttribute attribute : data.getAttributes()) {
                String costCodeValue;
                if (attribute.getCostCodeCategory() == null || TextUtil.isBlank((String)attribute.getIdentifier()) || (costCodeValue = (String)statisticalData.getTravellerCostCodes().stream().filter(item -> MiscUtil.equals((Object)item.getTraveller(), (Object)traveller)).flatMap(item -> item.getCostCodes().stream()).filter(costCode -> TextUtil.nonBlank((String)costCode.getValue()) && costCode.getCostCodeProperties() != null && attribute.getCostCodeCategory().equals((Object)costCode.getCostCodeProperties().getCategory())).map(CostCode::getValue).findFirst().orElse(null)) == null) continue;
                SbisDocumentElementAttribute elementAttribute = new SbisDocumentElementAttribute(attribute.getIdentifier(), costCodeValue);
                attributes.add(elementAttribute);
            }
            HashSet resultAttributes = (HashSet)result.get(data.getElement().toString(LocaleHelper.RU_LOCALE));
            if (resultAttributes == null) {
                resultAttributes = new HashSet();
            }
            resultAttributes.addAll(attributes);
            if (resultAttributes.isEmpty()) continue;
            result.put(data.getElement().toString(LocaleHelper.RU_LOCALE), resultAttributes);
        }
        return result;
    }

    public static Map<String, HashSet<SbisDocumentElementAttribute>> mergeAttributes(Map<String, HashSet<SbisDocumentElementAttribute>> attributes) {
        HashMap<String, HashSet<SbisDocumentElementAttribute>> result = new HashMap<String, HashSet<SbisDocumentElementAttribute>>();
        for (Map.Entry<String, HashSet<SbisDocumentElementAttribute>> entry : attributes.entrySet()) {
            HashSet<SbisDocumentElementAttribute> mergedAttributes = new HashSet<SbisDocumentElementAttribute>();
            Set identifiers = entry.getValue().stream().map(SbisDocumentElementAttribute::getIdentifier).collect(Collectors.toSet());
            for (String identifier : identifiers) {
                String value = entry.getValue().stream().filter(item -> item.getIdentifier().equals(identifier)).map(SbisDocumentElementAttribute::getValue).sorted().collect(Collectors.joining(", "));
                SbisDocumentElementAttribute attribute = new SbisDocumentElementAttribute(identifier, value);
                mergedAttributes.add(attribute);
            }
            result.put(entry.getKey(), mergedAttributes);
        }
        return result;
    }

    public static boolean isIntermediaryService(BillingItemWrapper billingItemWrapper, EntityStorageContext sc) {
        if (billingItemWrapper.getBillingItem() == null) {
            return false;
        }
        if (billingItemWrapper.isVendorBillingItem()) {
            return true;
        }
        BaseProduct product = (BaseProduct)EntityStorageHelper.resolve((NestedEntityReference)billingItemWrapper.getBillingItem().getProduct(), (EntityStorageContext)sc);
        return (product instanceof Product || product instanceof RailwayProduct || product instanceof AeroexpressTicket || product instanceof BusProduct) && ServiceType.FEE != billingItemWrapper.getBillingItem().getServiceType();
    }

    public static ExtendedProductType getExtendedProductType(BaseProduct product) {
        ProductHandler handler = ProductHandler.of((BaseProduct)product);
        ExtendedProductType productType = new ExtendedProductType();
        productType.setProductType(handler.getProductType(product));
        productType.setProductDescription(handler.getUniversalProductDescription(product));
        return productType;
    }

    public static void writeTextInf(XMLStreamWriter writer, String id, String value) throws XMLStreamException {
        writer.writeStartElement("\u0422\u0435\u043a\u0441\u0442\u0418\u043d\u0444");
        writer.writeAttribute("\u0418\u0434\u0435\u043d\u0442\u0438\u0444", id);
        writer.writeAttribute("\u0417\u043d\u0430\u0447\u0435\u043d", value);
        writer.writeEndElement();
    }

    public static void writeElement(String id, String value, String elementName, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(elementName);
        writer.writeAttribute("\u0418\u0434\u0435\u043d\u0442\u0438\u0444", id);
        writer.writeAttribute("\u0417\u043d\u0430\u0447\u0435\u043d", value);
        writer.writeEndElement();
    }

    public static void writeOptionalAttribute(XMLStreamWriter writer, String id, String value) throws XMLStreamException {
        if (TextUtil.nonBlank((String)value)) {
            writer.writeAttribute(id, value);
        }
    }

    public static void fillSignerData(SbisDocumentSigner sbisSigner, FinanceDocument document, SbisOrganization sbisSupplier, String oblPoln, EntityStorageContext storageContext) {
        EntityReference supplier = document.getSupplier();
        FinanceDocumentsProperties properties = FinanceDocumentHelper.getFinanceDocumentsProperties((EntityReference)supplier, (boolean)false);
        if (properties == null) {
            return;
        }
        FinanceDocumentSettings settings = properties.getFinanceDocumentsSettings().stream().filter(item -> item.getType() == document.getType()).findFirst().orElse(null);
        if (settings == null) {
            return;
        }
        for (Signature signature : settings.getSignatures()) {
            String title;
            AuthorityLetter authorityLetter;
            Person signer;
            if (signature.getPosition() == null || (signer = (Person)Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)signature.getSigner(), (EntityStorageContext)storageContext)).map(EntityContainer::getEntity).orElse(null)) == null || signer.getEmployments().stream().filter(item -> MiscUtil.equals((Object)item.getOrganization(), (Object)document.getSupplier())).noneMatch(item -> MiscUtil.isBetween((Date)item.getOpened(), (Date)item.getClosed(), (Date)(document.getDate() != null ? document.getDate() : new Date())))) continue;
            Person delegate = Optional.ofNullable(document.isUseDelegate() ? EntityStorageHelper.resolve((EntityReference)document.getAgent(), (EntityStorageContext)storageContext) : null).map(EntityContainer::getEntity).orElse(null);
            AuthorityLetter authorityLetter2 = authorityLetter = delegate != null ? FinanceDocumentHelper.getAuthorityLetter((Person)delegate, (DictionaryReference)signature.getPosition(), (FinanceDocumentType)document.getType(), (Date)document.getDate()) : null;
            if (delegate != null && authorityLetter != null) {
                signer = delegate;
            }
            if (signer.getLastName() != null) {
                sbisSigner.setLastName(signer.getLastName().toString());
            }
            if (signer.getFirstName() != null) {
                sbisSigner.setFirstName(signer.getFirstName().toString());
            }
            if (signer.getMiddleName() != null) {
                sbisSigner.setMiddleName(signer.getMiddleName().toString());
            }
            sbisSigner.setPosition(TextUtil.isBlank((String)(title = signature.getTitle().toString())) ? signature.getPosition().toString() : title);
        }
        sbisSigner.setSupplier(sbisSupplier);
        sbisSigner.setOblPoln(oblPoln);
    }

    private static String getLocationTypeValue(BaseProduct baseProduct) {
        String countryCode;
        String departureCode;
        String arrivalCode;
        Product product;
        String ruCode = "RU";
        String ruValue = "\u0420\u0424";
        String abroadValue = "\u0417\u0430\u0433\u0440\u0430\u043d";
        if (baseProduct instanceof Product) {
            product = (Product)baseProduct;
            for (SegmentTariff st : product.getSegmentTariffs()) {
                for (Segment segment : st.getSegments()) {
                    Country arrivalCountry = DictHelper.findCountry((String)Optional.of(segment.getArriveLocation()).map(DictionaryReference::getCode).orElse(null));
                    Country departureCountry = DictHelper.findCountry((String)Optional.of(segment.getDepartureLocation()).map(DictionaryReference::getCode).orElse(null));
                    if ((arrivalCountry == null || ruCode.equals(arrivalCountry.getCode())) && (departureCountry == null || ruCode.equals(departureCountry.getCode()))) continue;
                    return abroadValue;
                }
            }
        }
        if (baseProduct instanceof RailwayProduct) {
            product = (RailwayProduct)baseProduct;
            for (RailwaySegment segment : product.getSegments()) {
                arrivalCode = SbisIntegrationHelper.getRailwayStationCountryCode((DictionaryReference<RailwayStation>)segment.getArriveStation());
                departureCode = SbisIntegrationHelper.getRailwayStationCountryCode((DictionaryReference<RailwayStation>)segment.getDepartureStation());
                if (MiscUtil.equals((Object)ruCode, (Object)arrivalCode) && MiscUtil.equals((Object)ruCode, (Object)departureCode)) continue;
                return abroadValue;
            }
        }
        if (baseProduct instanceof BusProduct) {
            product = (BusProduct)baseProduct;
            for (RailwaySegment segment : product.getSegments()) {
                arrivalCode = SbisIntegrationHelper.getBusStationCountryCode((DictionaryReference<BusStation>)segment.getArrival());
                departureCode = SbisIntegrationHelper.getBusStationCountryCode((DictionaryReference<BusStation>)segment.getDeparture());
                if (MiscUtil.equals((Object)ruCode, (Object)arrivalCode) && MiscUtil.equals((Object)ruCode, (Object)departureCode)) continue;
                return abroadValue;
            }
        }
        if (baseProduct instanceof HotelProduct && ((product = (HotelProduct)baseProduct).getHotelCountry() != null ? !ruCode.equals(product.getHotelCountry().getCode()) : product.getHotelLocation() != null && !MiscUtil.equals((Object)ruCode, (Object)(countryCode = (String)Optional.ofNullable(DictHelper.findCountry((String)product.getHotelLocation().getCode())).map(BaseDictionary::getCode).orElse(null))))) {
            return abroadValue;
        }
        if (baseProduct instanceof VisaProduct && !MiscUtil.equals((Object)ruCode, (Object)(countryCode = (String)Optional.ofNullable((product = (VisaProduct)baseProduct).getCountry()).map(DictionaryReference::getCode).orElse(null)))) {
            return abroadValue;
        }
        if (baseProduct instanceof TaxiProduct && ((product = (TaxiProduct)baseProduct).getCountry() != null ? !ruCode.equals(product.getCountry().getCode()) : product.getCity() != null && !MiscUtil.equals((Object)ruCode, (Object)(countryCode = (String)Optional.ofNullable(DictHelper.findCountry((String)product.getCity().getCode())).map(BaseDictionary::getCode).orElse(null))))) {
            return abroadValue;
        }
        if (baseProduct instanceof Transfer) {
            product = (Transfer)baseProduct;
            if (product.getStartCountry() != null ? !ruCode.equals(product.getStartCountry().getCode()) : product.getStartCity() != null && !MiscUtil.equals((Object)ruCode, (Object)(countryCode = (String)Optional.ofNullable(DictHelper.findCountry((String)product.getStartCity().getCode())).map(BaseDictionary::getCode).orElse(null)))) {
                return abroadValue;
            }
            if (product.getEndCountry() != null ? !ruCode.equals(product.getEndCountry().getCode()) : product.getEndCity() != null && !MiscUtil.equals((Object)ruCode, (Object)(countryCode = (String)Optional.ofNullable(DictHelper.findCountry((String)product.getEndCity().getCode())).map(BaseDictionary::getCode).orElse(null)))) {
                return abroadValue;
            }
        }
        return ruValue;
    }

    private static String getRailwayStationCountryCode(DictionaryReference<RailwayStation> station) {
        if (station == null) {
            return null;
        }
        RailwayStation railwayStation = (RailwayStation)DictionaryCache.get().resolveReference(station);
        if (railwayStation == null) {
            return null;
        }
        if (railwayStation.getCountry() != null) {
            return railwayStation.getCountry().getCode();
        }
        GeoLocation geoLocation = (GeoLocation)DictionaryCache.get().resolveReference(railwayStation.getGeoLocation());
        if (geoLocation != null && geoLocation.getCountry() != null) {
            return geoLocation.getCountry().getCode();
        }
        return null;
    }

    private static String getBusStationCountryCode(DictionaryReference<BusStation> station) {
        if (station == null) {
            return null;
        }
        BusStation busStation = (BusStation)DictionaryCache.get().resolveReference(station);
        if (busStation == null) {
            return null;
        }
        if (busStation.getCountry() != null) {
            return busStation.getCountry().getCode();
        }
        GeoLocation geoLocation = (GeoLocation)DictionaryCache.get().resolveReference(busStation.getCity());
        if (geoLocation != null && geoLocation.getCountry() != null) {
            return geoLocation.getCountry().getCode();
        }
        return null;
    }

    public static class BillingItemWrapper {
        BillingItem billingItem;
        boolean vendorBillingItem;
        String vendorInvoiceFacturaNumber;
        Date vendorInvoiceFacturaDate;

        public BillingItemWrapper(BillingItem billingItem) {
            this.billingItem = billingItem;
        }

        public BillingItem getBillingItem() {
            return this.billingItem;
        }

        public boolean isVendorBillingItem() {
            return this.vendorBillingItem;
        }

        public String getVendorInvoiceFacturaNumber() {
            return this.vendorInvoiceFacturaNumber;
        }

        public Date getVendorInvoiceFacturaDate() {
            return this.vendorInvoiceFacturaDate;
        }

        public void setVendorBillingItem(boolean vendorBillingItem) {
            this.vendorBillingItem = vendorBillingItem;
        }

        public void setVendorInvoiceFacturaNumber(String vendorInvoiceFacturaNumber) {
            this.vendorInvoiceFacturaNumber = vendorInvoiceFacturaNumber;
        }

        public void setVendorInvoiceFacturaDate(Date vendorInvoiceFacturaDate) {
            this.vendorInvoiceFacturaDate = vendorInvoiceFacturaDate;
        }
    }

    public static class SbisDocumentElementAttribute {
        private String identifier;
        private String value;

        public SbisDocumentElementAttribute(String identifier, String value) {
            this.identifier = identifier;
            this.value = value;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getValue() {
            return this.value;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SbisDocumentElementAttribute)) {
                return false;
            }
            SbisDocumentElementAttribute other = (SbisDocumentElementAttribute)obj;
            return MiscUtil.equals((Object)this.identifier, (Object)other.getIdentifier()) && MiscUtil.equals((Object)this.value, (Object)other.getValue());
        }

        public int hashCode() {
            return this.identifier.hashCode() + this.value.hashCode();
        }
    }
}

