/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis.model;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisFile;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisIntegrationHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisSerializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SbisInvoiceFile
implements SbisFile {
    private NumberFormat kolvoFormatter = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.ENGLISH));
    private NumberFormat priceFormatter = new DecimalFormat("0.00;-0.00", new DecimalFormatSymbols(Locale.ENGLISH));
    private NumberFormat commissionFormatter = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ENGLISH));
    private String fileId;
    private final String format = "\u042d\u0414\u041e\u0421\u0447";
    private final String formatVersion = "3.01";
    private final String formCode = "\u041e\u041e\u041e \"\u0422\u0422-\u0422\u0440\u044d\u0432\u0435\u043b\"";
    private final String name = "\u0421\u0447\u0435\u0442 \u043d\u0430 \u043e\u043f\u043b\u0430\u0442\u0443";
    private LocalDateTime date;
    private String number;
    private LocalDate dogovorDate;
    private String dogovorNumber;
    private String infPodval;
    private BigDecimal itogoKOplate;
    private BigDecimal commission;
    private BigDecimal nds20;
    private BigDecimal nds10;
    private BigDecimal bezNDS;
    private int itogoKolvo;
    private BigDecimal itogoSum;
    private BigDecimal itogoSumBezNal;
    private BigDecimal itogoNDS;
    private final SbisInvoiceSupplier supplier = new SbisInvoiceSupplier();
    private final SbisInvoiceCustomer customer = new SbisInvoiceCustomer();
    private final List<SbisInvoiceTableRow> rows = new ArrayList<SbisInvoiceTableRow>();
    private Map<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> sbisDocumentElementsAttributes = new HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>>();

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFormat() {
        return "\u042d\u0414\u041e\u0421\u0447";
    }

    public String getFormatVersion() {
        return "3.01";
    }

    public String getFormCode() {
        return "\u041e\u041e\u041e \"\u0422\u0422-\u0422\u0440\u044d\u0432\u0435\u043b\"";
    }

    public String getName() {
        return "\u0421\u0447\u0435\u0442 \u043d\u0430 \u043e\u043f\u043b\u0430\u0442\u0443";
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public void setDate(LocalDateTime date) {
        this.date = date;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public LocalDate getDogovorDate() {
        return this.dogovorDate;
    }

    public void setDogovorDate(LocalDate dogovorDate) {
        this.dogovorDate = dogovorDate;
    }

    public String getDogovorNumber() {
        return this.dogovorNumber;
    }

    public void setDogovorNumber(String dogovorNumber) {
        this.dogovorNumber = dogovorNumber;
    }

    public String getInfPodval() {
        return this.infPodval;
    }

    public void setInfPodval(String infPodval) {
        this.infPodval = infPodval;
    }

    public BigDecimal getItogoKOplate() {
        return this.itogoKOplate;
    }

    public void setItogoKOplate(BigDecimal itogoKOplate) {
        this.itogoKOplate = itogoKOplate;
    }

    public BigDecimal getCommission() {
        return this.commission;
    }

    public void setCommission(BigDecimal commission) {
        this.commission = commission;
    }

    public BigDecimal getNds20() {
        return this.nds20;
    }

    public void setNds20(BigDecimal nds20) {
        this.nds20 = nds20;
    }

    public BigDecimal getNds10() {
        return this.nds10;
    }

    public void setNds10(BigDecimal nds10) {
        this.nds10 = nds10;
    }

    public BigDecimal getBezNDS() {
        return this.bezNDS;
    }

    public void setBezNDS(BigDecimal bezNDS) {
        this.bezNDS = bezNDS;
    }

    public int getItogoKolvo() {
        return this.itogoKolvo;
    }

    public void setItogoKolvo(int itogoKolvo) {
        this.itogoKolvo = itogoKolvo;
    }

    public BigDecimal getItogoSum() {
        return this.itogoSum;
    }

    public void setItogoSum(BigDecimal itogoSum) {
        this.itogoSum = itogoSum;
    }

    public BigDecimal getItogoSumBezNal() {
        return this.itogoSumBezNal;
    }

    public void setItogoSumBezNal(BigDecimal itogoSumBezNal) {
        this.itogoSumBezNal = itogoSumBezNal;
    }

    public BigDecimal getItogoNDS() {
        return this.itogoNDS;
    }

    public void setItogoNDS(BigDecimal itogoNDS) {
        this.itogoNDS = itogoNDS;
    }

    public SbisInvoiceSupplier getSupplier() {
        return this.supplier;
    }

    public SbisInvoiceCustomer getCustomer() {
        return this.customer;
    }

    public List<SbisInvoiceTableRow> getRows() {
        return this.rows;
    }

    public NumberFormat getKolvoFormatter() {
        return this.kolvoFormatter;
    }

    public NumberFormat getPriceFormatter() {
        return this.priceFormatter;
    }

    public Map<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> getSbisDocumentElementsAttributes() {
        return this.sbisDocumentElementsAttributes;
    }

    @Override
    public String getFileName() {
        return this.fileId + ".xml";
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("\u0424\u0430\u0439\u043b");
        writer.writeAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute("\u0424\u043e\u0440\u043c\u0430\u0442", "\u042d\u0414\u041e\u0421\u0447");
        writer.writeAttribute("\u0412\u0435\u0440\u0441\u0438\u044f\u0424\u043e\u0440\u043c\u0430\u0442\u0430", "3.01");
        writer.writeAttribute("\u0418\u043c\u044f", this.fileId);
        writer.writeAttribute("\u041a\u043e\u0434\u0424\u043e\u0440\u043c\u044b", "\u041e\u041e\u041e \"\u0422\u0422-\u0422\u0440\u044d\u0432\u0435\u043b\"");
        writer.writeStartElement("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        writer.writeAttribute("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "\u0421\u0447\u0435\u0442 \u043d\u0430 \u043e\u043f\u043b\u0430\u0442\u0443");
        writer.writeAttribute("\u0412\u0440\u0435\u043c\u044f", SbisIntegrationHelper.timeFormat.format(this.date));
        writer.writeAttribute("\u0414\u0430\u0442\u0430", SbisIntegrationHelper.dateFormat.format(this.date));
        writer.writeAttribute("\u041d\u043e\u043c\u0435\u0440", this.number);
        this.supplier.toXML(writer);
        this.customer.toXML(writer);
        this.writeParam(writer, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0414\u0430\u0442\u0430", SbisIntegrationHelper.dateFormat.format(this.dogovorDate));
        this.writeParam(writer, "\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u041d\u043e\u043c\u0435\u0440", this.dogovorNumber);
        this.writeParam(writer, "\u0418\u043d\u0444\u041f\u043e\u0434\u0432\u0430\u043b", this.infPodval);
        this.writeParam(writer, "\u0412\u0441\u0435\u0433\u043e\u041a\u041e\u043f\u043b\u0430\u0442\u0435", this.priceFormatter.format(this.itogoKOplate));
        this.writeParam(writer, "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f", this.commissionFormatter.format(this.commission));
        this.writeParam(writer, "\u041d\u0414\u042120", this.priceFormatter.format(this.nds20));
        this.writeParam(writer, "\u041d\u0414\u042110", this.priceFormatter.format(this.nds10));
        this.writeParam(writer, "\u0411\u0435\u0437\u041d\u0414\u0421", this.priceFormatter.format(this.bezNDS));
        writer.writeStartElement("\u0422\u0430\u0431\u043b\u0414\u043e\u043a");
        writer.writeStartElement("\u0418\u0442\u043e\u0433\u0422\u0430\u0431\u043b");
        writer.writeAttribute("\u041a\u043e\u043b_\u0432\u043e", this.kolvoFormatter.format(this.itogoKolvo));
        writer.writeAttribute("\u0421\u0443\u043c\u043c\u0430", this.priceFormatter.format(this.itogoSum));
        writer.writeAttribute("\u0421\u0443\u043c\u043c\u0430\u0411\u0435\u0437\u041d\u0430\u043b", this.priceFormatter.format(this.itogoSumBezNal));
        writer.writeStartElement("\u041d\u0414\u0421");
        writer.writeAttribute("\u0421\u0443\u043c\u043c\u0430", this.priceFormatter.format(this.itogoNDS));
        writer.writeEndElement();
        writer.writeEndElement();
        for (SbisInvoiceTableRow row : this.rows) {
            row.toXML(writer);
        }
        writer.writeEndElement();
        HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute> sbisDocumentElementAttributes = this.sbisDocumentElementsAttributes.get(SbisIntegrationHelper.INF_POL_FHG_1);
        if (sbisDocumentElementAttributes != null && !sbisDocumentElementAttributes.isEmpty()) {
            writer.writeStartElement(SbisIntegrationHelper.INF_POL_FHG_1);
            for (SbisIntegrationHelper.SbisDocumentElementAttribute attribute : sbisDocumentElementAttributes) {
                this.writeTextInf(writer, attribute.getIdentifier(), attribute.getValue());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeParam(XMLStreamWriter writer, String paramName, String paramValue) throws XMLStreamException {
        writer.writeStartElement("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
        writer.writeAttribute("\u0418\u043c\u044f", paramName);
        writer.writeAttribute("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", paramValue);
        writer.writeEndElement();
    }

    private void writeTextInf(XMLStreamWriter writer, String id, String value) throws XMLStreamException {
        writer.writeStartElement("\u0422\u0435\u043a\u0441\u0442\u0418\u043d\u0444");
        writer.writeAttribute("\u0418\u0434\u0435\u043d\u0442\u0438\u0444", id);
        writer.writeAttribute("\u0417\u043d\u0430\u0447\u0435\u043d", value);
        writer.writeEndElement();
    }

    public static class SbisInvoiceSupplier
    implements SbisSerializable {
        private String addressText;
        private final String addressCodeStr = "643";
        private String bik;
        private String settlementAccount;
        private String bankName;
        private String correspondentAccount;
        private String phone;
        private String inn;
        private String kpp;
        private String name;
        private boolean individualEntrepreneur;

        public String getAddressText() {
            return this.addressText;
        }

        public void setAddressText(String addressText) {
            this.addressText = addressText;
        }

        public String getAddressCodeStr() {
            return "643";
        }

        public String getBik() {
            return this.bik;
        }

        public void setBik(String bik) {
            this.bik = bik;
        }

        public String getSettlementAccount() {
            return this.settlementAccount;
        }

        public void setSettlementAccount(String settlementAccount) {
            this.settlementAccount = settlementAccount;
        }

        public String getBankName() {
            return this.bankName;
        }

        public void setBankName(String bankName) {
            this.bankName = bankName;
        }

        public String getCorrespondentAccount() {
            return this.correspondentAccount;
        }

        public void setCorrespondentAccount(String correspondentAccount) {
            this.correspondentAccount = correspondentAccount;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getInn() {
            return this.inn;
        }

        public void setInn(String inn) {
            this.inn = inn;
        }

        public String getKpp() {
            return this.kpp;
        }

        public void setKpp(String kpp) {
            this.kpp = kpp;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isIndividualEntrepreneur() {
            return this.individualEntrepreneur;
        }

        public void setIndividualEntrepreneur(boolean individualEntrepreneur) {
            this.individualEntrepreneur = individualEntrepreneur;
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            writer.writeStartElement("\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a");
            writer.writeAttribute("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", this.name);
            writer.writeStartElement("\u0410\u0434\u0440\u0435\u0441");
            writer.writeAttribute("\u0410\u0434\u0440\u0422\u0435\u043a\u0441\u0442", this.addressText);
            writer.writeStartElement("\u0410\u0434\u0440\u0418\u043d\u043e");
            writer.writeAttribute("\u041a\u043e\u0434\u0421\u0442\u0440", "643");
            writer.writeAttribute("\u0410\u0434\u0440\u0422\u0435\u043a\u0441\u0442", this.addressText);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("\u0411\u0430\u043d\u043a\u0420\u0435\u043a\u0432");
            writer.writeAttribute("\u0411\u0418\u041a", this.bik);
            writer.writeAttribute("\u041a\u0421\u0447\u0435\u0442", this.correspondentAccount);
            writer.writeAttribute("\u041d\u0430\u0438\u043c\u0411\u0430\u043d\u043a", this.bankName);
            writer.writeAttribute("\u0420\u0421\u0447\u0435\u0442", this.settlementAccount);
            writer.writeEndElement();
            writer.writeStartElement("\u041a\u043e\u043d\u0442\u0430\u043a\u0442");
            writer.writeAttribute("\u0422\u0435\u043b\u0435\u0444\u043e\u043d", this.phone);
            writer.writeEndElement();
            if (this.isIndividualEntrepreneur()) {
                writer.writeStartElement("\u0421\u0432\u0418\u041f");
                writer.writeAttribute("\u0418\u041d\u041d\u0424\u041b", this.inn);
                writer.writeAttribute("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", this.name);
                writer.writeEndElement();
            } else {
                writer.writeStartElement("\u0421\u0432\u042e\u041b");
                writer.writeAttribute("\u0418\u041d\u041d", this.inn);
                writer.writeAttribute("\u041a\u041f\u041f", this.kpp);
                writer.writeAttribute("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", this.name);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    public static class SbisInvoiceCustomer
    implements SbisSerializable {
        private String addressText;
        private final String addressCodeStr = "643";
        private String phone;
        private String inn;
        private String kpp;
        private String name;
        private boolean individualEntrepreneur;

        public String getAddressText() {
            return this.addressText;
        }

        public void setAddressText(String addressText) {
            this.addressText = addressText;
        }

        public String getAddressCodeStr() {
            return "643";
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getInn() {
            return this.inn;
        }

        public void setInn(String inn) {
            this.inn = inn;
        }

        public String getKpp() {
            return this.kpp;
        }

        public void setKpp(String kpp) {
            this.kpp = kpp;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isIndividualEntrepreneur() {
            return this.individualEntrepreneur;
        }

        public void setIndividualEntrepreneur(boolean individualEntrepreneur) {
            this.individualEntrepreneur = individualEntrepreneur;
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            writer.writeStartElement("\u041f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044c");
            writer.writeAttribute("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", this.name);
            writer.writeStartElement("\u0410\u0434\u0440\u0435\u0441");
            writer.writeAttribute("\u0410\u0434\u0440\u0422\u0435\u043a\u0441\u0442", this.addressText);
            writer.writeStartElement("\u0410\u0434\u0440\u0418\u043d\u043e");
            writer.writeAttribute("\u041a\u043e\u0434\u0421\u0442\u0440", "643");
            writer.writeAttribute("\u0410\u0434\u0440\u0422\u0435\u043a\u0441\u0442", this.addressText);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("\u041a\u043e\u043d\u0442\u0430\u043a\u0442");
            if (!TextUtil.isBlank((String)this.phone)) {
                writer.writeAttribute("\u0422\u0435\u043b\u0435\u0444\u043e\u043d", this.phone);
            }
            writer.writeEndElement();
            if (this.isIndividualEntrepreneur()) {
                writer.writeStartElement("\u0421\u0432\u0424\u041b");
                writer.writeAttribute("\u0418\u041d\u041d", this.inn);
                writer.writeAttribute("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", this.name);
                writer.writeEndElement();
            } else {
                writer.writeStartElement("\u0421\u0432\u042e\u041b");
                writer.writeAttribute("\u0418\u041d\u041d", this.inn);
                writer.writeAttribute("\u041a\u041f\u041f", this.kpp);
                writer.writeAttribute("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", this.name);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    public static class SbisInvoiceTableRow
    implements SbisSerializable {
        private final NumberFormat kolvoFormatter;
        private final NumberFormat priceFormatter;
        private String name;
        private int kolvo;
        private final String edIzm = "\u0448\u0442";
        private final String okei = "600";
        private BigDecimal sum;
        private String code;
        private BigDecimal price;
        private String id;
        private int porNomer;
        private BigDecimal sumBezNal;
        private Integer nds;
        private Map<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> sbisDocumentElementsAttributes = new HashMap<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>>();

        public SbisInvoiceTableRow(NumberFormat kolvoFormatter, NumberFormat priceFormatter) {
            this.kolvoFormatter = kolvoFormatter;
            this.priceFormatter = priceFormatter;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getKolvo() {
            return this.kolvo;
        }

        public void setKolvo(int kolvo) {
            this.kolvo = kolvo;
        }

        public String getEdIzm() {
            return "\u0448\u0442";
        }

        public String getOkei() {
            return "600";
        }

        public BigDecimal getSum() {
            return this.sum;
        }

        public void setSum(BigDecimal sum) {
            this.sum = sum;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getPorNomer() {
            return this.porNomer;
        }

        public void setPorNomer(int porNomer) {
            this.porNomer = porNomer;
        }

        public BigDecimal getSumBezNal() {
            return this.sumBezNal;
        }

        public void setSumBezNal(BigDecimal sumBezNal) {
            this.sumBezNal = sumBezNal;
        }

        public Integer getNds() {
            return this.nds;
        }

        public void setNds(Integer nds) {
            this.nds = nds;
        }

        public Map<String, HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute>> getSbisDocumentElementsAttributes() {
            return this.sbisDocumentElementsAttributes;
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute> attributesInfPoleOpisRabot;
            writer.writeStartElement("\u0421\u0442\u0440\u0422\u0430\u0431\u043b");
            writer.writeAttribute("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", this.name);
            writer.writeAttribute("\u041a\u043e\u043b_\u0432\u043e", this.kolvoFormatter.format(this.kolvo));
            writer.writeAttribute("\u041a\u043e\u0434", this.code);
            writer.writeAttribute("\u0415\u0434\u0418\u0437\u043c", "\u0448\u0442");
            writer.writeAttribute("\u041e\u041a\u0415\u0418", "600");
            writer.writeAttribute("\u0421\u0443\u043c\u043c\u0430", this.priceFormatter.format(this.sum));
            writer.writeAttribute("\u0426\u0435\u043d\u0430", this.priceFormatter.format(this.price));
            writer.writeAttribute("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", this.id);
            writer.writeAttribute("\u041f\u043e\u0440\u041d\u043e\u043c\u0435\u0440", Integer.toString(this.porNomer));
            writer.writeAttribute("\u0421\u0443\u043c\u043c\u0430\u0411\u0435\u0437\u041d\u0430\u043b", this.priceFormatter.format(this.sumBezNal));
            writer.writeStartElement("\u0410\u043a\u0446\u0438\u0437");
            writer.writeAttribute("\u0421\u0443\u043c\u043c\u0430", "\u0431\u0435\u0437 \u0430\u043a\u0446\u0438\u0437\u0430");
            writer.writeEndElement();
            writer.writeStartElement("\u041d\u0414\u0421");
            writer.writeAttribute("\u0421\u0443\u043c\u043c\u0430", this.nds == null ? "" : this.priceFormatter.format(this.sum.subtract(this.sumBezNal)));
            writer.writeAttribute("\u0421\u0442\u0430\u0432\u043a\u0430", this.nds == null ? "\u0431\u0435\u0437 \u041d\u0414\u0421" : this.nds.toString());
            writer.writeAttribute("\u0422\u0438\u043f\u0421\u0442\u0430\u0432\u043a\u0438", this.nds == null ? "\u0442\u0435\u043a\u0441\u0442" : "\u043f\u0440\u043e\u0446\u0435\u043d\u0442");
            writer.writeEndElement();
            HashSet<SbisIntegrationHelper.SbisDocumentElementAttribute> attributesInfPolFhg2 = this.sbisDocumentElementsAttributes.get(SbisIntegrationHelper.INF_POL_FHG_2);
            if (attributesInfPolFhg2 != null) {
                for (SbisIntegrationHelper.SbisDocumentElementAttribute attribute : attributesInfPolFhg2) {
                    SbisIntegrationHelper.writeElement(attribute.getIdentifier(), attribute.getValue(), SbisIntegrationHelper.INF_POL_FHG_2, writer);
                }
            }
            if ((attributesInfPoleOpisRabot = this.sbisDocumentElementsAttributes.get(SbisIntegrationHelper.INF_POLE_OPIS_RABOT)) != null) {
                for (SbisIntegrationHelper.SbisDocumentElementAttribute attribute : attributesInfPoleOpisRabot) {
                    SbisIntegrationHelper.writeElement(attribute.getIdentifier(), attribute.getValue(), SbisIntegrationHelper.INF_POLE_OPIS_RABOT, writer);
                }
            }
            writer.writeEndElement();
        }
    }
}

