/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis.model;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisFile;
import com.gridnine.xtrip.server.ibecorp.ibus.sbis.model.SbisSerializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;

public class SbisServiceFile
implements SbisFile {
    private String fileName;
    private String documentUid;
    private final List<SbisDocumentsAttachment> attachments = new ArrayList<SbisDocumentsAttachment>();
    private SbisDocumentsLegalEntity organization;
    private SbisDocumentsLegalEntity contragent;

    public String getDocumentUid() {
        return this.documentUid;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setDocumentUid(String documentUid) {
        this.documentUid = documentUid;
    }

    public List<SbisDocumentsAttachment> getAttachments() {
        return this.attachments;
    }

    public SbisDocumentsLegalEntity getOrganization() {
        return this.organization;
    }

    public void setOrganization(SbisDocumentsLegalEntity organization) {
        this.organization = organization;
    }

    public SbisDocumentsLegalEntity getContragent() {
        return this.contragent;
    }

    public void setContragent(SbisDocumentsLegalEntity contragent) {
        this.contragent = contragent;
    }

    @Override
    public void toXML(XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("\u0421\u043f\u0438\u0441\u043e\u043a\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        writer.writeStartElement("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        writer.writeAttribute("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", this.getDocumentUid());
        writer.writeStartElement("\u0421\u043f\u0438\u0441\u043e\u043a\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u0435");
        for (SbisDocumentsAttachment att : this.attachments) {
            writer.writeStartElement("\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u0435");
            att.toXML(writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement("\u041a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442");
        if (TextUtil.nonBlank((String)this.contragent.getCustomerIdentifier())) {
            writer.writeAttribute("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", this.contragent.getCustomerIdentifier());
        }
        this.contragent.toXML(writer);
        writer.writeEndElement();
        writer.writeStartElement("\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f");
        this.organization.toXML(writer);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public static class SbisDocumentsAttachment
    implements SbisSerializable {
        private String fileName;
        private String path;

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            writer.writeStartElement("\u0424\u0430\u0439\u043b");
            writer.writeAttribute("\u0418\u043c\u044f", this.fileName);
            writer.writeAttribute("\u0421\u0441\u044b\u043b\u043a\u0430\u041d\u0430\u0424\u0430\u0439\u043b", this.path);
            writer.writeEndElement();
        }
    }

    public static class SbisDocumentsLegalEntity
    implements SbisSerializable {
        private String inn;
        private String kpp;
        private boolean individualEntrepreneur;
        private String customerCode;
        private String customerIdentifier;

        public String getInn() {
            return this.inn;
        }

        public void setInn(String inn) {
            this.inn = inn;
        }

        public String getKpp() {
            return this.kpp;
        }

        public void setKpp(String kpp) {
            this.kpp = kpp;
        }

        public boolean isIndividualEntrepreneur() {
            return this.individualEntrepreneur;
        }

        public void setIndividualEntrepreneur(boolean individualEntrepreneur) {
            this.individualEntrepreneur = individualEntrepreneur;
        }

        public String getCustomerCode() {
            return this.customerCode;
        }

        public void setCustomerCode(String customerCode) {
            this.customerCode = customerCode;
        }

        public String getCustomerIdentifier() {
            return this.customerIdentifier;
        }

        public void setCustomerIdentifier(String customerIdentifier) {
            this.customerIdentifier = customerIdentifier;
        }

        @Override
        public void toXML(XMLStreamWriter writer) throws Exception {
            if (this.isIndividualEntrepreneur()) {
                writer.writeStartElement("\u0421\u0432\u0418\u041f");
                writer.writeAttribute("\u0418\u041d\u041d\u0424\u041b", this.inn);
                writer.writeEndElement();
            } else {
                writer.writeStartElement("\u0421\u0432\u042e\u041b");
                writer.writeAttribute("\u0418\u041d\u041d", this.inn);
                writer.writeAttribute("\u041a\u041f\u041f", this.kpp);
                if (TextUtil.nonBlank((String)this.customerCode)) {
                    writer.writeAttribute("\u041a\u043e\u0434\u0424\u0438\u043b\u0438\u0430\u043b\u0430", this.customerCode);
                }
                writer.writeEndElement();
            }
        }
    }
}

