/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.sbis.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

abstract class SbisBaseEscapingCharacterWriter
extends Writer {
    private Writer m_writer;

    public SbisBaseEscapingCharacterWriter(Writer writer, String encoding) {
        this.m_writer = writer;
    }

    public SbisBaseEscapingCharacterWriter(OutputStream os, String encoding) {
        Charset charset = Charset.forName(encoding);
        this.m_writer = new OutputStreamWriter(os, charset);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int strlen = str.length();
        if (off + len > strlen) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < str.length(); ++i) {
            this.write(str.charAt(i));
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int bufsize = cbuf.length;
        if (off + len > bufsize) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = off; i < len; ++i) {
            this.write(cbuf[i]);
        }
    }

    public void write(char b) throws IOException {
        if (b > '\u00ff') {
            this.m_writer.write(b);
            return;
        }
        this.writeEscapedChar(this.m_writer, b);
    }

    protected abstract void writeEscapedChar(Writer var1, char var2) throws IOException;

    @Override
    public void close() throws IOException {
        this.m_writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.m_writer.flush();
    }
}

