/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalService;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.transfers.TransferPointMiscData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.model.hotels.rest.RestHotelsOfferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BAuthInterceptor;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.ApprovalHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.IBusApprovalContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.avia.B2BCreateBookingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.AviaApproveIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.AviaSelectIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.HotelApproveIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.HotelSelectIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.RailApproveIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.RailSelectIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.SelectIntentionResult;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.TransferApproveIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.booking.TransferSelectIntentionData;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.CreateIntentionParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.HotelOffer;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.hotels.RoomInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.BookingRouteInfo;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.Carriage;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.CarriageWithReasonCodeConfiguration;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.rail.PricingParameters;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.PassengersTypes;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTransfer;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTransferToken;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.RestTrip;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.TransferTraveller;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.TripPointParams;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.rail.RestRailHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.RestTraveller;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.CreateBookingResult;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.booking.ApproveIntentionParameters;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.autoticketing.IBusAuthorizationContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CreateApproveIntentionParameters
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SelectIntentionResult afterSelect = (SelectIntentionResult)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_RESULT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        String acceptProductDuplicatesMessageId = (String)ctx.getObject((Enum)IBusAuthorizationContextKeys.ACCEPT_PRODUCT_DUPLICATES_MESSAGE_ID);
        EntityReference bfRef = afterSelect.getBooking();
        BookingFile bf = (BookingFile)EntityStorage.get().resolve(bfRef).getEntity();
        HotelSelectIntentionData hotelData = afterSelect.getHotelData();
        RailSelectIntentionData railData = afterSelect.getRailData();
        AviaSelectIntentionData aviaData = afterSelect.getAviaData();
        TransferSelectIntentionData transferData = afterSelect.getTransferData();
        ApproveIntentionParameters parameters = new ApproveIntentionParameters();
        parameters.setReservationUid(afterSelect.getReservationUid());
        parameters.setCurrentBooking(afterSelect.getBooking());
        if (hotelData != null) {
            this.initHotelParameters(hotelData, parameters, bf, reservation, acceptProductDuplicatesMessageId);
        } else if (railData != null) {
            this.initRailParameters(railData, parameters, bf, reservation, acceptProductDuplicatesMessageId);
        } else if (aviaData != null) {
            this.initAviaParameters(aviaData, parameters, bf, reservation, acceptProductDuplicatesMessageId);
            ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)new CreateBookingResult());
        } else if (transferData != null) {
            this.initTransferParameters(transferData, parameters, bf, reservation, acceptProductDuplicatesMessageId);
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_PARAMS, (Object)parameters);
        ctx.putObject((Enum)IBusApprovalContextKeys.APPROVAL_INTENTION_DATA, (Object)parameters);
        ctx.putObject((Enum)IBusIbecorpContextKeys.CURRENT_ORGANIZATION, B2BAuthInterceptor.defineCurrentOrganization((EntityContainer<Person>)EntityStorage.get().resolve(salesContext.getAgent())));
    }

    private void initHotelParameters(HotelSelectIntentionData hotelData, ApproveIntentionParameters parameters, BookingFile bf, Reservation reservation, String acceptProductDuplicatesMessageId) {
        HotelApproveIntentionData hotelApproveData = new HotelApproveIntentionData();
        CreateIntentionParameters createIntentionParameters = new CreateIntentionParameters();
        hotelApproveData.setCreateParameters(createIntentionParameters);
        List<HotelProduct> products = BookingStreamHelper.getProductsStream((Reservation)reservation, HotelProduct.class).collect(Collectors.toList());
        List hotelOffers = hotelData.getHotelCard().getHotelOffers();
        if (products.size() != hotelOffers.size()) {
            throw Xeption.forDeveloper((String)"products number {0} != offers number {1}", (Object[])new Object[]{products.size(), hotelOffers.size()});
        }
        for (HotelOffer hotelOffer : hotelOffers) {
            RoomInfo roomInfo = new RoomInfo();
            roomInfo.setOffer(hotelOffer);
            RestHotelsOfferToken token = CommonRestHelper.decodeToken(hotelOffer.getToken(), RestHotelsOfferToken.class);
            HotelProduct product = ApprovalHelper.findHotelProductByOffer(products, token.getOffer());
            products.remove(product);
            List restTravellers = product.getTravellers().stream().map(traveller -> HotelsConverterHelper.convertTravellerToRest(traveller, reservation)).collect(Collectors.toList());
            roomInfo.getTravellers().addAll(restTravellers);
            createIntentionParameters.getRooms().add(roomInfo);
        }
        createIntentionParameters.setCustomer(CommonConverterHelper.convertCustomer2Rest(bf.getCustomer()));
        createIntentionParameters.setKeyContact(bf.getCustomer().getKeyContact() == null ? null : bf.getCustomer().getKeyContact().getProfile());
        createIntentionParameters.setReasonCode(CommonConverterHelper.convertReasonCode2Rest(reservation.getReasonCode()));
        createIntentionParameters.setAcceptSecurityRules(true);
        createIntentionParameters.setAcceptProductDuplicatesMessageId(acceptProductDuplicatesMessageId);
        parameters.setHotelData(hotelApproveData);
    }

    private void initRailParameters(RailSelectIntentionData railData, ApproveIntentionParameters parameters, BookingFile bf, Reservation reservation, String acceptProductDuplicatesMessageId) {
        RailApproveIntentionData railApproveData = new RailApproveIntentionData();
        PricingParameters pricingParameters = new PricingParameters();
        railApproveData.setCreateParameters(pricingParameters);
        pricingParameters.setKeyContact(bf.getCustomer().getKeyContact() == null ? null : bf.getCustomer().getKeyContact().getProfile());
        pricingParameters.setReasonCode(CommonConverterHelper.convertReasonCode2Rest(reservation.getReasonCode()));
        pricingParameters.setCustomer(CommonConverterHelper.convertCustomer2Rest(bf.getCustomer()));
        pricingParameters.getTravellers().addAll(RestRailHelper.convertTravellers2Rest(reservation));
        BookingRouteInfo routeInfo = new BookingRouteInfo();
        routeInfo.setTrain(railData.getTrain());
        routeInfo.setSeatsRequest(railData.getClientPreferences().getSeatsRequest());
        routeInfo.setCarriage(CreateApproveIntentionParameters.convert2RestCarriage(reservation, railData.getCarriages()));
        RailwayProduct firstProduct = RzdCommonHelper.getProduct((Reservation)reservation);
        if (firstProduct.getStatisticalData() != null) {
            routeInfo.getCarriage().setMinPrice(firstProduct.getStatisticalData().getMinPriceRailway());
        }
        pricingParameters.setRouteInfo(routeInfo);
        pricingParameters.setAcceptSecurityRules(true);
        pricingParameters.setAcceptProductDuplicatesMessageId(acceptProductDuplicatesMessageId);
        parameters.setRailData(railApproveData);
    }

    private static Carriage convert2RestCarriage(Reservation reservation, List<CarriageWithReasonCodeConfiguration> carriages) {
        RailwaySegment segment = RzdCommonHelper.getSegment((Reservation)reservation);
        return (Carriage)carriages.stream().filter(Objects::nonNull).filter(c -> MiscUtil.equals((Object)c.getNumber(), (Object)segment.getCarriageNumber())).filter(c -> MiscUtil.equals((Object)c.getGdsServiceClass(), (Object)segment.getServiceClass())).findFirst().orElseThrow(() -> {
            Xeption ex = Xeption.forDeveloper((String)"can't find carriage with number {0} and service class {1}", (Object[])new Object[]{segment.getCarriageNumber(), EnumUtil.nameOf((Enum)segment.getServiceClass())});
            IncidentsHelper.addStackTraceElement((Throwable)ex, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"Carriages", (String)carriages.stream().map(c -> String.join((CharSequence)"-", c.getNumber(), EnumUtil.nameOf((Enum)c.getGdsServiceClass()))).collect(Collectors.joining("; ")))});
            return ex;
        });
    }

    private void initAviaParameters(AviaSelectIntentionData aviaData, ApproveIntentionParameters parameters, BookingFile bf, Reservation reservation, String acceptProductDuplicatesMessageId) {
        AviaApproveIntentionData aviaApproveData = new AviaApproveIntentionData();
        B2BCreateBookingParameters createParameters = new B2BCreateBookingParameters();
        aviaApproveData.setCreateParameters(createParameters);
        createParameters.setKeyContact(bf.getCustomer().getKeyContact() == null ? null : bf.getCustomer().getKeyContact().getProfile());
        createParameters.setReasonCode(CommonConverterHelper.convertReasonCode2Rest(reservation.getReasonCode()));
        createParameters.setCustomer(CommonConverterHelper.convertCustomer2Rest(bf.getCustomer()));
        createParameters.setFlightToken(aviaData.getSelectFlight().getFlightToken());
        createParameters.getPassengers().addAll(AviaConverterHelper.convertTravellers2Rest(reservation));
        createParameters.setDkNumber(bf.getDkNumber());
        createParameters.setAcceptAllRules(true);
        createParameters.setAcceptBookingRules(true);
        createParameters.setAcceptFareRemarks(true);
        createParameters.setAcceptIataRules(true);
        createParameters.setAcceptSecurityRules(true);
        createParameters.setIgnoreMeal(false);
        createParameters.setAcceptProductDuplicatesMessageId(acceptProductDuplicatesMessageId);
        parameters.setAviaData(aviaApproveData);
    }

    private void initTransferParameters(TransferSelectIntentionData transferData, ApproveIntentionParameters parameters, BookingFile bf, Reservation reservation, String acceptProductDuplicatesMessageId) throws Exception {
        Transfer product = (Transfer)reservation.getProducts().get(0);
        RestTransfer restTransfer = transferData.getTransfer();
        TransferApproveIntentionData transferApproveData = new TransferApproveIntentionData();
        com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.PricingParameters pricingParameters = new com.gridnine.xtrip.server.ibecorp.b2b.rest.model.transfers.PricingParameters();
        transferApproveData.setCreateParameters(pricingParameters);
        pricingParameters.setKeyContact(bf.getCustomer().getKeyContact() == null ? null : bf.getCustomer().getKeyContact().getProfile());
        pricingParameters.setReasonCode(CommonConverterHelper.convertReasonCode2Rest(reservation.getReasonCode()));
        pricingParameters.setCustomer(CommonConverterHelper.convertCustomer2Rest(bf.getCustomer()));
        CommonHelper.collectTravellers(reservation).stream().filter(Objects::nonNull).map(traveller -> CreateApproveIntentionParameters.convertTraveller2Rest(traveller, reservation)).forEach(pricingParameters.getTravellers()::add);
        pricingParameters.setFlexibleTariff(restTransfer.isFlexibleTariff());
        pricingParameters.setFlexibleTariffAgreement(restTransfer.isFlexibleTariffAgreement());
        pricingParameters.setNotes(product.getNotes());
        PassengersTypes passengerTypes = new PassengersTypes();
        passengerTypes.setADULT(restTransfer.getAdult());
        passengerTypes.setCHILD(restTransfer.getChild());
        pricingParameters.setPassengersTypes(passengerTypes);
        RestTrip restTrip = new RestTrip();
        restTrip.setStart(this.buildTripPointParams(product.getStartDate(), product.getStartMiscData()));
        restTrip.setEnd(this.buildTripPointParams(product.getEndDate(), product.getEndMiscData()));
        restTrip.setTableCaption(product.getTableCaption());
        product.getAdditionalServices().stream().map(AdditionalService::getType).forEach(restTrip.getAdditionalServiceTypes()::add);
        pricingParameters.getTrips().add(restTrip);
        pricingParameters.setTravellersCount(product.getPassengersCount().intValue());
        RestTransferToken transferToken = CommonRestHelper.decodeToken(restTransfer.getToken(), RestTransferToken.class);
        transferToken.getSearchResponse().getTo().getAvailableAdditionalServices().addAll(product.getAdditionalServices());
        pricingParameters.setTransferToken(CommonRestHelper.encodeToken((BaseEntity)transferToken));
        pricingParameters.setAcceptSecurityRules(true);
        pricingParameters.setAcceptProductDuplicatesMessageId(acceptProductDuplicatesMessageId);
        parameters.setTransferData(transferApproveData);
    }

    private TripPointParams buildTripPointParams(Date date, TransferPointMiscData miscData) {
        TripPointParams result = new TripPointParams();
        result.setTime(DateUtils.toLocalDateTime((Date)date));
        if (miscData != null) {
            result.setTerminalNumber(miscData.getTerminal());
            result.setFlightNumber(miscData.getFlightNumber());
            result.setTrainNumber(miscData.getTrainNumber());
            result.setTrainCarriageNumber(miscData.getTrainCarriageNumber());
        }
        return result;
    }

    private static TransferTraveller convertTraveller2Rest(Traveller traveller, Reservation reservation) {
        TransferTraveller restTraveller = new TransferTraveller();
        CommonConverterHelper.updateRestTraveller((RestTraveller)restTraveller, traveller);
        restTraveller.getCostCodes().addAll(CommonConverterHelper.convertCostCodesToRest(reservation, traveller));
        return restTraveller;
    }
}

