/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.tasks.syncIm;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.IBusIMContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.railway.im.model.response.IMOrderListResp;
import com.gridnine.xtrip.server.ibecorp.ibus.tasks.IbecorpTasksHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SyncImBookingFilesProvider
extends BaseTargetsProvider<EntityReference<BookingFile>> {
    public Collection<EntityReference<BookingFile>> getTargets(MessageContext ctx) throws Exception {
        LongRunningTaskCallback callback = (LongRunningTaskCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK);
        IMOrderListResp response = (IMOrderListResp)ctx.getMandatoryObject((Enum)IBusIMContextKeys.IM_RESPONSE_DATA);
        Set imPnrs = response.getOrders().stream().flatMap(order -> order.getOrderItems().stream()).map(item -> item.getOrderId()).collect(Collectors.toSet());
        IbecorpTasksHelper.addMessageToCallback(callback, "\u0418\u041c \u0432\u0435\u0440\u043d\u0443\u043b {0} \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439", imPnrs.size());
        if (imPnrs.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet foundedPnrs = new HashSet();
        HashSet<EntityReference<BookingFile>> bookingFiles = new HashSet<EntityReference<BookingFile>>();
        SearchQuery query = new SearchQuery();
        List criterions = query.getCriteria().getCriterions();
        criterions.add(SearchCriterion.contains((String)RailwayProductIndex.Property.gdsNames.name(), (Object)GdsName.INMOB));
        ArrayList<SearchCriterion> orCriterions = new ArrayList<SearchCriterion>();
        for (String pnr : imPnrs) {
            orCriterions.add(SearchCriterion.ilike((String)RailwayProductIndex.Property.recordLocators.name(), (String)("%" + pnr + "%")));
        }
        criterions.add(SearchQueryHelper.toOrCriterion(orCriterions));
        query.getPreferredProperties().add(RailwayProductIndex.Property.bookingNumber.name());
        query.getPreferredProperties().add(RailwayProductIndex.Property.recordLocators.name());
        query.getPreferredProperties().add(RailwayProductIndex.Property.status.name());
        query.getPreferredProperties().add(RailwayProductIndex.Property.nextProductUid.name());
        EntityStorage.get().search(RailwayProductIndex.class, query).getData().stream().peek(idx -> foundedPnrs.addAll(com.gridnine.xtrip.common.model.helpers.SearchQueryHelper.getRecordLocatorsFromIndexRecords((List)idx.getRecordLocators(), (GdsName)GdsName.INMOB, (RecordLocatorType)RecordLocatorType.DEFAULT))).filter(idx -> idx.getStatus() == ProductStatus.SELL && TextUtil.isBlank((String)idx.getNextProductUid())).map(RailwayProductIndex::getSource).forEach(bookingFiles::add);
        query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)RailwayProductIndex.Property.gdsName.name(), (Object)GdsName.INMOB));
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)RailwayProductIndex.Property.recordLocator.name(), (Object[])imPnrs.toArray()));
        query.getPreferredProperties().add(RailwayProductIndex.Property.bookingNumber.name());
        query.getPreferredProperties().add(RailwayProductIndex.Property.recordLocator.name());
        query.getPreferredProperties().add(RailwayProductIndex.Property.status.name());
        query.getPreferredProperties().add(RailwayProductIndex.Property.nextProductUid.name());
        EntityStorage.get().search(RailwayProductIndex.class, query).getData().stream().peek(idx -> foundedPnrs.add(idx.getRecordLocator())).filter(idx -> idx.getStatus() == ProductStatus.SELL && TextUtil.isBlank((String)idx.getNextProductUid())).map(RailwayProductIndex::getSource).forEach(bookingFiles::add);
        IbecorpTasksHelper.addMessageToCallback(callback, "\u041d\u0430\u0439\u0434\u0435\u043d\u043e {0} \u0437\u0430\u043a\u0430\u0437\u043e\u0432", bookingFiles.size());
        if (foundedPnrs.size() < imPnrs.size()) {
            imPnrs.removeAll(foundedPnrs);
            IbecorpTasksHelper.addWarningToCallback(callback, "\u0412 \u041c\u041e\u041c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e {0} \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0439: {1}", imPnrs.size(), imPnrs);
        }
        return bookingFiles;
    }
}

