/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyProductImpositionResults;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsActionSet;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.FakeHotelProductHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.hotels.HotelsConverterHelper;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.IbecorpHotelPropertySetContext;
import com.gridnine.xtrip.server.ibecorp.ibus.hotels.vendorCommission.VendorCommissionHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.HotelActionSet;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySet;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySetContext;
import com.gridnine.xtrip.server.model.handlers.rules.RulesCache;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import com.gridnine.xtrip.server.model.helpers.CommonProductHelper;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ApplyRulesToHotelCardsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List<HotelCard> hotelCardList = HotelsConverterHelper.getHotelCards(ctx, false);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        TravelPolicyProductImpositionResults travelPolicyResults = (TravelPolicyProductImpositionResults)ctx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PRODUCT_IMPOSITION_RESULTS);
        Map travellersCostCodes = (Map)ctx.getObject((Enum)IBusIbecorpContextKeys.TRAVELLERS_COST_CODES);
        EntityContainer<BookingFile> bfCtr = this.buildBookingFile(salesContext);
        Reservation reservation = (Reservation)((BookingFile)bfCtr.getEntity()).getReservations().get(0);
        hotelCardList.stream().map(HotelCard::getHotelOffers).flatMap(Collection::stream).findFirst().ifPresent(firstOffer -> reservation.getGdsNameInfo().setOnlineGdsAccount(firstOffer.getGdsAccount()));
        HashMap<HotelProduct, MiscUtil.Pair<HotelOffer, EntityReference<Contract>>> map = new HashMap<HotelProduct, MiscUtil.Pair<HotelOffer, EntityReference<Contract>>>();
        HashMap<HotelOffer, HotelOffer> maxPriceOffersMap = new HashMap<HotelOffer, HotelOffer>();
        HashMap rulesCacheMap = new HashMap();
        HotelRulesHandler hotelRulesHandler = HotelRulesHelper.getHotelRulesHandler();
        IbecorpHotelPropertySetContext propertySetContext = null;
        for (HotelCard hc : hotelCardList) {
            for (HotelOffer offer : hc.getHotelOffers()) {
                HotelProduct product = FakeHotelProductHelper.buildFakeHotelProduct((HotelOffer)offer, (Reservation)reservation, (HotelCard)hc, (SalesContext)salesContext, (Map)travellersCostCodes);
                if (propertySetContext == null) {
                    propertySetContext = (IbecorpHotelPropertySetContext)hotelRulesHandler.createPropertySetContext(product);
                }
                if (travelPolicyResults != null) {
                    offer.setTravelPolicyImpositionResult(new TravelPolicyImpositionResult());
                    travelPolicyResults.getProduct2Result().put(product, offer.getTravelPolicyImpositionResult());
                }
                RuleProxy<HotelPropertySet, HotelProductSettingsActionSet> ruleProxy = this.applyHotelProductSettingsRules(product, propertySetContext);
                map.put(product, new MiscUtil.Pair((Object)offer, (Object)((HotelProductSettingsActionSet)ruleProxy.getActionSet()).getVendorContract()));
                rulesCacheMap.put((BaseProduct)product, this.createRulesCache((HotelPropertySet)ruleProxy.getPropertySet()));
                if (offer.getMaxPrice() == null) continue;
                HotelOffer maxPriceOffer = (HotelOffer)XCloneHelper.clone((XCloneable)offer, (boolean)true);
                maxPriceOffer.setBasePrice(MoneyHelper.buildMoney((BigDecimal)offer.getMaxPrice(), (String)offer.getBasePrice().getCurrency()));
                HotelProduct maxPriceProduct = FakeHotelProductHelper.buildFakeHotelProduct((HotelOffer)maxPriceOffer, (Reservation)reservation, (HotelCard)hc, (SalesContext)salesContext, (Map)travellersCostCodes);
                RuleProxy<HotelPropertySet, HotelProductSettingsActionSet> maxPriceProductRuleProxy = this.applyHotelProductSettingsRules(maxPriceProduct, propertySetContext);
                maxPriceOffersMap.put(maxPriceOffer, offer);
                map.put(maxPriceProduct, (MiscUtil.Pair<HotelOffer, EntityReference<Contract>>)new MiscUtil.Pair((Object)maxPriceOffer, (Object)((HotelProductSettingsActionSet)maxPriceProductRuleProxy.getActionSet()).getVendorContract()));
                rulesCacheMap.put((BaseProduct)maxPriceProduct, this.createRulesCache((HotelPropertySet)maxPriceProductRuleProxy.getPropertySet()));
            }
        }
        if (map.isEmpty()) {
            return;
        }
        HotelProduct firstProduct = (HotelProduct)CollectionUtil.head(map.keySet());
        List newClientContracts = HotelRulesHelper.getContracts((HotelProduct)firstProduct, (ContractType)ContractType.CLIENT, null, Collections.emptyMap(), null, new ArrayList());
        List clientContracts = newClientContracts.isEmpty() ? HotelRulesHelper.getOldContracts((HotelProduct)firstProduct, (ContractType)ContractType.CLIENT, new ArrayList()) : newClientContracts;
        HashMap vendorContractMap = new HashMap();
        HashMap<HotelRulesHelper.ContractKey, List<EntityContainer<Contract>>> contractMap = new HashMap<HotelRulesHelper.ContractKey, List<EntityContainer<Contract>>>();
        HotelRulesHelper.ContractKey contractKey = new HotelRulesHelper.ContractKey();
        EntityStorageContext storageContext = new EntityStorageContext();
        for (Map.Entry entry : map.entrySet()) {
            HotelProduct product = (HotelProduct)entry.getKey();
            HotelOffer offer = (HotelOffer)((MiscUtil.Pair)entry.getValue()).getFirst();
            EntityReference hpSettingsVendorContract = (EntityReference)((MiscUtil.Pair)entry.getValue()).getSecond();
            RulesCache rulesCache = (RulesCache)rulesCacheMap.get(product);
            this.setSubagency(product, offer, hotelRulesHandler, clientContracts, contractMap, contractKey, (RulesCache<HotelPropertySet>)rulesCache);
            EntityContainer vendorContract = Optional.ofNullable(EntityStorageHelper.resolve((EntityReference)hpSettingsVendorContract, (EntityStorageContext)storageContext)).orElseGet(() -> vendorContractMap.computeIfAbsent(product.getProvider(), provider -> com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelRulesHelper.getVendorContract((HotelProduct)product, new ArrayList())));
            rulesCache.getContracts().put(ContractType.CLIENT, newClientContracts);
            rulesCache.getContracts().put(ContractType.VENDOR, vendorContract != null ? Collections.singletonList(vendorContract) : Collections.emptyList());
        }
        VendorCommissionHelper.preprocess(reservation.getProducts(), rulesCacheMap, map, null);
        RulesHelper.applyRules(bfCtr, rulesCacheMap, (boolean)true, (boolean)true, new ArrayList(), (boolean)false);
        ((BookingFile)bfCtr.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream().filter(baseProd -> baseProd instanceof HotelProduct)).forEach(baseProd -> {
            HotelOffer offer = (HotelOffer)((MiscUtil.Pair)map.get(baseProd)).getFirst();
            if (offer == null) {
                return;
            }
            offer.getContractRelations().clear();
            offer.getContractRelations().addAll(GeneralProductHelper.getHandler((BaseProduct)baseProd).getUnmodifiableContractRelations(baseProd));
            HotelOffer originalOffer = (HotelOffer)maxPriceOffersMap.get(offer);
            if (originalOffer == null) {
                return;
            }
            XtripPriceStructure offerPS = XtripPriceStructureHelper.calculatePriceStructure((List)offer.getContractRelations(), (boolean)true, null);
            originalOffer.setTotalMaxPrice(offerPS.getTotal());
        });
    }

    private RulesCache<HotelPropertySet> createRulesCache(HotelPropertySet propertySet) {
        RulesCache rulesCache = new RulesCache();
        rulesCache.setPropertySet((Object)propertySet);
        return rulesCache;
    }

    private RuleProxy<HotelPropertySet, HotelProductSettingsActionSet> applyHotelProductSettingsRules(HotelProduct product, IbecorpHotelPropertySetContext propertySetContext) throws Exception {
        RuleProxy ruleProxy = HotelRulesHelper.applyHotelProductSettingsRules((HotelProduct)product, (HotelPropertySetContext)propertySetContext);
        HotelsHelper.fillContractData((HotelProduct)product, (HotelProductSettingsActionSet)((HotelProductSettingsActionSet)ruleProxy.getActionSet()));
        EntityReference supplier = HotelProductHelper.getSupplier((HotelProduct)product);
        if (supplier != null) {
            ((HotelPropertySet)ruleProxy.getPropertySet()).setSupplierUid(supplier.getUid());
        }
        return ruleProxy;
    }

    private void setSubagency(HotelProduct product, HotelOffer offer, HotelRulesHandler hotelRulesHandler, List<EntityContainer<Contract>> clientContracts, Map<HotelRulesHelper.ContractKey, List<EntityContainer<Contract>>> contractMap, HotelRulesHelper.ContractKey contractKey, RulesCache<HotelPropertySet> rulesCache) {
        RuleProxy ruleProxy = HotelRulesHelper.createRuleProxy((HotelProduct)product, (HotelPropertySet)((HotelPropertySet)rulesCache.getPropertySet()), (HotelRulesHandler)hotelRulesHandler);
        HotelRulesHelper.applyContracts((HotelProduct)product, (RuleProxy)ruleProxy, clientContracts, new ArrayList());
        EntityReference subagency = ((HotelActionSet)ruleProxy.getActionSet()).getSubagency();
        if (subagency != null) {
            offer.setSubagency(subagency);
            HotelProductHelper.setSubagency((HotelProduct)product, (EntityReference)subagency);
            ((HotelPropertySet)rulesCache.getPropertySet()).setSubagency(subagency);
            ((HotelPropertySet)rulesCache.getPropertySet()).getSubagencyCodes().clear();
            CommonProductHelper.addSubagencyCodes((Set)((HotelPropertySet)rulesCache.getPropertySet()).getSubagencyCodes(), (EntityReference)subagency);
            rulesCache.getContracts().put(ContractType.SUBAGENCY, HotelRulesHelper.getContracts((HotelProduct)product, (ContractType)ContractType.SUBAGENCY, (HotelRulesHelper.ContractKey)contractKey, contractMap, (Object)rulesCache.getPropertySet(), new ArrayList()));
        }
    }

    private EntityContainer<BookingFile> buildBookingFile(SalesContext salesContext) {
        BookingFile bf = new BookingFile();
        bf.setAgency(salesContext.getAgency());
        bf.setCustomerProfile(salesContext.getClient());
        bf.setCreateDate(new Date());
        bf.setAgency(salesContext.getAgency());
        bf.setCustomerProfile(salesContext.getClient());
        bf.setSite(salesContext.getSite());
        if (salesContext.getCustomer() != null) {
            Customer customer = bf.getCustomer();
            customer.setProfile(salesContext.getCustomer());
        }
        Reservation res = new Reservation();
        res.getGdsNameInfo().setRulesGdsName(GdsName.HOTEL_AGGREGATOR);
        res.setResDate(new Date());
        res.setType(ReservationType.IBE);
        BookingHelper.addReservation((BookingFile)bf, (Reservation)res);
        SalesContextHandler.get().enforceSalesContext(salesContext, res);
        return EntityContainer.create((BaseEntity)bf);
    }
}

