/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyProductImpositionResults;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.transfers.SearchGdsResponse;
import com.gridnine.xtrip.server.transfers.ibus.IBusTransfersContextKeys;
import java.util.List;

public class ApplyRulesToTransfersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        TravelPolicyProductImpositionResults travelPolicyResults = (TravelPolicyProductImpositionResults)ctx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PRODUCT_IMPOSITION_RESULTS);
        if (travelPolicyResults != null) {
            TravelPolicyParameters travelPolicyParams = (TravelPolicyParameters)ctx.getMandatoryObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS);
            EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
            BookingFile bookingFile = (BookingFile)bookingFileCtr.getEntity();
            List response = (List)ctx.getMandatoryObject((Enum)IBusTransfersContextKeys.TRANSFERS_SEARCH_RESPONSE);
            response.forEach(sr -> {
                this.populateTravelPolicyResults(travelPolicyResults, bookingFile, sr.getTo(), travelPolicyParams);
                this.populateTravelPolicyResults(travelPolicyResults, bookingFile, sr.getFrom(), travelPolicyParams);
            });
        }
    }

    private void populateTravelPolicyResults(TravelPolicyProductImpositionResults travelPolicyResults, BookingFile bookingFile, SearchGdsResponse searchGdsResponse, TravelPolicyParameters travelPolicyParams) {
        Reservation reservation;
        if (searchGdsResponse != null && (reservation = BookingHelper.findReservationByUid((BookingFile)bookingFile, (String)searchGdsResponse.getUid())) != null) {
            Transfer product = (Transfer)reservation.getProducts().get(0);
            travelPolicyParams.getPersons().stream().map(this::buildTraveller).forEach(product.getTravellers()::add);
            searchGdsResponse.setTravelPolicyImpositionResult(new TravelPolicyImpositionResult());
            travelPolicyResults.getProduct2Result().put(product, searchGdsResponse.getTravelPolicyImpositionResult());
        }
    }

    private Traveller buildTraveller(EntityReference<Person> personRef) {
        Traveller traveller = new Traveller();
        traveller.setPassenger(personRef);
        return traveller;
    }
}

