/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyActionsResult;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.ApplyPolicyRules;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.FlightTravelPolicyPropertySet;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.TravelPolicyHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.TravelPolicyProxyData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplyTravelPolicyProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        boolean isSaveRulesTraces;
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Collection proxyData = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULE_PROXIES);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean bl = isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces() && builder != null;
        if (CollectionUtil.isEmpty((Collection)proxyData)) {
            return;
        }
        HashMap<EntityReference, List> contract2Proxies = new HashMap<EntityReference, List>();
        for (TravelPolicyProxyData data : proxyData) {
            List<EntityReference<Contract>> contracts = data.getContracts();
            for (int i = 0; i < contracts.size(); ++i) {
                EntityReference<Contract> contractRef = contracts.get(i);
                List proxies = contract2Proxies.computeIfAbsent(contractRef, key -> new ArrayList());
                proxies.add(data.getProxy());
            }
        }
        Date now = new Date();
        for (Map.Entry entry : contract2Proxies.entrySet()) {
            TravelPolicyHelper.applyTravelPolicyRules((EntityReference<Contract>)((EntityReference)entry.getKey()), (List)entry.getValue(), (EntityReference<Organization>)salesContext.getClient(), now);
        }
        for (TravelPolicyProxyData data : proxyData) {
            TravelPolicyHelper.setTravelPolicyResult(data.getProxy(), data.getImpositionResult());
            if (!isSaveRulesTraces) continue;
            Flight flight = ((FlightTravelPolicyPropertySet)((Object)data.getProxy().getPropertySet())).getFlight();
            ApplyPolicyRules applyPolicyRules = ((IbecorpTravelPolicyActionsResult)data.getProxy().getActionSet()).getApplyPolicyRules();
            if (applyPolicyRules == null) continue;
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, applyPolicyRules.getDescription());
            builder.registerAppliedRule((BaseEntity)flight, applyPolicyRules.getRulesRef(), applyPolicyRules.getRuleSettings());
        }
    }
}

