/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.commission.DiscountProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeeProperties;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.travelPolicy.BaseTravelPolicyMinimalPriceProperties;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAviaMinimalPriceProperties;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMinimalPriceWithSource;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FlightTravelPolicyPropertySet
extends FlightPropertySet
implements IbecorpTravelPolicyPropertiesProvider {
    private static final long serialVersionUID = -7075302243274545427L;
    private final Set<EntityReference<Person>> persons = new HashSet<EntityReference<Person>>();
    private BigDecimal clientTotal;
    private final Map<EntityReference<TravelPolicyAviaMinimalPriceProperties>, BigDecimal> minimals;
    private String clientCurrency;
    private SMGeneralSettings smGeneralSettings;
    private TravelPolicyMatchType matchType;

    public FlightTravelPolicyPropertySet(Flight flt, DictionaryReference<PassengerType> passengerType, PaymentType paymentType, String pcc, RuleProxy<?, ?> proxy, SalesContext ctx, TravelPolicyParameters travelPolicy, SMGeneralSettings smGeneralSettings) {
        this.update(flt, passengerType, paymentType, pcc, proxy, ctx);
        Map clientRelations = FlightHelper.getContractRelations((Flight)flt, (ContractType)ContractType.CLIENT);
        GdsContractRelationData passengerTypeContractRelation = (GdsContractRelationData)clientRelations.get(passengerType);
        if (passengerTypeContractRelation != null) {
            this.clientTotal = passengerTypeContractRelation.getServiceData().getTotalPrice();
            for (GdsCommission commission : passengerTypeContractRelation.getCommissions()) {
                if (commission.getEquivalentAmount() == null || Math.abs(commission.getEquivalentAmount().doubleValue()) < 0.001) continue;
                if (commission.getCommissionProperties() != null && (FeeProperties.class.equals((Object)commission.getCommissionProperties().getType()) || PaymentFeeProperties.class.equals((Object)commission.getCommissionProperties().getType())) && commission.getContractType() == ContractType.CLIENT) {
                    this.clientTotal = this.clientTotal.add(commission.getEquivalentAmount());
                }
                if (commission.getCommissionProperties() == null || !DiscountProperties.class.equals((Object)commission.getCommissionProperties().getType()) || commission.getContractType() != ContractType.CLIENT) continue;
                this.clientTotal = this.clientTotal.subtract(commission.getEquivalentAmount());
            }
            if (TextUtil.isBlank((String)this.clientCurrency)) {
                DictionaryReference currency = GeneralProductHelper.getCurrency((BaseContractRelationData)passengerTypeContractRelation);
                this.clientCurrency = DictHelper.getCode((DictionaryReference)currency);
            }
        }
        this.minimals = flt.getTravelPolicyMinimalPrices().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TravelPolicyMinimalPriceWithSource)e.getValue()).getPrice()));
        if (!travelPolicy.getPersons().isEmpty()) {
            this.getEmployeeCategoriesHolder().setSupplier(() -> GeneralProductHelper.getEmployeeCategories((EntityReference)travelPolicy.getClientRef(), (Collection)travelPolicy.getPersons()));
        } else if (!travelPolicy.getPersonCategories().isEmpty()) {
            this.getEmployeeCategoriesHolder().setSupplier(() -> Collections.unmodifiableList(travelPolicy.getPersonCategories()));
        }
        this.persons.addAll(travelPolicy.getPersons());
        this.smGeneralSettings = smGeneralSettings;
    }

    public Set<EntityReference<Person>> getPersons() {
        return this.persons;
    }

    public BigDecimal getClientTotal() {
        return this.clientTotal;
    }

    public BigDecimal getMinimal(EntityReference<BaseTravelPolicyMinimalPriceProperties> propsRef) {
        return this.minimals.get(propsRef);
    }

    public String getClientCurrency() {
        return this.clientCurrency;
    }

    public SMGeneralSettings getSmGeneralSettings() {
        return this.smGeneralSettings;
    }

    public void setMatchType(TravelPolicyMatchType matchType) {
        this.matchType = matchType;
    }

    public TravelPolicyMatchType getMatchType() {
        return this.matchType;
    }
}

