/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyActionsResult;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.TravelPolicyParameters;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonCostCode;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.FlightTravelPolicyPropertySet;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.TravelPolicyProxyData;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FlightTravelPolicyRuleProxiesBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        boolean proxyTracerEnabled = (Boolean)MiscUtil.guarded((Object)ctx.getObject((Enum)IBusGdsContextKeys.PROXY_TRACER_ENABLED), (Object)Boolean.FALSE);
        TravelPolicyParameters travelPolicy = (TravelPolicyParameters)ctx.getMandatoryObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PARAMETERS);
        Map travellersCostCodes = (Map)ctx.getObject((Enum)IBusIbecorpContextKeys.TRAVELLERS_COST_CODES);
        ArrayList<TravelPolicyProxyData> proxyData = new ArrayList<TravelPolicyProxyData>();
        SMGeneralSettings smGeneralSettings = CommonHelper.getGeneralSettings((EntityReference<SMSite>)salesContext.getSite());
        Set<PersonCostCode> costCodes = travellersCostCodes == null ? Collections.emptySet() : (Collection)travellersCostCodes.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        EntityContainer clientCtr = EntityStorage.get().resolve(salesContext.getClient());
        for (Flight flight : flights) {
            flight.setTravelPolicyImpositionResult(new TravelPolicyImpositionResult());
            IbecorpTravelPolicyActionsResult actionSet = new IbecorpTravelPolicyActionsResult();
            for (Map.Entry entry : flight.getContractRelations().entrySet()) {
                RuleProxy<IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult> proxy;
                ArrayList<EntityReference<Contract>> contracts = new ArrayList<EntityReference<Contract>>();
                for (GdsContractRelationData contractRelationData : (List)entry.getValue()) {
                    EntityReference contractRef;
                    if (GeneralProductHelper.getContractType((EntityReference)contractRelationData.getDescription()) != ContractType.CLIENT || null == (contractRef = contractRelationData.getGeneralData().getContractData().getContract()) || contracts.contains(contractRef)) continue;
                    contracts.add(contractRef);
                }
                if (clientCtr != null && ((Organization)clientCtr.getEntity()).getIbeTravelPolicy() != null) {
                    proxy = this.createProxy(flight, (DictionaryReference<PassengerType>)((DictionaryReference)entry.getKey()), salesContext, travelPolicy, costCodes, proxyTracerEnabled, smGeneralSettings);
                    proxy.setActionSet((Object)actionSet);
                    proxyData.add(new TravelPolicyProxyData(flight.getTravelPolicyImpositionResult(), contracts, proxy));
                    continue;
                }
                if (contracts.isEmpty()) continue;
                proxy = this.createProxy(flight, (DictionaryReference<PassengerType>)((DictionaryReference)entry.getKey()), salesContext, travelPolicy, costCodes, proxyTracerEnabled, smGeneralSettings);
                proxy.setActionSet((Object)actionSet);
                proxyData.add(new TravelPolicyProxyData(flight.getTravelPolicyImpositionResult(), contracts, proxy));
            }
        }
        ctx.putObject((Enum)IBusGdsContextKeys.RULE_PROXIES, proxyData);
    }

    private RuleProxy<IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult> createProxy(Flight flight, DictionaryReference<PassengerType> passengerType, SalesContext salesContext, TravelPolicyParameters travelPolicy, Collection<PersonCostCode> costCodes, boolean proxyTracerEnabled, SMGeneralSettings smGeneralSettings) {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(TravelPolicyTargets.TRAVEL_POLICY_AVIA.getId());
        proxy.setProxyDate(new Date());
        FlightTravelPolicyPropertySet propertySet = new FlightTravelPolicyPropertySet(flight, passengerType, PaymentType.INVOICE, null, proxy, salesContext, travelPolicy, smGeneralSettings);
        proxy.setPropertySet((Object)propertySet);
        propertySet.getCostCodes().addAll(costCodes);
        return proxy;
    }
}

