/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy;

import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyActionsResult;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyProperties;
import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTravelPolicyPropertiesProvider;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MulticurrencyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.ApplyPolicyRules;
import com.gridnine.xtrip.common.model.rules.standard.HotelProperties;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.TransferProperties;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActions;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActionsProvider;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyActionsResult;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyProperties;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyTargets;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicy;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicyAuthorizationScheme;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicyAuthorizationStep;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationAppliedRule;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStepParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationUnitParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMatchType;
import com.gridnine.xtrip.common.railway.model.rules.standart.Properties;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleResultHandler;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.model.handlers.HotelPropertySet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TravelPolicyHelper {
    private static final Logger log = LoggerFactory.getLogger(TravelPolicyHelper.class);
    private static final Collection<RuleProperty> PRICE_LIMIT_PROPERTIES = Arrays.asList(com.gridnine.xtrip.common.model.rules.standard.Properties.FARE, com.gridnine.xtrip.common.model.rules.standard.Properties.SELL_TOTAL, com.gridnine.xtrip.common.model.rules.standard.Properties.PRICE, Properties.RAILWAY_TOTAL_EQUIVALENT_FARE, HotelProperties.HOTEL_FARE, TravelPolicyProperties.TRAVEL_POLICY_CLIENT_TOTAL);
    private static final Collection<RuleProperty> PRICE_LIMIT_BY_NIGHT_PROPERTIES = Collections.singletonList(TravelPolicyProperties.TRAVEL_POLICY_HOTEL_DAILY_RATE);
    private static final Collection<RuleProperty> PRICE_LIMIT_BY_NIGHT_PER_PERSON_PROPERTIES = Arrays.asList(TravelPolicyProperties.TRAVEL_POLICY_HOTEL_DAILY_RATE_PER_PERSON, IbecorpTravelPolicyProperties.TRAVEL_POLICY_HOTEL_DAILY_RATE_PER_PERSON_WITH_CURRENCY);
    private static final Collection<RuleProperty> TIME_LIMIT_PROPERTIES = Arrays.asList(com.gridnine.xtrip.common.model.rules.standard.Properties.SALES_DEPTH_DAYS, Properties.RAILWAY_DAYS_BEFORE_DEPARTURE, HotelProperties.BOOKING_DEPTH_DAYS, TransferProperties.BOOKING_DEPTH);

    public static boolean hasTravelPolicy(SalesContext salesContext) {
        EntityContainer clientCtr = EntityStorage.get().resolve(salesContext.getClient());
        return clientCtr != null && ((Organization)clientCtr.getEntity()).getIbeTravelPolicy() != null;
    }

    public static void applyTravelPolicyRules(BaseProduct product, EntityReference<Contract> contractRef, RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult> proxy) throws Exception {
        if (!ProductHandler.of((BaseProduct)product).getRelatedProducts(product).isEmpty()) {
            return;
        }
        EntityContainer<OrganizationTravelPolicy> travelPolicyCtr = TravelPolicyHelper.getOrganizationTravelPolicyCtr(product);
        if (travelPolicyCtr == null) {
            TravelPolicyHelper.applyTravelPolicyRulesOld(product, contractRef, proxy);
        } else {
            TravelPolicyHelper.applyTravelPolicyRules(product, travelPolicyCtr, proxy);
        }
    }

    private static EntityContainer<OrganizationTravelPolicy> getOrganizationTravelPolicyCtr(BaseProduct product) {
        EntityReference clientRef = product.getReservation().getBookingFile().getCustomerProfile();
        return TravelPolicyHelper.getOrganizationTravelPolicyCtr((EntityReference<Organization>)clientRef);
    }

    private static EntityContainer<OrganizationTravelPolicy> getOrganizationTravelPolicyCtr(EntityReference<Organization> clientRef) {
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        if (clientCtr == null) {
            return null;
        }
        return EntityStorage.get().resolve(((Organization)clientCtr.getEntity()).getIbeTravelPolicy());
    }

    public static void applyTravelPolicyRulesOld(BaseProduct product, EntityReference<Contract> contractRef, RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult> proxy) throws Exception {
        TravelPolicyHelper.applyTravelPolicyRulesInternal(product, contractRef, proxy);
        TravelPolicyHelper.applyTravelPolicyRulesInternal(product, contractRef, TravelPolicyHelper.createProxy(proxy));
    }

    private static RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult> createProxy(RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult> proxy) {
        RuleProxy proxy2 = new RuleProxy();
        proxy2.getTracer().setDisabled(proxy.getTracer().isDisabled());
        proxy2.setProxyType(TravelPolicyTargets.TRAVEL_POLICY_AUTHORIZATION.getId());
        proxy2.setProxyDate(proxy.getProxyDate());
        IbecorpTravelPolicyPropertiesProvider propSet = (IbecorpTravelPolicyPropertiesProvider)proxy.getPropertySet();
        IbecorpTravelPolicyActionsResult actionSet = (IbecorpTravelPolicyActionsResult)proxy.getActionSet();
        propSet.setMatchType(actionSet.getMatchType());
        proxy2.setPropertySet((Object)propSet);
        proxy2.setActionSet((Object)actionSet);
        return proxy2;
    }

    public static void applyTravelPolicyRulesInternal(BaseProduct product, EntityReference<Contract> contractRef, RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult> proxy) throws Exception {
        if (null == contractRef) {
            return;
        }
        EntityContainer contractCtr = EntityStorage.get().resolve(contractRef);
        for (EntityContainer rc : ProfileHelper.getRuleContainers((EntityContainer)contractCtr, (Date)proxy.getProxyDate())) {
            HashSet appliedRulesBefore = new HashSet(proxy.getAppliedRules());
            TravelPolicyHelper.applyRules(Collections.singletonList(proxy), (EntityContainer<? extends BaseRulesContainer>)rc);
            LinkedHashSet appliedRulesLocal = new LinkedHashSet(proxy.getAppliedRules());
            appliedRulesLocal.removeAll(appliedRulesBefore);
            if (appliedRulesLocal.isEmpty()) continue;
            List appliedRules = RulesHelper.calcAppliedRulesToBooking(proxy, appliedRulesLocal, Collections.singletonList(rc), (BaseProduct)product, (EntityContainer)contractCtr);
            appliedRules.forEach(r -> r.setTravelPolicyRule(true));
            product.getReservation().getBookingFile().getAppliedRules().addAll(appliedRules);
        }
    }

    public static void applyTravelPolicyRules(EntityReference<Contract> contractRef, List<RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult>> proxies, EntityReference<Organization> clientRef, Date date) throws Exception {
        EntityContainer<OrganizationTravelPolicy> travelPolicyCtr = TravelPolicyHelper.getOrganizationTravelPolicyCtr(clientRef);
        if (travelPolicyCtr == null) {
            TravelPolicyHelper.applyTravelPolicyRulesInternal(contractRef, proxies, date);
            List<RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult>> proxies2 = proxies.stream().map(TravelPolicyHelper::createProxy).collect(Collectors.toList());
            TravelPolicyHelper.applyTravelPolicyRulesInternal(contractRef, proxies2, date);
        } else {
            for (RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult> proxy : proxies) {
                TravelPolicyHelper.applyTravelPolicyRules(null, travelPolicyCtr, proxy);
            }
        }
    }

    public static void applyTravelPolicyRulesInternal(EntityReference<Contract> contractRef, List<RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult>> proxies, Date date) throws Exception {
        if (null == contractRef) {
            return;
        }
        EntityContainer contractCtr = EntityStorage.get().resolve(contractRef);
        for (EntityContainer rc : ProfileHelper.getRuleContainers((EntityContainer)contractCtr, (Date)date)) {
            TravelPolicyHelper.applyRules(proxies, (EntityContainer<? extends BaseRulesContainer>)rc);
        }
    }

    public static void applyTravelPolicyRules(BaseProduct product, EntityContainer<OrganizationTravelPolicy> travelPolicyCtr, RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult> proxy) throws Exception {
        OrganizationTravelPolicy travelPolicy = (OrganizationTravelPolicy)travelPolicyCtr.getEntity();
        if (travelPolicy.getRuleSet() != null) {
            if (product != null) {
                HashSet appliedRulesBefore = new HashSet(proxy.getAppliedRules());
                TravelPolicyHelper.applyRules(Collections.singletonList(proxy), travelPolicy.getRuleSet(), (EntityReference<? extends BaseEntity>)travelPolicyCtr.toReference());
                LinkedHashSet<String> appliedRulesLocal = new LinkedHashSet<String>(proxy.getAppliedRules());
                appliedRulesLocal.removeAll(appliedRulesBefore);
                if (!appliedRulesLocal.isEmpty()) {
                    List<AppliedRule> appliedRules = TravelPolicyHelper.calcAppliedRulesToBooking(proxy, appliedRulesLocal, product, travelPolicyCtr);
                    appliedRules.forEach(r -> r.setTravelPolicyRule(true));
                    product.getReservation().getBookingFile().getAppliedRules().addAll(appliedRules);
                }
            } else {
                TravelPolicyHelper.applyRules(Collections.singletonList(proxy), travelPolicy.getRuleSet(), (EntityReference<? extends BaseEntity>)travelPolicyCtr.toReference());
            }
        }
        IbecorpTravelPolicyActionsResult actionSet = (IbecorpTravelPolicyActionsResult)proxy.getActionSet();
        ((IbecorpTravelPolicyPropertiesProvider)proxy.getPropertySet()).setMatchType(actionSet.getMatchType());
        String originalProxyType = proxy.getProxyType();
        actionSet.setAuthorizationParameters(new TravelPolicyAuthorizationParameters());
        OrganizationTravelPolicyAuthorizationScheme authScheme = travelPolicy.getAuthorizationScheme();
        if (authScheme != null) {
            for (OrganizationTravelPolicyAuthorizationStep step : authScheme.getSteps()) {
                if (step.getRules() == null || step.getRules().getRules().isEmpty()) continue;
                TravelPolicyAuthorizationStepParameters stepParams = new TravelPolicyAuthorizationStepParameters();
                stepParams.setName(step.getName());
                actionSet.addAuthorizationStepParameters(stepParams);
                proxy.setProxyType(originalProxyType);
                TravelPolicyHelper.applyRules(Collections.singletonList(proxy), step.getRules(), (EntityReference<? extends BaseEntity>)travelPolicyCtr.toReference());
                proxy.setProxyType(TravelPolicyTargets.TRAVEL_POLICY_AUTHORIZATION.getId());
                TravelPolicyHelper.applyRules(Collections.singletonList(proxy), step.getRules(), (EntityReference<? extends BaseEntity>)travelPolicyCtr.toReference());
                stepParams.getUnits().forEach(unit -> unit.getAppliedRule().setTravelPolicyRules(new NestedEntityReference(travelPolicyCtr, (BaseEntity)step)));
            }
        }
        TravelPolicyHelper.checkAuthorizationParameters((TravelPolicyActionsResult)actionSet);
    }

    private static <T extends BaseProduct> List<AppliedRule> calcAppliedRulesToBooking(RuleProxy<?, ?> proxy, Set<String> appliedRulesLocal, T product, EntityContainer<? extends BaseRulesContainer> rulesCtr) {
        RuleSet ruleSet = ((BaseRulesContainer)rulesCtr.getEntity()).getRuleSet();
        ArrayList<AppliedRule> result = new ArrayList<AppliedRule>();
        proxy.getTracer().traceLogic(String.format("some rules applied: organizationTravelPolicy = %s", rulesCtr.toReference()));
        for (String ruleUid : appliedRulesLocal) {
            String logStr;
            RuleSettings rule = null;
            rule = (RuleSettings)CollectionUtil.find((Iterable)ruleSet.getRules(), (String)ruleUid);
            if (rule == null) {
                logStr = String.format("unable to find rule: organizationTravelPolicy=%s, uid=%s", rulesCtr.toReference(), ruleUid);
                log.error(logStr);
                proxy.getTracer().traceWarn(logStr, null);
                continue;
            }
            logStr = String.format("ruleset %s rule \u2116 %s was applied", ((BaseRulesContainer)rulesCtr.getEntity()).toString(), Integer.toString(ruleSet.getRules().indexOf(rule) + 1));
            log.debug(logStr);
            proxy.getTracer().traceLogic(logStr);
            AppliedRule ruleInfo = new AppliedRule();
            ruleInfo.setCalculationDate(new Date());
            ruleInfo.setRulesContainer(rulesCtr.toReference());
            ruleInfo.setProductUid(product.getUid());
            ruleInfo.setRuleUid(rule.getUid());
            ruleInfo.setRuleName(rule.getName());
            ruleInfo.setRuleDescription(rule.getRestrictionsInfo());
            result.add(ruleInfo);
        }
        return result;
    }

    private static void checkAuthorizationParameters(TravelPolicyActionsResult actionSet) {
        TravelPolicyAuthorizationParameters authorizationParameters = actionSet.getAuthorizationParameters();
        Iterator it = authorizationParameters.getSteps().iterator();
        while (it.hasNext()) {
            TravelPolicyAuthorizationStepParameters step = (TravelPolicyAuthorizationStepParameters)it.next();
            step.getUnits().removeIf(unit -> unit.getPersons().isEmpty());
            if (!step.getUnits().isEmpty()) continue;
            it.remove();
        }
        if (authorizationParameters.getSteps().isEmpty()) {
            actionSet.setAuthorizationParameters(null);
        }
    }

    private static void applyRules(List<RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult>> proxies, EntityContainer<? extends BaseRulesContainer> rc) throws Exception {
        TravelPolicyHelper.applyRules(proxies, ((BaseRulesContainer)rc.getEntity()).getRuleSet(), (EntityReference<? extends BaseEntity>)rc.toReference());
    }

    private static void applyRules(List<RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, IbecorpTravelPolicyActionsResult>> proxies, RuleSet ruleSet, final EntityReference<? extends BaseEntity> rulesContainerRef) throws Exception {
        RuleEngine.applyRules(proxies, (RuleSet)ruleSet, (RuleResultHandler)new RuleResultHandler(){

            public void processRuleResult(RuleProxy<?, ?> proxy, RuleSettings ruleSettings, RuleResult ruleResult) throws Exception {
                int currMatchTypeOrdinal;
                if (ruleResult.getAction().equals(TravelPolicyActions.TRAVEL_POLICY_AUTHORIZATION_UNIT_REQUIRED)) {
                    TravelPolicyAuthorizationUnitParameters authorizationParameters = (TravelPolicyAuthorizationUnitParameters)ruleResult.getValue();
                    TravelPolicyActionsProvider as = (TravelPolicyActionsProvider)proxy.getActionSet();
                    as.addAuthorizationUnitParameters(authorizationParameters);
                    TravelPolicyAuthorizationAppliedRule ruleInfo = new TravelPolicyAuthorizationAppliedRule();
                    ruleInfo.setCalculationDate(new Date());
                    ruleInfo.setRuleUid(ruleSettings.getUid());
                    ruleInfo.setRuleName(ruleSettings.getName());
                    ruleInfo.setRuleDescription(TravelPolicyHelper.generateDescription(ruleSettings, false));
                    authorizationParameters.setAppliedRule(ruleInfo);
                    return;
                }
                if (!ruleResult.getAction().equals(TravelPolicyActions.TRAVEL_POLICY_MATCH_TYPE)) {
                    return;
                }
                TravelPolicyActionsProvider actions = (TravelPolicyActionsProvider)proxy.getActionSet();
                TravelPolicyMatchType newMatchType = (TravelPolicyMatchType)ruleResult.getValue();
                int newMatchTypeOrdinal = newMatchType != null ? newMatchType.ordinal() : -1;
                TravelPolicyMatchType currMatchType = actions.getMatchType();
                int n = currMatchTypeOrdinal = currMatchType != null ? currMatchType.ordinal() : -1;
                if (newMatchTypeOrdinal > currMatchTypeOrdinal) {
                    TravelPolicyHelper.addApplyPolicyRules(ruleSettings, (TravelPolicyActionsResult)actions, (EntityReference<? extends BaseEntity>)rulesContainerRef);
                    actions.clear();
                    proxy.getAppliedRuleCategories().clear();
                    actions.setMatchType(newMatchType);
                }
                if (newMatchTypeOrdinal >= currMatchTypeOrdinal) {
                    actions.getMatchTypeAppliedRules().add(ruleSettings.getUid());
                    actions.addRuleDetails(TravelPolicyHelper.generateDescription(ruleSettings, false));
                }
                BigDecimal priceLimit = actions.getPriceLimit();
                Number limit = TravelPolicyHelper.getPriceLimit(ruleSettings);
                if (limit != null && (null == priceLimit || priceLimit.compareTo((BigDecimal)limit) < 0)) {
                    actions.getPriceLimitAppliedRules().clear();
                    actions.getPriceLimitAppliedRules().add(ruleSettings.getUid());
                    actions.setPriceLimit((BigDecimal)limit);
                }
                priceLimit = actions.getPriceLimit();
                limit = TravelPolicyHelper.getPriceLimitByNight(proxy, ruleSettings);
                if (limit != null && (null == priceLimit || priceLimit.compareTo((BigDecimal)limit) < 0)) {
                    actions.getPriceLimitAppliedRules().clear();
                    actions.getPriceLimitAppliedRules().add(ruleSettings.getUid());
                    actions.setPriceLimit((BigDecimal)limit);
                }
                priceLimit = actions.getPriceLimit();
                limit = TravelPolicyHelper.getPriceLimitByNightPerPerson(proxy, ruleSettings);
                if (limit != null && (null == priceLimit || priceLimit.compareTo((BigDecimal)limit) < 0)) {
                    actions.getPriceLimitAppliedRules().clear();
                    actions.getPriceLimitAppliedRules().add(ruleSettings.getUid());
                    actions.setPriceLimit((BigDecimal)limit);
                }
                Integer timeLimit = actions.getTimeLimit();
                limit = TravelPolicyHelper.getTimeLimit(ruleSettings);
                if (limit != null && (null == timeLimit || timeLimit < (Integer)limit)) {
                    actions.getTimeLimitAppliedRules().clear();
                    actions.getTimeLimitAppliedRules().add(ruleSettings.getUid());
                    actions.setTimeLimit((Integer)limit);
                }
            }

            public void done(RuleProxy<?, ?> proxy) throws Exception {
                TravelPolicyActionsProvider actions = (TravelPolicyActionsProvider)proxy.getActionSet();
                proxy.getAppliedRules().addAll(actions.getMatchTypeAppliedRules());
                proxy.getAppliedRules().addAll(actions.getPriceLimitAppliedRules());
                proxy.getAppliedRules().addAll(actions.getTimeLimitAppliedRules());
            }

            public boolean isProcessAllRuleResults() {
                return true;
            }
        });
    }

    private static BigDecimal getPriceLimit(RuleSettings ruleSettings) {
        return ruleSettings.getRestrictions().stream().filter(r -> PRICE_LIMIT_PROPERTIES.contains(r.getProperty())).map(RuleRestriction::getValue).map(TravelPolicyHelper::getBigDecimal).filter(Objects::nonNull).min(BigDecimal::compareTo).orElse(null);
    }

    private static BigDecimal getPriceLimitByNight(RuleProxy<?, ?> proxy, RuleSettings ruleSettings) {
        if (!(proxy.getPropertySet() instanceof HotelPropertySet)) {
            return null;
        }
        HotelPropertySet ps = (HotelPropertySet)proxy.getPropertySet();
        HotelProduct product = ps.getProduct();
        BigDecimal nights = BigDecimal.valueOf(ps.getStayDuration());
        return ruleSettings.getRestrictions().stream().filter(r -> PRICE_LIMIT_BY_NIGHT_PROPERTIES.contains(r.getProperty())).map(RuleRestriction::getValue).map(o -> TravelPolicyHelper.getBigDecimal((BaseProduct)product, o)).filter(Objects::nonNull).map(nights::multiply).min(BigDecimal::compareTo).orElse(null);
    }

    private static BigDecimal getPriceLimitByNightPerPerson(RuleProxy<?, ?> proxy, RuleSettings ruleSettings) {
        if (!(proxy.getPropertySet() instanceof HotelPropertySet)) {
            return null;
        }
        HotelPropertySet ps = (HotelPropertySet)proxy.getPropertySet();
        HotelProduct product = ps.getProduct();
        BigDecimal nights = BigDecimal.valueOf(ps.getStayDuration());
        BigDecimal persons = BigDecimal.valueOf(ps.getPersonsCount());
        return ruleSettings.getRestrictions().stream().filter(r -> PRICE_LIMIT_BY_NIGHT_PER_PERSON_PROPERTIES.contains(r.getProperty())).map(RuleRestriction::getValue).map(o -> TravelPolicyHelper.getBigDecimal((BaseProduct)product, o)).filter(Objects::nonNull).map(nights::multiply).map(persons::multiply).min(BigDecimal::compareTo).orElse(null);
    }

    private static BigDecimal getBigDecimal(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Double || obj instanceof Float) {
            return BigDecimal.valueOf(((Number)obj).doubleValue());
        }
        if (obj instanceof Number) {
            return BigDecimal.valueOf(((Number)obj).longValue());
        }
        return null;
    }

    private static BigDecimal getBigDecimal(BaseProduct product, Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Double || obj instanceof Float) {
            return BigDecimal.valueOf(((Number)obj).doubleValue());
        }
        if (obj instanceof Number) {
            return BigDecimal.valueOf(((Number)obj).longValue());
        }
        if (obj instanceof Money) {
            Money money = (Money)obj;
            String localCurrency = DictHelper.getLocalCurrency();
            BigDecimal amount = money.getValue();
            String currency = (String)MiscUtil.guarded((Object)money.getCurrency(), (Object)localCurrency);
            if (!Objects.equals(currency, localCurrency)) {
                Date operationDate;
                BaseProduct prev;
                ProductHandler h = GeneralProductHelper.getHandler((BaseProduct)product);
                ProductStatus status = h.getStatus(product);
                if ((ProductStatus.REFUND == status || ProductStatus.EXCHANGE == status) && (prev = h.getPreviousProduct(product)) != null) {
                    product = prev;
                }
                if (null == (operationDate = h.findIssueDate(product)) && product.getReservation() != null) {
                    operationDate = product.getReservation().getResDate();
                }
                if (null == operationDate) {
                    operationDate = new Date();
                }
                ExchangeRateCondition defaultExchangeRateCondition = new ExchangeRateCondition();
                defaultExchangeRateCondition.setCoefficient(1.0);
                ExchangeRateData rateData = MulticurrencyHelper.buildExchangeRateData((String)currency, (String)localCurrency, (ExchangeRateCondition)defaultExchangeRateCondition, (Date)operationDate, (EntityReference)GeneralProductHelper.getSupplier((BaseProduct)product), (boolean)false);
                double rate = rateData.getRateWithCoefficient();
                amount = amount.multiply(new BigDecimal(rate)).setScale(2, 4);
            }
            return amount;
        }
        return null;
    }

    private static Integer getTimeLimit(RuleSettings ruleSettings) {
        return ruleSettings.getRestrictions().stream().filter(r -> TIME_LIMIT_PROPERTIES.contains(r.getProperty())).map(RuleRestriction::getValue).map(TravelPolicyHelper::getInteger).filter(Objects::nonNull).reduce(Integer::max).orElse(null);
    }

    private static Integer getInteger(Object obj) {
        return obj instanceof Number ? Integer.valueOf(((Number)obj).intValue()) : null;
    }

    private static String generateDescription(RuleSettings rule, boolean useNewLine) {
        StringBuilder result = new StringBuilder();
        if (rule == null) {
            return "";
        }
        for (RuleRestriction restr : rule.getRestrictions()) {
            if (restr.getProperty() == null || restr.getCondition() == null) continue;
            if (result.length() != 0) {
                result.append(useNewLine ? "\n" : " ").append(L10n.get((String)"AND").toLowerCase()).append(" ");
            }
            restr.getProperty().buildInfo(result, restr.getCondition(), restr.getValue());
        }
        if (result.length() == 0) {
            return result.toString();
        }
        char firstChar = result.charAt(0);
        if (!Character.isUpperCase(firstChar)) {
            result.setCharAt(0, Character.toUpperCase(firstChar));
        }
        return result.toString().replaceAll(Matcher.quoteReplacement("\\\""), "\"");
    }

    public static void setTravelPolicyResult(RuleProxy<? extends IbecorpTravelPolicyPropertiesProvider, ? extends IbecorpTravelPolicyActionsResult> proxy, TravelPolicyImpositionResult result) throws Exception {
        IbecorpTravelPolicyActionsResult actions = (IbecorpTravelPolicyActionsResult)proxy.getActionSet();
        result.setMatchType(actions.getMatchType());
        result.setRecommended(actions.isRecommended());
        result.getRuleDetails().addAll(actions.getRuleDetails());
        result.setAuthorizationParameters((TravelPolicyAuthorizationParameters)XCloneHelper.clone((XCloneable)actions.getAuthorizationParameters(), (boolean)true));
        result.setReasonCodeRequired(actions.isReasonCodeRequired());
        result.setKeyContactsRequired(actions.isKeyContactsRequired());
        if (actions.getMessage() != null) {
            result.getL10nMessage().putAll(actions.getMessage().getValues().entrySet().stream().filter(e -> e.getKey() != null && TextUtil.nonBlank((String)((Locale)e.getKey()).getLanguage())).collect(Collectors.toMap(e -> ((Locale)e.getKey()).getLanguage(), Map.Entry::getValue)));
        }
    }

    private static void addApplyPolicyRules(RuleSettings ruleSettings, TravelPolicyActionsResult actions, EntityReference<? extends BaseEntity> rulesContainerRef) {
        ApplyPolicyRules applyPolicyRules = actions.getApplyPolicyRules();
        if (applyPolicyRules == null) {
            applyPolicyRules = new ApplyPolicyRules();
            actions.setApplyPolicyRules(applyPolicyRules);
        }
        String msg = String.format("%s. \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: %s.\n%s", ruleSettings.getTarget().getDisplayName(), ruleSettings.getName(), ruleSettings.getRestrictionsInfoNoHtml());
        applyPolicyRules.setDescription(msg);
        applyPolicyRules.setRulesRef(rulesContainerRef);
        applyPolicyRules.setRuleSettings(ruleSettings);
    }

    public static TravelPolicyImpositionResult strictestTravelPolicy(TravelPolicyImpositionResult tpir1, TravelPolicyImpositionResult tpir2) {
        if (tpir1.getMatchType() != null && tpir2.getMatchType() != null) {
            int w2;
            int w1 = TravelPolicyHelper.getWeight(tpir1.getMatchType());
            return w1 >= (w2 = TravelPolicyHelper.getWeight(tpir2.getMatchType())) ? tpir1 : tpir2;
        }
        return tpir1;
    }

    private static int getWeight(TravelPolicyMatchType matchType) {
        switch (matchType) {
            case HIDE: {
                return 4;
            }
            case STRICT_VIOLATION: {
                return 3;
            }
            case VIOLATION: {
                return 2;
            }
        }
        return 0;
    }
}

