/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.authorization;

import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.ibecorp.rules.AuthorizationTemplateActionResult;
import com.gridnine.xtrip.common.ibecorp.rules.AuthorizationTemplatePropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.ibecorp.AuthorizationActionType;
import com.gridnine.xtrip.common.model.ibecorp.AuthorizationMailRecepient;
import com.gridnine.xtrip.common.model.ibecorp.sm.AuthorizationMailTemplate;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailServerParameters;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyUnitAuthorization;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.authorization.notification.AuthNotification;
import com.gridnine.xtrip.server.ibecorp.l10n.Messages;
import com.gridnine.xtrip.server.ibecorp.notifications.Notification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import freemarker.core.InvalidReferenceException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class AuthSendHelper {
    private static void sendToAuthorization(Notification notification) {
        MailDocument mailDocument;
        try {
            mailDocument = NotificationHelper.buildMailDocument(notification, false);
        }
        catch (InvalidReferenceException e) {
            throw Xeption.forEndUser((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043f\u0438\u0441\u044c\u043c\u0430: \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f.\n\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043f\u043e\u043b\u0435 {0} \u0432 \u0448\u0430\u0431\u043b\u043e\u043d\u0435 \u0432 \u041c\u041e\u041c\u0435.", (Object[])new Object[]{e.getBlamedExpressionString()});
        }
        catch (Exception e) {
            throw Xeption.forEndUser((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043f\u0438\u0441\u044c\u043c\u0430: \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f.\n\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0432 \u041c\u041e\u041c\u0435.", (Throwable)e, (Object[])new Object[0]);
        }
        MailServerParameters msp = notification.getOrDefaultMailServerParameters();
        NotificationHelper.sendMail(msp, mailDocument, true);
    }

    private static EntityReference<Contract> findContractRelation(BaseProduct product) {
        GeneralProductContractRelationData contractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
        if (contractRelation == null) {
            throw Xeption.forDeveloper((String)"\u041d\u0435 \u0431\u044b\u043b\u043e \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430. \u041d\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044e \u0431\u044b\u043b\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f", (Object[])new Object[0]);
        }
        return contractRelation.getGeneralData().getContractData().getContract();
    }

    private static List<AuthorizationMailTemplate> getMailTemplateFromClientContractRules(BaseProduct product, AuthorizationActionType actionType) throws Exception {
        EntityReference<Contract> contractRef = AuthSendHelper.findContractRelation(product);
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyDate(new Date());
        proxy.setProxyType(Targets.NOTIFICATION_TEMPLATE_AUTHORIZATION.getId());
        AuthorizationTemplatePropertySet propertySet = new AuthorizationTemplatePropertySet(actionType);
        AuthorizationTemplateActionResult actionSet = new AuthorizationTemplateActionResult();
        proxy.setPropertySet((Object)propertySet);
        proxy.setActionSet((Object)actionSet);
        Date date = new Date();
        EntityContainer contractCtr = EntityStorage.get().resolve(contractRef);
        for (EntityContainer rc : ProfileHelper.getRuleContainers((EntityContainer)contractCtr, (Date)date)) {
            RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)((BaseRulesContainer)rc.getEntity()).getRuleSet());
            if (((AuthorizationTemplateActionResult)proxy.getActionSet()).getMailTemplates() == null || ((AuthorizationTemplateActionResult)proxy.getActionSet()).getMailTemplates().isEmpty()) continue;
            break;
        }
        return actionSet.getMailTemplates();
    }

    public static void sendMailToRecipients(AuthorizationActionType actionType, Reservation reservation, EntityReference<BookingFile> bfRef, HttpServletRequest request, String templateName, BigDecimal pricingDelta) throws Exception {
        List products = BookingStreamHelper.getBaseProductsStream((Reservation)reservation).collect(Collectors.toList());
        for (BaseProduct product : products) {
            AuthSendHelper.sendMailToRecipients(actionType, product, bfRef, request, templateName, pricingDelta);
        }
    }

    public static void sendMailToRecipients(AuthorizationActionType actionType, BaseProduct product, EntityReference<BookingFile> bfRef, HttpServletRequest request, String templateName, BigDecimal pricingDelta) throws Exception {
        AuthSendHelper.sendMailToRecipients(actionType, product, null, bfRef, request, templateName, pricingDelta);
    }

    public static void sendMailToRecipients(AuthorizationActionType actionType, BaseProduct product, List<TravelPolicyUnitAuthorization> unitAuthorizations, EntityReference<BookingFile> bfRef, HttpServletRequest request, String templateName, BigDecimal pricingDelta) throws Exception {
        List<AuthorizationMailTemplate> templates = AuthSendHelper.getMailTemplateFromClientContractRules(product, actionType);
        if (CollectionUtil.isEmpty(templates)) {
            throw Xeption.forAdmin((String)L10n.getWithParams((String)"AUTHORIZATION_NO_TEMPLATES", (Object[])new Object[]{actionType}), (Object[])new Object[0]);
        }
        AuthSendHelper.deleteDublicatedRecipientsFromTemplate(templates);
        Map authPersonMails = TravelPolicyAuthorizationHelper.getAuthPersonMails((BaseProduct)product, unitAuthorizations);
        if (authPersonMails.isEmpty() && actionType == AuthorizationActionType.AUTHORIZATION_REQUEST) {
            throw Xeption.forEndUser((String)"\u041d\u0435\u0442 \u043b\u0438\u0446\u0430, \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u0437\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044e, \u0438\u043b\u0438 \u0443 \u043b\u0438\u0446\u0430 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d email.", (Object[])new Object[0]);
        }
        for (AuthorizationMailTemplate mailTemplate : templates) {
            ArrayList<String> otherRecipients = new ArrayList<String>();
            NotificationParameters notificationParameters = new NotificationParameters(product.getReservation(), bfRef);
            for (AuthorizationMailRecepient recipient : mailTemplate.getAuthorizationRecipientRoles()) {
                if (recipient == AuthorizationMailRecepient.AUTH_PERSON) {
                    if (actionType == AuthorizationActionType.AUTHORIZATION_REQUEST) {
                        for (Map.Entry entry : authPersonMails.entrySet()) {
                            EntityReference personRef = (EntityReference)entry.getKey();
                            String email = (String)entry.getValue();
                            AuthNotification notification = new AuthNotification(notificationParameters, product, Collections.singletonList(email), mailTemplate, pricingDelta);
                            notification.initUrlsForMailButtons(product, bfRef, request, notificationParameters.getSiteRef(), (EntityReference<Person>)personRef);
                            NotificationHelper.assignButtonsStyleFromTemplate(templates, notification);
                            notification.addProperty("toAuthorizePerson", true);
                            notification.addProperty("authText", L10nResourcesManager.createL10nMessage((String)Messages.BUTTON_CONFIRM_AUTHORISATION, (Object[])new Object[0]));
                            notification.addProperty("refuseText", L10nResourcesManager.createL10nMessage((String)Messages.BUTTON_CANCEL_AUTHORISATION, (Object[])new Object[0]));
                            notification.addProperty("body", NotificationHelper.formatTemplate(templateName, notification.getLocale(), notification.getContext(), AuthSendHelper.class));
                            AuthSendHelper.sendToAuthorization(notification);
                        }
                    } else {
                        otherRecipients.addAll(authPersonMails.values());
                    }
                }
                if (recipient == AuthorizationMailRecepient.BOOKING_AGENT) {
                    otherRecipients.add(MiscUtil.guarded((String)TravelPolicyAuthorizationHelper.getBookingAgentEmail((Reservation)product.getReservation())));
                    continue;
                }
                if (recipient == AuthorizationMailRecepient.PASSENGER) {
                    otherRecipients.add(MiscUtil.guarded((String)TravelPolicyAuthorizationHelper.collectPassengersEmails((BaseProduct)product)));
                    continue;
                }
                if (recipient != AuthorizationMailRecepient.CUSTOMER) continue;
                String customerEmail = TravelPolicyAuthorizationHelper.getPersonEmail((Reservation)product.getReservation());
                otherRecipients.add(MiscUtil.guarded((String)customerEmail));
            }
            otherRecipients.addAll(mailTemplate.getAdditionalAddresses());
            otherRecipients.removeIf(TextUtil::isBlank);
            if (otherRecipients.size() == 0) continue;
            AuthNotification notification = new AuthNotification(notificationParameters, product, otherRecipients, mailTemplate, pricingDelta);
            notification.addProperty("toAuthorizePerson", false);
            notification.addProperty("body", NotificationHelper.formatTemplate(templateName, notification.getLocale(), notification.getContext(), AuthSendHelper.class));
            AuthSendHelper.sendToAuthorization(notification);
        }
    }

    private static void deleteDublicatedRecipientsFromTemplate(List<AuthorizationMailTemplate> templates) {
        HashSet<AuthorizationMailRecepient> recipientsSet = new HashSet<AuthorizationMailRecepient>();
        for (AuthorizationMailTemplate mailTemplate : templates) {
            Iterator recipientIterator = mailTemplate.getAuthorizationRecipientRoles().iterator();
            while (recipientIterator.hasNext()) {
                AuthorizationMailRecepient recipient = (AuthorizationMailRecepient)recipientIterator.next();
                if (recipientsSet.contains(recipient)) {
                    recipientIterator.remove();
                    continue;
                }
                recipientsSet.add(recipient);
            }
        }
    }

    public static List<BaseProduct> getWithRelatedMcoProducts(BaseProduct product) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        result.add(product);
        result.addAll(GeneralProductHelper.getMcoByRelatedProduct((BaseProduct)product));
        return result;
    }
}

