/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.authorization;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.AuthorizationActionType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStatus;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyUnitAuthorization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.authorization.AuthSendHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

public class BookingRefuseAuthorizationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        List products = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        EntityReference agentRef = (EntityReference)ctx.getObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER);
        String stepUid = (String)ctx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_STEP_UID);
        Boolean isAutoRefuse = (Boolean)ctx.getObject((Enum)IBusTravelPolicyContextKeys.IS_AUTO_REFUSE);
        Map productUnitAuthorizations = TravelPolicyAuthorizationHelper.getProductUnitAuthorizationsMap((List)products, (EntityReference)agentRef, (String)stepUid);
        if (productUnitAuthorizations.isEmpty()) {
            throw Xeption.forEndUser((String)"\u0423\u0441\u043b\u0443\u0433\u0430 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 (\u043e\u0442\u043a\u0430\u0437\u0430 \u043e\u0442 \u043d\u0435\u0435)", (Object[])new Object[0]);
        }
        for (Map.Entry entry : productUnitAuthorizations.entrySet()) {
            BaseProduct product = (BaseProduct)entry.getKey();
            List unitAuthorizations = (List)entry.getValue();
            for (TravelPolicyUnitAuthorization unitAuthorization : unitAuthorizations) {
                unitAuthorization.setStatus(BooleanUtils.isTrue((Boolean)isAutoRefuse) ? TravelPolicyAuthorizationStatus.EXPIRED : TravelPolicyAuthorizationStatus.REFUSED);
                unitAuthorization.setAuthorizer((EntityReference)MiscUtil.guarded((Object)agentRef, ProfileHelper::getCurrentUser));
                unitAuthorization.setOperationDate(LocalDateTime.now());
            }
            if (BooleanUtils.isTrue((Boolean)isAutoRefuse)) {
                AuthSendHelper.sendMailToRecipients(AuthorizationActionType.AUTHORIZATION_EXPIRED, product, unitAuthorizations, (EntityReference<BookingFile>)bookingCtr.toReference(), null, "auto_refuse_authorization", null);
                continue;
            }
            AuthSendHelper.sendMailToRecipients(AuthorizationActionType.AUTHORIZATION_REFUSE, product, unitAuthorizations, (EntityReference<BookingFile>)bookingCtr.toReference(), null, "refuse_authorization", null);
        }
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"AUTHORIZATION_REFUSE", (Object[])new Object[0]));
    }
}

