/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.authorization;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.ibecorp.AuthorizationActionType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStatus;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationUnitParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyUnitAuthorization;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.authorization.AuthSendHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class BookingSendToAuthorizationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        List reservations = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS);
        List wrong = reservations.stream().filter(res -> !TravelPolicyAuthorizationHelper.needSendToAuthorization((Reservation)res)).collect(Collectors.toList());
        if (!wrong.isEmpty()) {
            if (Boolean.TRUE.equals(ctx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_IGNORE_WRONG_RESERVATIONS_EXCEPTION))) {
                return;
            }
            throw Xeption.forEndUser((String)"\u0410\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f(\u0439) {0} \u043d\u0435 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0430", (Object[])new Object[]{wrong.stream().map(CommonReservationGdsNameInfoHelper::getDisplayedRecordLocator).collect(Collectors.joining("; "))});
        }
        RestContext restContext = (RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT);
        HttpServletRequest request = restContext.getRequest();
        reservations.stream().map(Reservation::getProducts).flatMap(Collection::stream).filter(TravelPolicyAuthorizationHelper::needSendToAuthorization).forEach(ExceptionUtil.wrapConsumer(pr -> {
            List units = TravelPolicyAuthorizationHelper.getNeedAuthorizationNextStepUnits((BaseProduct)pr);
            if (units.isEmpty()) {
                return;
            }
            ArrayList<TravelPolicyUnitAuthorization> unitAuthorizations = new ArrayList<TravelPolicyUnitAuthorization>();
            for (TravelPolicyAuthorizationUnitParameters unit : units) {
                TravelPolicyUnitAuthorization unitAuthorization = new TravelPolicyUnitAuthorization();
                unitAuthorization.setSendDate(LocalDateTime.now());
                unitAuthorization.setStatus(TravelPolicyAuthorizationStatus.WAIT);
                unitAuthorization.setClientPrice(BookingHelper.getTotalPrice((BaseProduct)pr, (ContractType)ContractType.CLIENT));
                unit.setUnitAuthorization(unitAuthorization);
                unitAuthorizations.add(unitAuthorization);
            }
            AuthSendHelper.sendMailToRecipients(AuthorizationActionType.AUTHORIZATION_REQUEST, pr, unitAuthorizations, (EntityReference<BookingFile>)bfCtr.toReference(), request, "authorization", null);
        }));
        ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435(\u044f) {0} \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e(\u044b) \u043d\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044e", (Object[])new Object[]{reservations.stream().map(CommonReservationGdsNameInfoHelper::getDisplayedRecordLocator).collect(Collectors.joining("; "))}));
    }
}

