/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.authorization;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.ibecorp.AuthorizationActionType;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStatus;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyUnitAuthorization;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.authorization.AuthSendHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CancelReservationAuthorizationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        if (reservation.getStatus() != ReservationStatus.AUTHORIZATION) {
            return;
        }
        if (Boolean.TRUE.equals(ctx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_AUTHORIZATION_STATUSES_ALREADY_SET))) {
            return;
        }
        Collection products = (Collection)MiscUtil.guarded((Object)ctx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_PRODUCTS), (Object)reservation.getProducts());
        for (BaseProduct bp : products) {
            List unitAuthorizations = TravelPolicyAuthorizationHelper.getCurrentAuthorizationUnitAuthorizations((BaseProduct)bp);
            for (TravelPolicyUnitAuthorization unitAuthorization : unitAuthorizations) {
                if (unitAuthorization.getStatus() == null) continue;
                switch (unitAuthorization.getStatus()) {
                    case WAIT: {
                        unitAuthorization.setStatus(TravelPolicyAuthorizationStatus.ABORTED);
                        AuthSendHelper.sendMailToRecipients(AuthorizationActionType.AUTHORIZATION_ABORTED, bp, Collections.singletonList(unitAuthorization), (EntityReference<BookingFile>)bfCtr.toReference(), null, "abort_authorization", null);
                        break;
                    }
                    case APPROVED: {
                        unitAuthorization.setStatus(TravelPolicyAuthorizationStatus.CANCELED);
                        AuthSendHelper.sendMailToRecipients(AuthorizationActionType.AUTHORIZATION_CANCELLED, bp, Collections.singletonList(unitAuthorization), (EntityReference<BookingFile>)bfCtr.toReference(), null, "cancel_authorization", null);
                    }
                }
            }
        }
    }
}

