/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.authorization.notification;

import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.json.JSONMarshaller;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.NotificationSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.AuthorizationMailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.travelPolicy.authorization.AuthorizationTemporalObjectData;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationAppliedRule;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStepParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationUnitParameters;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.approval.notification.ApprovalNotification;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.AuthorizationTempToken;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.authorization.AuthSendHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class AuthNotification
extends ApprovalNotification {
    private final AuthorizationMailTemplate authorizationMailTemplate;
    private final BaseProduct product;

    public AuthNotification(NotificationParameters parameters, BaseProduct product, List<String> emails, AuthorizationMailTemplate authorizationMailTemplate, BigDecimal pricingDelta) throws Exception {
        super(parameters, () -> NotificationHelper.getNotificationSettings(product.getReservation(), NotificationSettings::isUseSiteSettings));
        this.authorizationMailTemplate = authorizationMailTemplate;
        this.product = product;
        List<String> productUids = AuthSendHelper.getWithRelatedMcoProducts(product).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
        this.init(parameters, product.getReservation().getBookingFile(), emails, productUids, null);
        this.addProperty("priceDelta", pricingDelta == null ? 0.0 : pricingDelta.doubleValue());
        this.addImage("iconAuth.svg");
    }

    @Override
    protected String buildTravellerNames(Collection<BaseProduct> products) {
        return super.buildTravellerNames(Collections.singleton(this.product));
    }

    @Override
    protected String getProductsNumbers(Collection<BaseProduct> products) {
        return super.getProductsNumbers(Collections.singleton(this.product));
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"NEED_AUTH", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    public MailTemplate getTemplate() {
        return this.authorizationMailTemplate;
    }

    public void initUrlsForMailButtons(BaseProduct product, EntityReference<BookingFile> bfRef, HttpServletRequest request, EntityReference<SMSite> siteRef, EntityReference<Person> personRef) throws Exception {
        if (request != null) {
            String url = AuthNotification.buildAuthorizationUrl(request, siteRef);
            TemporalObject to = new TemporalObject();
            to.setReference(bfRef);
            AuthorizationTemporalObjectData data = new AuthorizationTemporalObjectData();
            data.setPerson(personRef);
            data.setReservationUid(product.getReservation().getUid());
            data.setProductUid(product.getUid());
            TravelPolicyAuthorizationStepParameters currentAuthorizationStep = Objects.requireNonNull(TravelPolicyAuthorizationHelper.getCurrentAuthorizationStep((BaseProduct)product));
            data.setStepUid(currentAuthorizationStep.getUid());
            to.setData(XSUtil.toByteArray((XSSerializable)data));
            to.setTag("auth-notification");
            Integer timeLimitMinutes = (Integer)MiscUtil.guarded((Object)TravelPolicyAuthorizationHelper.findTimeLimit((BaseProduct)product), (Object)60);
            to.setExpired(new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(timeLimitMinutes.intValue())));
            AssetsStorage.get().save((BaseAsset)to);
            this.model.setAuthLink(url + "processBookingAuthorization/" + AuthNotification.buildToken(to.getUid(), true));
            this.model.setRefuseLink(url + "processBookingAuthorization/" + AuthNotification.buildToken(to.getUid(), false));
            this.addProperty("appliedRules", currentAuthorizationStep.getUnits().stream().filter(unit -> unit.getPersons().contains(personRef)).map(TravelPolicyAuthorizationUnitParameters::getAppliedRule).filter(Objects::nonNull).map(TravelPolicyAuthorizationAppliedRule::getRuleDescription).collect(Collectors.toList()));
        }
    }

    private static String buildToken(String tempUid, boolean approve) {
        AuthorizationTempToken authorizationToken = new AuthorizationTempToken();
        authorizationToken.setTempUid(tempUid);
        authorizationToken.setApprove(approve);
        String jsonToken = JSONMarshaller.marshal((Object)authorizationToken).toString();
        try {
            return DesUtil.encode((String)jsonToken);
        }
        catch (IOException | GeneralSecurityException e) {
            throw Xeption.forDeveloper((String)"Problems with encode authorization token", (Object[])new Object[0]);
        }
    }

    private static String buildAuthorizationUrl(HttpServletRequest request, EntityReference<SMSite> siteRef) {
        StringBuilder url = new StringBuilder();
        String scheme = request.getHeader("X-Forwarded-Proto") != null ? request.getHeader("X-Forwarded-Proto") : request.getScheme();
        scheme = scheme != null && scheme.contains("https") ? "https" : "http";
        SMSite site = (SMSite)EntityStorage.get().resolve(siteRef).getEntity();
        String host = site.getDomain() + "/#/authorization/page/";
        url.append(scheme).append("://").append(host);
        return url.toString();
    }
}

