/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.minimalPrice;

import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.travelPolicy.TravelPolicyProperties;
import com.gridnine.xtrip.common.model.travelPolicy.BaseTravelPolicyMinimalPriceProperties;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicy;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicyAuthorizationScheme;
import com.gridnine.xtrip.common.model.travelPolicy.OrganizationTravelPolicyAuthorizationStep;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMinimalPriceRuleValue;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxyDeterminant;
import com.gridnine.xtrip.common.rules.elements.SimpleRuleProxyDeterminant;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CollectMinimalPricePropertiesProcessor
extends BaseProcessor {
    private String ruleTarget;

    public void configure(Map<String, String> parameters) {
        this.ruleTarget = parameters.get("rule-target");
    }

    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer clientCtr = EntityStorage.get().resolve(salesContext.getClient());
        EntityReference travelPolicyRef = ((Organization)clientCtr.getEntity()).getIbeTravelPolicy();
        if (travelPolicyRef == null) {
            return;
        }
        OrganizationTravelPolicy travelPolicy = (OrganizationTravelPolicy)EntityStorage.get().resolve(travelPolicyRef).getEntity();
        SimpleRuleProxyDeterminant determinant = new SimpleRuleProxyDeterminant(this.ruleTarget, new Date());
        HashSet<EntityReference<BaseTravelPolicyMinimalPriceProperties>> result = new HashSet<EntityReference<BaseTravelPolicyMinimalPriceProperties>>(CollectMinimalPricePropertiesProcessor.collect(travelPolicy.getRuleSet(), (RuleProxyDeterminant)determinant));
        OrganizationTravelPolicyAuthorizationScheme authorizationScheme = travelPolicy.getAuthorizationScheme();
        if (authorizationScheme != null) {
            result.addAll(authorizationScheme.getSteps().stream().map(OrganizationTravelPolicyAuthorizationStep::getRules).map(ruleSet -> CollectMinimalPricePropertiesProcessor.collect(ruleSet, (RuleProxyDeterminant)determinant)).flatMap(Collection::stream).collect(Collectors.toSet()));
        }
        if (!result.isEmpty()) {
            ctx.putObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_MINIMAL_PRICE_PROPERTIES, result);
        }
    }

    private static Set<EntityReference<BaseTravelPolicyMinimalPriceProperties>> collect(RuleSet ruleSet, RuleProxyDeterminant determinant) {
        if (ruleSet == null || ruleSet.getRules().isEmpty()) {
            return Collections.emptySet();
        }
        return ruleSet.getRules().stream().filter(rule -> rule.isApplicable(determinant)).map(CollectMinimalPricePropertiesProcessor::collect).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<EntityReference<BaseTravelPolicyMinimalPriceProperties>> collect(RuleSettings rule) {
        return rule.getRestrictions().stream().filter(rr -> rr.getProperty() == TravelPolicyProperties.TRAVEL_POLICY_CLIENT_TOTAL_DIFF_WITH_MINIMAL).map(rr -> ((TravelPolicyMinimalPriceRuleValue)rr.getValue()).getProperties()).collect(Collectors.toSet());
    }
}

