/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.minimalPrice;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAviaMinimalPriceProperties;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;

class FlightSearchParametersDelta {
    private final String flightSearchParametersUid = UUIDUtil.toString((UUID)UUID.randomUUID());
    private final FlightSearchParameters original;
    private final boolean changeServiceClass;
    private final boolean changeSkipConnected;
    private final boolean changeExcludeBaglessFares;
    private final boolean changeExcludeMultiTicket;
    private final boolean changeAirlines;
    private final boolean changeAirports;
    private final boolean changeTimeWindows;
    private final boolean changeFlightNumbers;

    FlightSearchParametersDelta(FlightSearchParameters original, TravelPolicyAviaMinimalPriceProperties properties) {
        this.original = original;
        this.changeServiceClass = !properties.isKeepServiceClass() && FlightSearchParametersDelta.hasToChangeServiceClass(original);
        this.changeSkipConnected = !properties.isKeepSkipConnected() && FlightSearchParametersDelta.hasToChangeSkipConnected(original);
        this.changeExcludeBaglessFares = !properties.isKeepExcludeBaglessFares() && FlightSearchParametersDelta.hasToChangeExcludeBaglessFares(original);
        this.changeExcludeMultiTicket = !properties.isKeepExcludeMultiTicket() && FlightSearchParametersDelta.hasToChangeExcludeMultiTicket(original);
        this.changeAirlines = !properties.isKeepAirlines() && FlightSearchParametersDelta.hasToChangeAirlines(original);
        this.changeAirports = !properties.isKeepAirports() && FlightSearchParametersDelta.hasToChangeAirports(original);
        this.changeTimeWindows = !properties.isKeepTimeWindows() && FlightSearchParametersDelta.hasToChangeTimeWindows(original);
        this.changeFlightNumbers = !properties.isKeepFlightNumbers() && FlightSearchParametersDelta.hasToChangeFlightNumbers(original);
    }

    public String getFlightSearchParametersUid() {
        if (this.isOriginal()) {
            throw new IllegalStateException("should not have been called for original flight");
        }
        return this.flightSearchParametersUid;
    }

    private static boolean hasToChangeServiceClass(FlightSearchParameters fsp) {
        return fsp.getServiceClass() != ClassOfService.ECONOMY;
    }

    private static boolean hasToChangeSkipConnected(FlightSearchParameters fsp) {
        return fsp.isSkipConnected();
    }

    private static boolean hasToChangeExcludeBaglessFares(FlightSearchParameters fsp) {
        return fsp.isExcludeBaglessFares();
    }

    private static boolean hasToChangeExcludeMultiTicket(FlightSearchParameters fsp) {
        return fsp.isExcludeMultiTicket();
    }

    private static boolean hasToChangeAirlines(FlightSearchParameters fsp) {
        return !fsp.getPreferredAirlines().isEmpty() || fsp.getRoute().stream().anyMatch(rs -> rs.getAirline() != null && rs.getFlightNumber() == null);
    }

    private static boolean hasToChangeAirports(FlightSearchParameters fsp) {
        return fsp.getRoute().stream().flatMap(rs -> Stream.of(rs.getLocationBegin(), rs.getLocationEnd())).distinct().anyMatch(FlightSearchParametersDelta::isAirportInMultiAirportCity);
    }

    private static boolean isAirportInMultiAirportCity(DictionaryReference<GeoLocation> locRef) {
        GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(locRef);
        if (loc.getType() == LocationType.CITY) {
            return false;
        }
        return DictHelper.findAirportsByCity((DictionaryReference)loc.getParent()).size() > 1;
    }

    private static boolean hasToChangeTimeWindows(FlightSearchParameters fsp) {
        return fsp.getRoute().stream().flatMap(rs -> Stream.of(rs.getDepartureTimeBegin(), rs.getDepartureTimeEnd(), rs.getArrivalTimeBegin(), rs.getArrivalTimeEnd())).anyMatch(Objects::nonNull);
    }

    private static boolean hasToChangeFlightNumbers(FlightSearchParameters fsp) {
        return !fsp.getFlightNumbers().isEmpty() || fsp.getRoute().stream().map(RouteSegment::getFlightNumber).anyMatch(Objects::nonNull);
    }

    FlightSearchParameters toFlightSearchParameters() {
        if (this.isOriginal()) {
            throw new IllegalStateException("should not have been called for original flight");
        }
        try {
            FlightSearchParameters result = (FlightSearchParameters)XCloneHelper.clone((XCloneable)this.original);
            result.setUid(this.flightSearchParametersUid);
            if (this.changeServiceClass) {
                FlightSearchParametersDelta.changeServiceClass(result);
            }
            if (this.changeSkipConnected) {
                FlightSearchParametersDelta.changeSkipConnected(result);
            }
            if (this.changeExcludeBaglessFares) {
                FlightSearchParametersDelta.changeExcludeBaglessFares(result);
            }
            if (this.changeExcludeMultiTicket) {
                FlightSearchParametersDelta.changeExcludeMultiTicket(result);
            }
            if (this.changeAirlines) {
                FlightSearchParametersDelta.changeAirlines(result);
            }
            if (this.changeAirports) {
                FlightSearchParametersDelta.changeAirports(result);
            }
            if (this.changeTimeWindows) {
                FlightSearchParametersDelta.changeTimeWindows(result);
            }
            if (this.changeFlightNumbers) {
                FlightSearchParametersDelta.changeFlightNumbers(result);
            }
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void changeServiceClass(FlightSearchParameters fsp) {
        fsp.setServiceClass(ClassOfService.ECONOMY);
    }

    private static void changeSkipConnected(FlightSearchParameters fsp) {
        fsp.setSkipConnected(false);
    }

    private static void changeExcludeBaglessFares(FlightSearchParameters fsp) {
        fsp.setExcludeBaglessFares(false);
    }

    private static void changeExcludeMultiTicket(FlightSearchParameters fsp) {
        fsp.setExcludeMultiTicket(false);
    }

    private static void changeAirlines(FlightSearchParameters fsp) {
        fsp.getPreferredAirlines().clear();
        fsp.getRoute().stream().filter(rs -> rs.getAirline() != null && rs.getFlightNumber() == null).forEach(rs -> rs.setAirline(null));
    }

    private static void changeAirports(FlightSearchParameters fsp) {
        fsp.getRoute().forEach(rs -> {
            rs.setLocationBegin(DictHelper.getCity((DictionaryReference)rs.getLocationBegin()));
            rs.setLocationEnd(DictHelper.getCity((DictionaryReference)rs.getLocationEnd()));
        });
    }

    private static void changeTimeWindows(FlightSearchParameters fsp) {
        fsp.getRoute().forEach(rs -> {
            rs.setDepartureTimeBegin(null);
            rs.setDepartureTimeEnd(null);
            rs.setArrivalTimeBegin(null);
            rs.setArrivalTimeEnd(null);
        });
    }

    private static void changeFlightNumbers(FlightSearchParameters fsp) {
        fsp.getRoute().stream().filter(rs -> rs.getFlightNumber() != null).forEach(rs -> {
            rs.setAirline(null);
            rs.setFlightNumber(null);
        });
    }

    boolean isOriginal() {
        return !this.changeServiceClass && !this.changeSkipConnected && !this.changeExcludeBaglessFares && !this.changeExcludeMultiTicket && !this.changeAirlines && !this.changeAirports && !this.changeTimeWindows && !this.changeFlightNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlightSearchParametersDelta that = (FlightSearchParametersDelta)o;
        return this.changeServiceClass == that.changeServiceClass && this.changeSkipConnected == that.changeSkipConnected && this.changeExcludeBaglessFares == that.changeExcludeBaglessFares && this.changeExcludeMultiTicket == that.changeExcludeMultiTicket && this.changeAirlines == that.changeAirlines && this.changeAirports == that.changeAirports && this.changeTimeWindows == that.changeTimeWindows && this.changeFlightNumbers == that.changeFlightNumbers;
    }

    public int hashCode() {
        return Objects.hash(this.changeServiceClass, this.changeSkipConnected, this.changeExcludeBaglessFares, this.changeExcludeMultiTicket, this.changeAirlines, this.changeAirports, this.changeTimeWindows, this.changeFlightNumbers);
    }
}

