/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.minimalPrice;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAviaMinimalPriceProperties;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyMinimalPriceWithSource;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.IBusTravelPolicyContextKeys;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.minimalPrice.FlightSearchParametersDelta;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.minimalPrice.MinimalPriceHelper;
import com.gridnine.xtrip.server.ibecorp.ibus.travelPolicy.minimalPrice.MinimalPriceSearchTarget;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PopulateAviaMinimalPricesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map ctxMap = (Map)ctx.getMandatoryObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_MINIMAL_PRICE_SEARCH_RESULT);
        MessageContext originalCtx = (MessageContext)ctxMap.get((Object)MinimalPriceSearchTarget.ORIGINAL);
        Collection<Flight> originalFlights = PopulateAviaMinimalPricesProcessor.getOriginalFlights(originalCtx);
        if (originalFlights.isEmpty()) {
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, new ArrayList());
            return;
        }
        MessageContext minimalCtx = (MessageContext)ctxMap.get((Object)MinimalPriceSearchTarget.MINIMAL);
        Map minimalSearchContexts = Optional.ofNullable((Map)minimalCtx.getObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_MINIMAL_PRICE_SEARCH_RESULT)).orElse(Collections.emptyMap());
        Map<String, TravelPolicyMinimalPriceWithSource> minimalPricesByUid = minimalSearchContexts.entrySet().stream().collect(Collectors.toMap(e -> ((FlightSearchParameters)e.getKey()).getUid(), e -> (TravelPolicyMinimalPriceWithSource)((MessageContext)e.getValue()).getMandatoryObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_MINIMAL_PRICE)));
        Map deltaData = (Map)minimalCtx.getMandatoryObject((Enum)IBusTravelPolicyContextKeys.TRAVEL_POLICY_MINIMAL_PRICE_GROUPED_PROPERTIES);
        Map<EntityReference<TravelPolicyAviaMinimalPriceProperties>, TravelPolicyMinimalPriceWithSource> minimalPrices = PopulateAviaMinimalPricesProcessor.getMinimalPricesByProperties(deltaData, minimalPricesByUid, () -> MinimalPriceHelper.calculateMinimalPrice(originalFlights));
        originalFlights.forEach(flight -> flight.getTravelPolicyMinimalPrices().putAll(minimalPrices));
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, originalFlights);
    }

    private static Collection<Flight> getOriginalFlights(MessageContext ctx) {
        ArrayList<Flight> result = new ArrayList<Flight>();
        Map mcres = (Map)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_MULTICALL_RESULT);
        if (mcres != null) {
            for (MessageContext subctx : mcres.values()) {
                Collection flights = (Collection)subctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
                if (flights == null) continue;
                result.addAll(flights);
            }
        }
        return result;
    }

    private static Map<EntityReference<TravelPolicyAviaMinimalPriceProperties>, TravelPolicyMinimalPriceWithSource> getMinimalPricesByProperties(Map<FlightSearchParametersDelta, List<EntityReference<TravelPolicyAviaMinimalPriceProperties>>> deltaData, Map<String, TravelPolicyMinimalPriceWithSource> minimalPricesByUid, Supplier<TravelPolicyMinimalPriceWithSource> minimalOriginalPriceSupplier) {
        HashMap<EntityReference<TravelPolicyAviaMinimalPriceProperties>, TravelPolicyMinimalPriceWithSource> result = new HashMap<EntityReference<TravelPolicyAviaMinimalPriceProperties>, TravelPolicyMinimalPriceWithSource>();
        for (Map.Entry<FlightSearchParametersDelta, List<EntityReference<TravelPolicyAviaMinimalPriceProperties>>> deltaEntry : deltaData.entrySet()) {
            FlightSearchParametersDelta delta = deltaEntry.getKey();
            TravelPolicyMinimalPriceWithSource minimalPrice = delta.isOriginal() ? minimalOriginalPriceSupplier.get() : minimalPricesByUid.get(delta.getFlightSearchParametersUid());
            for (EntityReference<TravelPolicyAviaMinimalPriceProperties> props : deltaEntry.getValue()) {
                result.put(props, minimalPrice);
            }
        }
        return result;
    }
}

