/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.ibecorp.rules.NotificationsActionSet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientMailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.NotificationSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationBalanceIndex;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.ibecorp.handlers.rules.NotificationBalancePropertySetImp;
import com.gridnine.xtrip.server.ibecorp.notifications.Notification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;

public class BalanceNotification
extends Notification {
    private NotificationRecipientMailTemplate template;
    private final OrganizationBalanceIndex index;
    public final NumberFormat priceFormat = new DecimalFormat("#0.00");

    @Override
    protected boolean isOldLogic() {
        return false;
    }

    public BalanceNotification(OrganizationBalanceIndex index, EntityReference<Organization> clientRef, EntityReference<Organization> agencyRef) {
        super(new NotificationParameters(clientRef, agencyRef, null, LocaleHelper.getCurrentLocale(), null));
        this.index = index;
        try {
            NotificationSettings notificationSettings = NotificationHelper.getNotificationSettings(clientRef, agencyRef, agencyRef, NotificationSettings::isUseBalanceSettings);
            if (notificationSettings != null) {
                RuleProxy proxy = new RuleProxy();
                proxy.getTracer().setDisabled(true);
                proxy.setProxyType(Targets.NOTIFICATION_TEMPLATE_BALANCE.getId());
                proxy.setProxyDate(new Date());
                proxy.setPropertySet((Object)new NotificationBalancePropertySetImp(index, clientRef, agencyRef));
                proxy.setActionSet((Object)new NotificationsActionSet());
                RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)notificationSettings.getRuleSet());
                this.template = ((NotificationsActionSet)proxy.getActionSet()).getBalanceNotificationTemplate();
                if (this.template != null) {
                    this.availableRecipientTypes.addAll(this.template.getRecipientTypes());
                    this.template.getAdditionalAddresses().forEach(this::addOtherRecipient);
                }
                this.addProperties();
            }
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper((String)"create BalanceNotification failed", (Throwable)ex, (Object[])new Object[0]);
        }
    }

    private void addProperties() {
        this.addProperty("balanceAgency", this.toString(this.index.getAgency()));
        this.addProperty("balanceClient", this.toString(this.index.getClient()));
        this.addProperty("availableAmount", this.toString(this.index.getAvailableAmount()));
        this.addProperty("balanceAmount", this.toString(this.index.getBalanceAmount()));
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"BalanceNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    public MailTemplate getTemplate() {
        return this.template;
    }

    private String toString(EntityReference ref) {
        return ref == null ? null : ref.toString();
    }

    private String toString(BigDecimal amount) {
        return amount == null ? null : this.priceFormat.format(amount);
    }
}

