/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.notifications;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.NotificationRecipientType;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.MailTemplate;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.notifications.Notification;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.slf4j.LoggerFactory;

public class CustomNotification
extends Notification {
    @Override
    protected NotificationType getNotificationType() {
        return NotificationType.SERVICES_ISSUED;
    }

    public CustomNotification(NotificationParameters parameters, Reservation reservation, List<BasicDocumentIndex> attachmentDocuments) throws ServiceException {
        super(parameters, Arrays.asList(NotificationRecipientType.BOOKING_AGENT, NotificationRecipientType.CUSTOMER, NotificationRecipientType.TRAVELLERS));
        try {
            if (reservation.getBookingFile().getSite() == null) {
                reservation.getBookingFile().setSite(parameters.getSiteRef());
            }
            this.addReservationProperties(reservation);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Add reservation properties to notification failed", (Throwable)e);
            this.addProperty("reservationPropertiesFailed", true);
        }
        try {
            EntityContainer bfCtr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(parameters.getOwnerRef());
            List docs = attachmentDocuments;
            if (docs == null) {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)bfCtr.toReference()));
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.TRAVELDOCUMENT), SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.SPECIAL_TRAVELDOCUMENT), SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.VOUCHER), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BasicDocumentIndex.Property.type.name(), (Object)DocumentType.RECEIPT), SearchCriterion.eq((String)BasicDocumentIndex.Property.contentType.name(), (Object)ContentType.JASPERPRINT)})}));
                docs = LogicalStorage.get().getEntityStorage().search(BasicDocumentIndex.class, query).getData();
            }
            for (BasicDocumentIndex idx : docs) {
                BaseFileDocument doc = (BaseFileDocument)((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(idx.getSource()).getEntity();
                if (idx.getContentType() == ContentType.JASPERPRINT) {
                    doc = NotificationHelper.convertJasper2Pdf(doc);
                }
                this.addDocument(doc);
            }
        }
        catch (Throwable t) {
            throw new ServiceException("failed to create custom notification", t);
        }
    }

    @Override
    public String getDefaultSubject(Locale locale) {
        return L10nResourcesManager.getStr((String)"TicketingNotification_Subject", (Locale)locale, (Object[])new Object[0]);
    }

    @Override
    public MailTemplate getTemplate() {
        SMNotificationsSettings notificationsSettings = this.getNotificationSettings();
        ProductType productType = this.getProductType();
        if (productType == ProductType.RAILWAY_PRODUCT) {
            return notificationsSettings.getRailwayTemplates().getServicesIssuedNotification();
        }
        if (productType == ProductType.AIR_TICKET) {
            return notificationsSettings.getServicesIssuedNotification();
        }
        if (productType == ProductType.HOTEL_RESERVATION) {
            return notificationsSettings.getHotelTemplates().getServicesIssuedNotification();
        }
        if (productType == ProductType.TRANSFER) {
            return notificationsSettings.getTransferTemplates().getServicesIssuedNotification();
        }
        return null;
    }
}

